# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        光模块状态检查：
        1 如果光模块不存表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show port fibre_module|filterColumn include columnList=PortID,Health\sStatus"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.fibre.module.info")
            LOGGER.logNoPass("annot get information about port fibre module")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            portId = line["PortID"]
            healthStatus = line["Health Status"]
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.fibre.module.health.status.abnormal", 
                    (portId, healthStatus))
                LOGGER.logNoPass("The Health Status of port [%s] is abnormal (Health Status:%s)" % 
                    (portId, healthStatus))
        
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
