# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        LUN拷贝健康状态检查：
        1 如果LUN拷贝不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show lun_copy general"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(checkRet[0], cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.lun.copy.info")
            logger.logNoPass("Cannot get information about LUN copy")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line["ID"]
            healthStatus = line["Health Status"]
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(lang, "lun.copy.health.status.abnormal", (Id, healthStatus))
                logger.logNoPass("The Health Status of LUN copy [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
        
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
