# -*- coding: UTF-8 -*-

#BBU满配规格，键表示设备类型，值表示单个引擎下BBU的满配规格
BBU_OF_ENGINE_CONFIG_DICT = {
"S2600T":2,
"S5500T":2,
"S5600T":4,
"S5800T":4,
"S6800T":4,
"2200 V3":2,
"2600 V3":2,
"2600 V3 for Video":2,
"2800 V3":2,
"5110 V5":2,
"5300 V3":2,
"5500 V3":2,
"5600 V3":2,
"5800 V3":3,
"6800 V3":4,
"6900 V3":4,
"HVS85T":4,
"HVS88T":4,
"18500":4,
"18800":4,
"18800F":4,
"18500 V3":4,
"18800 V3":4,
"Dorado6000 V3":4,
"Dorado5000 V3":2,
"Dorado3000 V3":2,
}

#风扇满配规格,键[1]表示框类型，键[2]表示高度(U)，键[4]表示是否为高密框，值表示风扇个数
FAN_CONFIG_DICT = {
("ENG", "2", "--"):2, #2U引擎框
("CTE", "2", "--"):2, #2U引擎框
("ENG", "3", "--"):6, #3U引擎框
("CTE", "3", "--"):6, #3U引擎框
("ENG", "4", "--"):3, #4U引擎框（盘框一体）
("CTE", "4", "--"):3, #4U引擎框（盘框一体）
("DAE", "2", "--"):2, #2U普通硬盘框
("DAE", "4", "high-density"):2, #4U高密硬盘框
("DAE", "4", "--"):4, #4U普通硬盘框
("DSW", "1", "--"):2, #PCIe交换框
}

#检查项所涉及的产品版本，如果都涉及则为ALL
CHECK_ITEMS_INVOLVED_VERSIONS = {
    "check_cli_service_alsLinkStatus":[
                                        "V100R001C20",
                                        "V100R001C20B013",
                                        "V100R001C20LNLT01",
                                        "V100R001C20SPC100",
                                        "V100R001C20SPC200",
                                        "V300R001C10",
                                        "V300R001C10B012",
                                        "V300R001C10SPC100",
                                        "V300R001C10SPC200",
                                        "V300R002C00",
                                        "V300R002C00SPC100",
                                        "V300R002C10",
                                        "V200R002C20",
                                        "V200R002C20B013",
                                        "V200R002C20SPC200",
                                        ],
    "check_cli_service_NFSsharedFault":[
                                         "V300R002C10",
                                         "V300R002C10SPC100",
                                        ],
    "check_cli_service_IPv6LockService":[
                                          "V300R002C00",
                                          "V300R002C00SPC100",
                                          "V300R002C10",
                                          "V300R002C10SPC100",
                                        ],
    "check_cli_service_iSNSIPv6Service":[
                                        "V100R001C20",
                                        "V100R001C20B013",
                                        "V100R001C20LNLT01",
                                        "V100R001C20SPC100",
                                        "V100R001C20SPC200",
                                        "V300R001C10",
                                        "V300R001C10B012",
                                        "V300R001C10SPC100",
                                        "V300R001C10SPC200",
                                        "V300R002C00",
                                        "V300R002C00SPC100",
                                        "V200R002C20",
                                        "V200R002C20B013",
                                        "V200R002C20SPC200",
                                        ],
    "check_cli_service_ioStatus":["ALL"],
    "check_cli_service_cachePartitionFaultPage":["ALL"],
    "check_cli_service_ioDetect":[
                                 "V100R001C30SPC200",
                                 "V100R001C30SPC300",
                                 "V200R002C30SPC200",
                                 "V200R002C30SPC300",
                                 "V300R001C20SPC200",
                                 ],
}

# 风险路径字典元组
RISK_VERSION_PATH = (
                     {"curVersion":"V300R001C20SPC100", "upgradePkgVersion":"V300R002C10SPC100"},
                     {"curVersion":"V300R001C20SPC100", "upgradePkgVersion":"V300R002C10SPC200"},
                     {"curVersion":"V300R001C20", "upgradePkgVersion":"V300R002C10SPC100"},
                     {"curVersion":"V300R001C20", "upgradePkgVersion":"V300R002C10SPC200"},
                     {"curVersion":"V300R001C10B012", "upgradePkgVersion":"V300R001C20SPC200"},
                     )

#某类告警id的告警全集配置字典
alarmIdDict = {
"encloSigLinkAlarm":['0xF00CE002A'],
"intfCardAlarm":['0xF0D10006', '0xF00D10020', '0xF00D1003D', '0xF0D10008'],
"casecadeAlarm":['0xF0050003', '0xF00D00018'],
"ctrlFaultAlarm":['0xF0CF0003', '0xF00CF005F'],
"diskSigLinkAlarm":['0xF00A000C', '0xF000A0112'],
}

SERIES_T = "T_SERIES"
SERIES_V3 = "V3_SERIES"
SERIES_ARM = "ARM_SERIES"
SERIES_Dorado = "Dorado_SERIES"
SERIES_18000V3 = "18000V3_SERIES"
SERIES_18000 = "18000_SERIES"

STOR_DEV_INFO_DICT = {
"S2600T":SERIES_T,
"S5500T":SERIES_T,
"S5600T":SERIES_T,
"S5800T":SERIES_T,
"S6800T":SERIES_T,
"2200 V3":SERIES_ARM,
"2600 V3":SERIES_ARM,
"2600 V3 for Video":SERIES_ARM,
"2800 V3":SERIES_V3,
"5110 V5":SERIES_ARM,
"5300 V3":SERIES_V3,
"5500 V3":SERIES_V3,
"5600 V3":SERIES_V3,
"5800 V3":SERIES_V3,
"6800 V3":SERIES_V3,
"6900 V3":SERIES_V3,
'Dorado3000 V3':SERIES_Dorado,
'Dorado5000 V3':SERIES_Dorado,
'Dorado6000 V3':SERIES_Dorado,
"HVS85T":SERIES_18000,
"HVS88T":SERIES_18000,
"18500":SERIES_18000,
"18800":SERIES_18000,
"18800F":SERIES_18000,
"18500 V3":SERIES_18000V3,
"18800 V3":SERIES_18000V3,
}

##---------18000 V3高端不配套硬盘的编码黑名单，共56个-----------##
DISK_BLACK_ITEMS = ['02350RRF', '02350WLE', '02350RRH', '02350WLG', '02350PMF', '02350SQN',
                   '02350JDA', '02350JDF', '02350BVU', '02350NWU', '02359658', '02350NWY',
                   '02350EEM', '02350NXB', '02350SQP', '02350NXE', '02350RTF', '02350RTP',
                   '02358406', '02358407', '02350HGL', '02358408', '02350CDV', '02350HGM',
                   '02350GDA', '02350ECX', '02350ECY', '02359659', '02359660', '02358403',
                   '02359657', '02358404', '02350HGG', '02350EDL', '02350HGJ', '02350MQG',
                   '02350CAW', '02350CAY', '02350CBA', '02350CBB', '02350CBC', '02350CBD',
                   '02350CBE', '02350CBF', '02350DXU', '02350DXV', '02350STQ', '02350STR',
                   '02350GMR', '02350GMP', '02350VVE', '02350VVF', '02350LGX', '02350LHE',
                   '02350LGY', '02350LHF' 
                   ]

#不允许升级的路径
UPG_PATH_BLACK_DICT = {
        'V300R001C10':['V300R003C20'], #V300R001C10不支持升级到V300R003C20及SPC版本
        'V300R001C10SPC100':['V300R003C20'],
        'V300R001C10SPC200':['V300R003C20'],
}
EXPSAS4U_75_LIST = ['21'] #高密框的枚举值

# check_tlv_software_sysResource检查项阈值为200M的设备
MEMORY_DEVS_180 = ["2100 V3", "2200 V3", "2200 V3 Enhanced", "2600 V3 Enhanced", "2600 V3", "2600F V3",
                   "2600F V3 Enhanced", "2600 V3 for Video", "2800 V3", "2800 V5", "5100 V3", "5300 V3",
                   "5300 V5", "5300F V5", "5300 V5 Enhanced"]
MEMORY_DEVS_200 = ["S2600T", "S5500T", "5500 V3", "5500 V5", "5500 V5 Elite", "5500F V3", "5500F V5"]
MEMORY_DEVS_270 = ["5600 V3", "5600F V3", "5600 V5", "5600F V5", "5800 V3", "5800F V3",
                   "5800 V5", "5800F V5", "6800 V3", "6800F V3", "6800 V5", "6800F V5"]
MEMORY_DEVS_400 = ["18500 V3", "18500F V3", "18500 V5", "18500F V5", "18800 V3", "18800F V3",
                   "18800 V5", "18800F V5"]
# cli_software_hcDlmCheckBefore对应补丁提示
HOT_PATCH_DICT = {"V300R006C10SPC100": "V300R006C10SPH101",
                  "V500R007C00SPC100": "V500R007C00SPH101"}