# -*- coding: UTF-8 -*-
from frame.common import common
from frame.common.config import alarmIdDict
from frame.context import contextUtil


def execute(context):
    '''
    @summary: 控制器故障检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    #当前检查项告警ID全集
    alarmIds = alarmIdDict.get('ctrlFaultAlarm')
    checkRet = common.isAlarmsExist(cli, lang, logger, alarmIds)
    return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])