# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil
from frame.common.regex import Regex

RUN_MODE_LIST = ["FCOE", "FCOE/ISCSI", "CLUSTER"]
E_LABEL_ITEM = "ITEM=03022VGB"
E_LABEL_ITEM_VALUE="03022VGB"

def execute(context):
    '''
    1、命令show interface_module interface_module_id=xxx(ID为4x10GE Electrical Interface Module所对应的ID)回显Electronic Label字段中Item等于03022VGB则不通过；
    2、命令show interface_module interface_module_id=xxx（ID为4 port SmartIO I/O Module所对应的ID）回显Run mode字段为FCoE/iSCSI或者Cluster则不通过。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRetAll = ""
    errMsg = ""
    flag = True
    sourceVersionList = ['V300R002C10','V300R002C10SPC100']

    try:
        curentVersion = common.formatVersion(contextUtil.getCurVersion(context))
        LOGGER.logInfo("curentVersion: %s" % curentVersion)
        if curentVersion not in sourceVersionList:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg)
            
        #普通用户模式执行show interface_module
        cmd = "show interface_module"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += checkRet[1]
        
        #不存在任何接口卡
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return common.getUpgEvaluationRs(True, cliRetAll, errMsg)
        
        if checkRet[0] != True: 
            errMsg += checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        elecInfIdList = []
        smartIoIdList = []
        
        for cliRetLines in cliRetLinesList:
            model = cliRetLines.get("Model")
            intfId = cliRetLines.get("ID")
            runningStatus = cliRetLines.get("Running Status")
            if model.upper() == '4x10GE Electrical Interface Module'.upper() and runningStatus == common.STATUS_RUNNING:
                elecInfIdList.append(intfId)
                continue
            if model.upper() == '4 port SmartIO I/O Module'.upper() and runningStatus == common.STATUS_RUNNING:
                smartIoIdList.append(intfId)
        
        #普通用户模式执行show interface_module interface_module_id=xxx
        LOGGER.logInfo("ElecInfIdList:%s,smartIoIdList:%s" %(elecInfIdList, smartIoIdList))
        
        cmd = "show interface_module interface_module_id=%s"
        for intfId in elecInfIdList:
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%intfId, True, LANG)
            cliRetAll += checkRet[1]
            
            if checkRet[0] != True: 
                errMsg += checkRet[2]
                return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
            
            if existSpecItem(checkRet[1]):
                flag = False
                errMsg += common.getMsg(LANG, "check.iocInterfaceModule.ioc.notpass", (intfId,E_LABEL_ITEM_VALUE))
                LOGGER.logNoPass("Slot [ID:%s]: 4x10GE Electrical Interface Module exists and the item in Electronic Label is %s." % (intfId, E_LABEL_ITEM_VALUE))
                
        for intfId in smartIoIdList:
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%intfId, True, LANG)
            cliRetAll += checkRet[1]

            if checkRet[0] != True: 
                errMsg += checkRet[2]
                return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
             
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
            runMode = cliRetLinesList[0].get("Run Mode")
            if runMode.upper() in RUN_MODE_LIST:
                flag = False
                errMsg += common.getMsg(LANG, "check.iocInterfaceModule.smartio.notpass", (intfId, runMode))
                LOGGER.logNoPass("Slot [ID:%s]: A 4-port SmartIO I/O Module exists and the running mode is %s." % (intfId, runMode))
              
        return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
        
    except Exception, exception: 
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, 'query.result.abnormal'))

def existSpecItem(cliRet):
    cliRetList = cliRet.encode("utf8").splitlines()
    for line in cliRetList:
        if Regex.search(E_LABEL_ITEM, line, flags=Regex.IGNORECASE):
            return True
    return False