# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        PCIe交换机状态检查：
        1 Health Status为Normal且Running Status为Online表示正常；
        2 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show enclosure"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        dataSwitchList = []
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.enclosure.info")
            logger.logNoPass("Cannot get information about enclosure")
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        for line in cliRetLinesList:
            logicType = line["Logic Type"]
            frameId = line["ID"]
            if not "Data Switch" in logicType:
                continue
            else:
                dataSwitchList.append(frameId)
                
            healthStatus = line["Health Status"]
            runningStatus = line["Running Status"]
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(lang, "dataswitch.health.status.abnormal", (frameId, healthStatus))
                logger.logNoPass("The Health Status of Data Switch [%s] is abnormal (Health Status:%s)" 
                     % (frameId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(lang, "dataswitch.running.status.abnormal", (frameId, runningStatus))
                logger.logNoPass("The Running Status of Data Switch [%s] is abnormal (Running Status:%s)" 
                     % (frameId, runningStatus))
        
        checkRetPCIePortExists = common.checkPCIePortExists(cli, lang)
        if checkRetPCIePortExists[0] != True:
            errMsg = checkRetPCIePortExists[2]
            logger.logNoPass("Cannot get information about PCIe switch")
            cliRet += checkRetPCIePortExists[1]
            return common.getUpgEvaluationRs(checkRetPCIePortExists[0], cliRet, errMsg)
        
        isCheckPCIePortExists = checkRetPCIePortExists[1]
        if isCheckPCIePortExists and len(dataSwitchList) < 2:
            errMsg = common.getMsg(lang, "pcie.switch.number.not.enough")
            logger.logNoPass("The number of PCIe switch is not enough")
            return common.getUpgEvaluationRs(False, cliRet, checkRet[2])
        
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception: 
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
