# -*- coding: UTF-8 -*-
import traceback
import os
import re

from frame.common import common
from frame.common.regex import RegPattern
from frame.cli import cliUtil
from frame.context import contextUtil


def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check whether IO is suspended or not
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (integer, string, string)
    '''
    flag = True
    cliRet = ''
    errMsg = ''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getIOdetectEvaluationRsNoInvolved()
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdTupList = contextUtil.getItem(context, "allCtrlsIp")
        if not ctrlIpAndIdTupList:
            #无法获取控制器ip
            logger.logInfo(common.getMsg(lang, 'cannot.ctrl.id.ip'))
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, 'cannot.ctrl.id.ip'))
        
        #将回显和控制器信息拼接起来
        cliRetList = []
        resultList = []
        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdTupList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            checkRet = checkEachCtrlIoDetect(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            
            if checkRet[0] != cliUtil.RESULT_NOCHECK:
                cliRetList.append(common.CONTROLLER_INFO % (ctrlId))
                cliRetList.append(checkRet[1] + "\n")
                
            resultList.append(checkRet[0])
            #中间变量保存显示信息。
            midMsg = checkRet[2]
            if checkRet[0] is True:#通过
                midMsg = common.getMsg(lang, "controller.check.pass")
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
            
        flag = common.getCheckResult(resultList)
        logger.logInfo("resultList flag is:%s" % str(resultList))
        cliRet = '\n'.join(cliRetList)
        return common.getUpgEvaluationRs(flag, cliRet.strip(), errMsg)
    except Exception, exception: 
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet.strip(), common.getMsg(lang, 'query.result.abnormal'))


def checkEachCtrlIoDetect(context, ctrlIps, ctrlId):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ''
    errMsg = ''
    logger.logInfo('start checking controller[%s]' % ctrlId)
    
    curCtrlIp = contextUtil.getCurCtrlIp(context)
    ctrlIp = ''
    if re.match(RegPattern.IPV4, curCtrlIp):#IPV4
        ctrlIp = ctrlIps[0]
    else:#IPV6
        ctrlIp = ctrlIps[1]
    
    if curCtrlIp == ctrlIp:#当前控制器直接获取
        cli = contextUtil.getSSH(context)
    else:#新建cli连接
        #先使用ipv4创建，如果失败再用ipv6创建
        cli = contextUtil.createCliConnection(context, ctrlIps[0])
        if cli is None:
            cli = contextUtil.createCliConnection(context, ctrlIps[1])
    
    if cli == None:
        logger.logInfo('create controller [%s] cli connection failed' % ctrlId)
        errMsg = common.getMsg(lang, 'cannot.create.controller.cli')
        return (cliUtil.RESULT_NOCHECK, '', errMsg)
    
    try:
        #查询是否有IO挂住：回显第二行为False表示检查通过，True表示不通过。
        cmd = 'iodetect show'
        flag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang, contextUtil.getDeveloperPwd(context))
        if flag != True:
            logger.logSysAbnormal()
            return (flag, cliRet, errMsg)
        SecondRowResult = getSecondRowResult(cliRet)
        if False == SecondRowResult:
            errMsg = common.getMsg(lang, 'check.io.detect.notpass')
            return (False, cliRet, errMsg)
        return (True, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        if curCtrlIp != ctrlIp:
            cliUtil.closeCliConnection(cli)

def getSecondRowResult(cliRet):
    '''
    @summary: get the result of 2nd row
    @param cliRet: the CLI information of command 'iodetect show'
    @return: the status of iodetect
    '''
    #返回True代表当前系统无IO挂起，返回False代表当前系统有IO挂起
    lineList = cliRet.splitlines()
    if len(lineList)>1 and 'False' == lineList[1].strip():
        return True
    else:
        return False
  
