# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

TARGET_VERSION_LIST = ['V300R003C20','V300R003C20SPC100','V300R006C00']

def execute(context):
    '''
            双活配置检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        curVersion = contextUtil.getTargetVersion(context)
        if curVersion not in TARGET_VERSION_LIST:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        checkResult = checkHyperMetroConfig(cli,logger,lang)
        
        flag = checkResult[0]
        cliRet += checkResult[1]
        errMsg += checkResult[2]
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))    
    
def checkHyperMetroConfig(cli,logger,lang):
    '''
    @summary: 检查是否存在双活
    @param cli: cli对象
    @return: (flag, cliRet, errMsg)
        flag: 
            True: 不存在
            False: 存在
        cliRet: 
            Flag为True时，返回设备上的信息
            Flag为False时，返回cli回显结果
        errMsg: 错误消息
        suggestionInfo:修改建议
    '''
    errMsg = ""
    hyperMetroIDList = []
    
    cmd = "show hyper_metro_pair general"
    logger.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        logger.logSysAbnormal()
        return checkRet
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)
    
    errMsg = common.getMsg(lang, "hyper.metro.pair.info.exists")
    logger.logNoPass("HyperMetro pair is configured.")
    return (False, cliRet, errMsg)
    
    
