# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
import re

ALL_CLI_RET = ''
progressItem = "cli_software_dns_ad_ldap_nis_ip"

def execute(context):
    """
    CIFS共享配置检查。
    """
    global ALL_CLI_RET
    LANG = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    try:
        # CIFS共享配置检查版本范围
        curVersion = contextUtil.getCurVersion(context)

        context["checkState"] = common.PROCESS_STATE_CHECKING
        common.threadUp(context, progressItem)
        if curVersion != "V300R002C00" and curVersion != "V300R002C00SPC100" and curVersion != "V300R002C10":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, "")

        cmdDict = {"Dns Server": "show dns_server general", "Domain Ldap": "show domain ldap", "Domain Nis": "show domain nis"}

        if curVersion == "V300R002C10":
            cmdDict.pop("Dns Server")

        ipListDict, cmdFailList = getIPs(cmdDict, logger, cli, LANG)
        if len(cmdFailList) != 0:
            cmdFailListStr = ",".join(cmdFailList)
            cmdErrMsg = common.getMsg(LANG, "get.ip.fail", cmdFailListStr)
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, ALL_CLI_RET, cmdErrMsg)

        if len(ipListDict) == 0:
            return common.getUpgEvaluationRs(True, ALL_CLI_RET, "")

        isSuccess, errMsg = checkIpV4IsReachable(ipListDict, logger, cli, LANG)
        return common.getUpgEvaluationRs(isSuccess, ALL_CLI_RET, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, ALL_CLI_RET,
                                         common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        common.finishProcess(context, progressItem)
        logger.logInfo("enter cli mode from some model ret is %s" % str(ret))


def getIPs(cmdDict, LOGGER, cli, LANG):
    global ALL_CLI_RET
    cmdFailList = []
    ipListDict = {}
    for cmdkey in cmdDict:
        cliFlag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmdDict.get(cmdkey), True, LANG)
        ALL_CLI_RET += "\n" + cliRet
        if cliFlag is not True:
            cmdFailList.append(cmdkey)
            continue
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)

        # 不可达的IP
        for retDict in cliRetLinesList:
            ipAddressList = retDict.get("IP Address List")

            if not ipAddressList or ipAddressList == "--":
                continue
            ipV4List = []
            if ipAddressList.find(",") != -1:
                ipV4List = ipAddressList.split(",")
            else:
                ipV4List = ipAddressList.split()
            ipListDict[cmdkey] = ipV4List
    LOGGER.logInfo("All ip are:%s,All failed ip are:%s." % (str(ipListDict),(cmdFailList)))
    return ipListDict, cmdFailList


def checkIpV4IsReachable(ipListDict, LOGGER, cli, LANG):
    unReachableIpDict = {}
    errMsg = ""
    LOGGER.logInfo("All ip wait for check:%s" % str(ipListDict))
    for ipType in ipListDict:
        tempIpList = []
        ipV4List = ipListDict.get(ipType)

        for ipV4 in ipV4List:
            issuccess = pingIpV4InMiniSystem(cli, ipV4, LANG)
            if issuccess == True :
                continue
            elif issuccess == False:
                tempIpList.append(ipV4)
            else:
                return issuccess, cliUtil.getMsg(LANG, "system.status.abnormal")
        if len(tempIpList) != 0:
            unReachableIpDict[ipType] = tempIpList

    LOGGER.logInfo("can't connect ip are: %s" % str(unReachableIpDict))
    if len(unReachableIpDict) != 0:
        for unReachableIp in unReachableIpDict:
            errMsg += common.getMsg(LANG, "ping.ip.fail",
                                    (unReachableIp, ",".join(unReachableIpDict.get(unReachableIp))))
        return False, errMsg
    return True, ''


def pingIpV4InMiniSystem(cli, ip, lang):
    global ALL_CLI_RET
    cmd = "ping -c 5 %s" % ip
    flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
    ALL_CLI_RET += "\n" + cliRet
    if flag is not True:
        return cliUtil.RESULT_NOCHECK

    if re.search("ttl=", cliRet, re.I):
        return True

    return False
