# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

smallerConvergedRistVers = {"riskVer": "V300R006C10",
     "targetStart": "V300R006C10", "targetEnd": "V300R006C50SPC100"}

smallerDoradoRiskVers = {"riskVer":"V300R001C01",
     "targetStart": "V300R001C01", "targetEnd": "V300R002C00SPC100"}

biggerRiskVers = [
    {"riskVer": "V300R006C20+V300R006C20SPH012",
     "targetStart": "V300R006C20", "targetEnd": "V300R006C50SPC100"},
    {"riskVer": "V500R007C10+V500R007C10SPH012",
     "targetStart": "V500R007C20", "targetEnd": "V500R007C30SPC100"},
]

def execute(context):
    '''
    HP主机host lun0风险检查。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    try:
        flag, hotPatchVersion, ret, errMsg = common.getHotPatchVersion(cli, LANG)
        cliRet += ret
        if flag != True:
            return common.getUpgEvaluationRs(True, cliRet, errMsg)

        productModel = contextUtil.getDevType(context)
        curVersion = contextUtil.getCurVersion(context)
        targetVersion = contextUtil.getTargetVersion(context)
        if not checkRiskVer(productModel, curVersion, hotPatchVersion, targetVersion):
            LOGGER.logInfo("The version is involved, curVersion:%s,hotPatchVersion:%s,targetVersion：%s"
                           % (curVersion, hotPatchVersion, targetVersion))
            return common.getUpgEvaluationRs(True, cliRet, errMsg)

        flag, ret, errMsg = checkHpuxHost(cli, LANG)
        cliRet += ret
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def getVer(verInfo):
    '''
    获取系统版本和补丁版本
    :param verInfo:
    :return:
    '''
    if "+" in verInfo:
        vers = verInfo.split("+")
        return vers[0],vers[1]

    return verInfo,""

def checkRiskVer(productModel, currentVer, patchVer, targetVer):
    '''
     检查是否在影响版本范围内
    :param productModel: 设备型号
    :param currentVer: 当前系统版本
    :param patchVer: 补丁版本
    :return:
    '''
    if patchVer == "--":
        patchVer = ""

    if common.isDorado(productModel):
        if currentVer < smallerDoradoRiskVers.get("riskVer"):
            targetStart = smallerDoradoRiskVers.get("targetStart")
            targetEnd = smallerDoradoRiskVers.get("targetEnd")
            if targetVer >= targetStart and targetVer <= targetEnd:
                return True
        return False
    else:
        if currentVer < smallerConvergedRistVers.get("riskVer"):
            targetStart = smallerConvergedRistVers.get("targetStart")
            targetEnd = smallerConvergedRistVers.get("targetEnd")
            if targetVer >= targetStart and targetVer <= targetEnd:
                return True
            return False
        else:
            for verInfo in biggerRiskVers:
                riskSys, riskPatch = getVer(verInfo.get("riskVer"))
                if currentVer != riskSys:
                    continue

                if riskPatch and patchVer < riskPatch:
                    continue

                targetStart = verInfo.get("targetStart")
                targetEnd = verInfo.get("targetEnd")
                if targetVer >= targetStart and targetVer <= targetEnd:
                    return True
        return False

def checkInitiator(cli, lang, hostId):
    '''
    :param cli:
    :param lang:
    :param hostId:
    :return: 不存在在线启动器返回True
    '''
    result, cliRet, errMsg, initiators = cliUtil.getHostInitiator(cli, lang, hostId)
    if result != True:
        errMsg = common.getMsg(lang, "check.hpux.gethostiniterr", hostId)
        return result, cliRet, errMsg

    if not initiators:
        return True, cliRet, errMsg

    for obj in initiators:
        status = obj.get("Running Status")
        if status == "Online":
            return False, cliRet, ""
    return True, cliRet, ""

def checkHpuxHost(cli, lang):
    '''
    检查主机是否映射LUN0
    :param cli:
    :param lang:
    :return:
    '''
    checkFlag = True
    allCliRet = ""
    allErrMsg = ""
    flag, cliRet, errMsg, hosts = cliUtil.getHost(cli, lang)
    allCliRet += cliRet
    if flag != True:
        allErrMsg += common.getMsg(lang,"check.hpux.gethosterr")
        return flag, allCliRet, allErrMsg

    if not hosts:
        return True, cliRet, ""

    errHosts = []
    for host in hosts:
        operSys = str(host.get("Operating System"))
        if operSys.upper() != "HP-UX":
            continue

        hostId = host.get("ID")

        result, cliRet, errMsg = checkInitiator(cli, lang, hostId)
        allCliRet += cliRet
        # 不存在在线启动器
        if result == True:
            continue

        #查询启动器失败
        if errMsg:
            checkFlag = False
            allErrMsg += errMsg
            return checkFlag, allCliRet, allErrMsg

        result, cliRet, errMsg, luns = cliUtil.getHostLun(cli, lang, hostId)
        allCliRet += cliRet
        if result != True:
            checkFlag = False
            allErrMsg += common.getMsg(lang, "check.hpux.gethostlunerr", hostId)
            return checkFlag, allCliRet, allErrMsg

        if not luns:
            continue

        isExistLun0 = False
        for lun in luns:
            lunId = lun.get("Host LUN ID")
            if lunId == "0":
                isExistLun0 = True
                break

        if not isExistLun0:
            checkFlag = False
            errHosts.append(hostId)

    if errHosts:
        errString = ""
        errHosts.sort()
        for i in range(0,len(errHosts)):
            if i%10 == 0:
                errString += "\n"
            if i == len(errHosts) - 1:
                errString += errHosts[i]
            else:
                errString += errHosts[i] + ","

        allErrMsg += common.getMsg(lang, "check.hpux.have.lun0", errString)

    return checkFlag, allCliRet, allErrMsg

