# -*- coding: UTF-8 -*-

from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
import traceback

devVersionCheckList = ['V300R002C10SPC200', 'V300R003C00SPC100', 'V300R003C10', 'V300R003C10SPC100', 'V300R003C20', 'V300R003C20SPC100', 'V300R003C20SPC200', 'V300R006C00', 'V300R006C00SPC100']
devTypeCheckList = ['5300 V3', '5500 V3']
historyVersionCheckList = ['V300R002C00', 'V300R002C00SPC100', 'V300R002C10', 'V300R002C10SPC100', 'V300R003C00', 'V300R002C10SPC200', 'V300R003C00SPC100', 'V300R003C10', 'V300R003C10SPC100', 'V300R003C20', 'V300R003C20SPC100', 'V300R003C20SPC200', 'V300R006C00', 'V300R006C00SPC100']
def execute(context):

    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    targetVersion = contextUtil.getTargetVersion(context)
    if targetVersion >= "V300R006C10":
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")

    cli = contextUtil.getSSH(context)
    ok, getProductModelRet, cliRet= cliUtil.getProductModel(cli, lang)
    _, currentVersion, _ = common.getDevVersion(cli, lang, logger)
    if getProductModelRet not in devTypeCheckList or currentVersion not in devVersionCheckList:
        return common.getUpgEvaluationRs(True, cliRet, "")

    ok, historyVersionLst, cliRet = getSoftwareHistoryVersionLst(cli, lang, logger)
    if not ok or not historyVersionLst:
        logger.logNoPass("execute show upgrade package is failed")
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.historyVersion.abnormal"))

    for oneVersion in historyVersionLst:
        if oneVersion in historyVersionCheckList:
            logger.logNoPass("The device's history version is in check list")
            return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.historyVersion.result.notpass", oneVersion))
    logger.logPass()
    return common.getUpgEvaluationRs(True, cliRet, "")


def getSoftwareHistoryVersionLst(cli, lang, logger):
    '''
    @summary: 获取历史版本
    @return: 检查是否成功，历史版本号，cli回显，errMsg
    '''
    cliRet = ""
    devVersionLst = []
    try:
        cmd = "show upgrade package"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if not checkRet[0]:
            return False, devVersionLst, checkRet[1]
        cliRet = checkRet[1]
        endIndex = cliRet.find('HotPatch Version')
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet[:endIndex])
        devVersionLst = [oneLst['History Version'] for oneLst in cliRetDictList]
        return True, devVersionLst, cliRet

    except:
        logger.logException(str(traceback.format_exc()))
        return False, devVersionLst, cliRet