# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    @summary: 系统配置数据检查
    '''
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        cmd = "show system configuration_log"
        cliRets = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
        cliRet = cliRets[1]
        
        if cliRets[0] != True:
            return common.getUpgEvaluationRs(cliRets[0], cliRets[1], cliRets[2])
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, "")
        else:
            return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang,"check.system_config.log.notpass"))
         
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))