# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

CHECK_MODULE_DICT = {"DIF_MID_VOLUME":"3"}
NEED_CHECK_VER = "V300R002C10SPC200"

def execute(context):
    '''
        LUN状态检查: 
                      如果不存在相应的记录表示正常，否则属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        devVersion = contextUtil.getCurVersion(context)
        if devVersion != NEED_CHECK_VER:
            logger.logInfo("current dev version(%s) do not need check." %devVersion)
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cmd = "dif showverifylevel"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "query.result.abnormal")
            logger.logNoPass("Cannot get information about dif")
            return common.getUpgEvaluationRs(False, cliRet, checkRet[2])

        for line in cliRetLinesList:
            moduleName = line["module name"].upper()
            verifyLevel = line["verify level"]
            checkLevel = CHECK_MODULE_DICT.get(moduleName,None)
            if checkLevel == verifyLevel:
                flag = False
                errMsg += common.getMsg(lang, "dif.module.verify.level.trace", verifyLevel)
                logger.logNoPass("The verify level of DIF_MID_VOLUME is %s" % verifyLevel)
            
        if flag==True:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
