# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 检查硬盘是否在线诊断
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""
        checkItem = "CHECK_DISK_ISDISKDIAGNOSE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        errMsgList = []#保存错误信息的列表
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsgList.append(common.getMsg(lang, "check.result.abnormal", nodeId))
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsgList.append(common.getMsg(lang, itemVal["msg"], nodeId))
        errMsg = "".join(errMsgList)
        
        if flag == True:
            cliRet = "Online diagnosis is not performed for disks."
        else:
            cliRet = "Online diagnosis is being performed for some disks."
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
            
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    