# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.common import config
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
from frameone.util import baseUtil

def execute(context):
    '''
    @summary: 系统资源检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    devModel = contextUtil.getDevType(context)
    logger.logInfo("curDeversion is %s" % devModel)
    cliRet = ""
    context["checkState"] = common.PROCESS_STATE_CHECKING
    item = "tlv_software_sysResource"
    #获取内存阈值
    NORMAL_MEMORY = 270
    if devModel in config.MEMORY_DEVS_180:
        #低端设备的配置较低，设置内存阈值为180M
        NORMAL_MEMORY = 180
    elif devModel in config.MEMORY_DEVS_200:
        NORMAL_MEMORY = 200
    elif devModel in config.MEMORY_DEVS_400:
        NORMAL_MEMORY = 400
    
    #CPU利用率阈值定义
    MAX_CPUUSAGE = 50
    
    try:
        # 进度条刷新
        common.threadUp(context, item)
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_SYSRESOURCE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        checkDetail = ""
        for record in recs:
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            itemKey = None
            sysResUsageList = result.split(",")
            if len(sysResUsageList) == 2:
                if sysResUsageList[0].isdigit() and sysResUsageList[1].isdigit():
                    cpuUsage = int(sysResUsageList[0])
                    memoryRemain = int(sysResUsageList[1])
                    checkDetail += baseUtil.getMsg(lang, "SysResourceCheck.detail",
                                                   (nodeId, str(cpuUsage) + '%', str(memoryRemain)))
                    if (cpuUsage <= MAX_CPUUSAGE) and (memoryRemain >= NORMAL_MEMORY):
                        #执行成功
                        itemKey = "True"
                    else:
                        itemKey = "False"
            else:
                itemKey = result
            itemVal = itemDict.get(itemKey, None)#根据模块返回值获取对应的字典值,如果失败返回None
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status")
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        if flag == False:
            cliRet = "System resources (CPU or Memory) are insufficient"
        else:
            cliRet = "System resources (CPU or Memory) are sufficient"
        cliRet += checkDetail
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

    finally:
        try:
            common.finishProcess(context, item)
            logger.logInfo("the thread is finished")
        except:
            common.setProgress(context, common.PROGRESS_NUM_MAX, item)