# -*- coding: UTF-8 -*-
from frame.context import contextUtil
from frame.common import common
from frame.common import exportFileUtil
from frame.cli import cliUtil
import commonHandler
import xmlParser
import Error
import os

errLevel = [False, cliUtil.RESULT_WARNING, cliUtil.RESULT_NOCHECK, True]


def execute(context, queryCheckItem): 
    '''
    @summary: 解析器的主流程控制函数
    @param queryCheckItem: 检查项id，和规则文件中的id对应
    @return : 
        flag:queryCheckItem检查项结果
        cliRet:原始信息
        errMsg:错误提示消息
    ''' 
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    try:
        xmlInfo = contextUtil.getItem(context, "xmlInfo")
        if xmlInfo == None:
            #获取xml文件解析后的字典
            xmlInfo = xmlParser.parseRuleXmlFile(logger)
            contextUtil.setItem(context, "xmlInfo", xmlInfo)
            
            #获取xml中所有data的属性值，构成一个属性list
            allDataXmlList = xmlParser.getAllDataXml(xmlInfo, logger)
            
            #所有<data>结点，构造key为"type"、"title"的嵌套字典
            dataAttrDict = xmlParser.constrXmlDataAttrDict(allDataXmlList, logger)
            contextUtil.setItem(context, "dataAttrDict", dataAttrDict)
        
        dataAttrDict = contextUtil.getItem(context, "dataAttrDict")
        
        #在运行数据文件中提取出的所有数据表的字典
        localConfigFile = os.path.join(contextUtil.getCollectTmpDir(context), common.CONFIG_FILE)
        allTableStrDict = contextUtil.getItem(context, "allTableStrDict")
        if allTableStrDict == None:
            allTableStrDict = commonHandler.getAllTableStrDict(xmlInfo, dataAttrDict, localConfigFile, logger)  
            contextUtil.setItem(context, "allTableStrDict", allTableStrDict)
            
        #根据传入的检查项id取到这个节点中所有的rule形成的list
        rulesXmlList = xmlParser.getCheckitemRulesList(queryCheckItem, xmlInfo)
        if len(rulesXmlList) == 0:
            errMsg = common.getMsg(lang, "queryitem.not.in.xml")
            return (cliUtil.RESULT_NOCHECK, "", errMsg)
        
        #获取datasets里的数据集字典
        datasetsDict = contextUtil.getItem(context, "datasetsDict")
        if datasetsDict == None:
            datasetsXml = xmlParser.getChildNodeXml(xmlInfo, "datasets")
            datasetsDict = commonHandler.getDatasetsDict(datasetsXml, localConfigFile, logger)
            contextUtil.setItem(context, "datasetsDict", datasetsDict)
        
        #某个检查项里的所有rule的校验，得到检查项结果
        matchRet = getRulesMatchRet(rulesXmlList, allTableStrDict, dataAttrDict, datasetsDict, logger, lang)
        return matchRet
    
    except Exception, ex: 
        (flag, errMsg) = handleAnalyzeException(ex, logger, lang)
        if not flag:
            raise
        return (cliUtil.RESULT_NOCHECK, "", errMsg)


   
def getRulesMatchRet(rulesXmlList, allTableStrDict, dataAttrDict, datasetsDict, logger, lang):    
    '''
    @summary: 某个检查项里的所有rule的校验，返回所有rule结果的并集
    @param rulesXmlList:某个检查项中所有rule节点的xml信息
    @return: 
        isSuccess:queryCheckItem检查项结果
        cliRet:config取得的原始数据
        errMsg:错误提示消息
    '''
    errMsg = ""   
    checkRet = ""
    convertDataDict = {}
    flag = True
    
    titleAttrDict = dataAttrDict.get("title")
    
    #遍历所有规则，判断是否符合条件
    for node in rulesXmlList:
        nodeAttrDict = node["elementAttrbutes"]
        #判断用到的数据表，转换表数据为list
        name = nodeAttrDict["index"].split('.')[0]
      
        if convertDataDict.has_key(name) == False:  
            currentTableStr = allTableStrDict[name]
            checkRet += currentTableStr
            convertRet = commonHandler.converTableToList(currentTableStr, dataAttrDict, name, logger, lang)
            
            if convertRet[0] != True:
                errMsg += convertRet[2]
                flag = getErrLevel(flag, convertRet[0])
            convertDataDict.setdefault(name, convertRet[1])  
                
        if  convertDataDict.has_key(name) and len(convertDataDict.get(name)) == 0:
            continue
        
        #该检查项需要的所有数据都在 convertDataDict中 
        matchRet = commonHandler.ruleMatch(nodeAttrDict, convertDataDict, titleAttrDict, datasetsDict, logger, lang)
        if matchRet[0] != True:
            flag = getErrLevel(flag, matchRet[0])
            errMsg += matchRet[1]

    return (flag, checkRet, errMsg)   



def getErrLevel(flag, newFlag):
    '''
    @summary:通过配置返回值级别的高低，返回结果
    '''
    for level in errLevel:
        if flag == level or newFlag == level:
            return level
    return False

def handleAnalyzeException(exception, logger, lang):
    '''
    @summary: 处理解析器异常时，返回失败的结果给上下文对象
    @param exception: 异常信息
    '''
    errMsg = ""
    expArgs = exception.args
    if expArgs is not None and len(expArgs) == 2:
        errCode = str(expArgs[0]).strip()
        
        keys = Error.ERROR_CODE_DEFINE.keys()
        if errCode in keys:
            errInfo = contextUtil.ERROR_CODE_DEFINE.get(errCode, {})
            errMsg = errInfo.get("errMsg_%s" % lang, "")
            suggestion = errInfo.get("suggestion_%s" % lang, "")
            return (True, ''.join((errMsg, suggestion)))
    else:
        logger.logException(exception)
    return (False, "")


def executeAnalyzer(context, queryCheckItem):
    '''
    @summary: 执行使用解析器的检查项的通用方法
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    originalRet = ""
    
    try:
        exportRet = exportConfigFile(context)
        originalRet += exportRet[1]
        if exportRet[0] != True:
            return (exportRet[0], originalRet, exportRet[2])

        #执行解析器
        (flag, cliRet, errMsg) = execute(context, queryCheckItem)
        originalRet += cliRet
        
        return (flag, originalRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return (False, originalRet, common.getMsg(lang, "analyze.query.result.abnormal"))

def exportConfigFile(context):
    '''
    @summary: 导出config文件
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getCLI(context)
    sftp = contextUtil.getSFTP(context)  
    exportRet = (True, "", "")
    
    exportFlag = contextUtil.getItem(context, "exportFlag")
    logger.logInfo("exportFlag: [%s]" % exportFlag)
    if exportFlag == True:
        return exportRet
    
    exportType = common.EXPORT_TYPE_RUNNING_DATA
    localConfigDir = contextUtil.getCollectTmpDir(context)
    logger.logInfo("current download dir: [%s]" % localConfigDir)
    #创建临时文件夹
    if not os.path.exists(localConfigDir):
        os.makedirs(localConfigDir)
    localConfigFile = os.path.join(localConfigDir, common.CONFIG_FILE)
    
    cycle_times = 3
    for i in range(0, cycle_times):
        logger.logInfo("export running data for %s times." % (i + 1))
        exportRet = exportFileUtil.downloadStorageFile(lang, cli, sftp, logger, exportType, localConfigFile)
        if exportRet[0] == True:             
            contextUtil.setItem(context, "exportFlag", True)  
            return (exportRet[0], exportRet[1] + "\n\n", exportRet[2])
        if common.isRemoteExistFile(exportRet[1]):
            deleteRet = common.deleteCollectFile(cli, lang, common.EXPORT_TYPE_RUNNING_DATA)
            logger.logInfo("delete collect file result: %s" % unicode(deleteRet))
    
    return exportRet

