# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

targetVersionList = ["V300R002C00" , "V300R002C10" , "V300R002C10SPC100"]

def execute(context):
    '''
    @summary: 主机端口IP配置检查
    '''
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRetValue = ""
    try:
        flag = True
        errMsg = ""
        getPkgVersion = contextUtil.getTargetVersion(context)
        logger.logInfo("getPkgVersion:%s" % getPkgVersion)
        #不在目标版本内不涉及
        if str(getPkgVersion) not in targetVersionList:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetValue, errMsg)
        
        cliRetList = list()#获取回显信息
        cmd = "show port general logic_type=Host_Port physical_type=ETH "
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            flag = False 
            logger.logNoPass("checkRet:%s" % unicode(checkRet))
            errMsg = common.getMsg(lang, "query.result.abnormal")
            return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
        
        cliRet = checkRet[1]
        cliRetList.append(cliRet)
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
        idList = list()
        for item in cliRetDictList:
            if "." in item["IPv4 Address"]:
                idList.append(item["ID"])
                
        logger.logInfo("dList:%s" % idList)
        resultFlag = True
        for portId in idList:
            cmd = "show port general port_id=%s" % portId       
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
            if checkRet[0] != True: 
                flag = False 
                logger.logNoPass("checkRet:%s" % unicode(checkRet))
                errMsg = common.getMsg(lang, "query.result.abnormal")
                return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
            
            cliRet = checkRet[1]
            cliRetList.append(cliRet)
            cliRetDictList = cliUtil.getVerticalCliRet(cliRet)
                
            for item in cliRetDictList:
                if "Subnet Mask" in item:
                    subnetMask = item["Subnet Mask"]
                    if len(subnetMask) > 14:
                        resultFlag = False
                        
        cliRetValue = "\n".join(cliRetList)
        if resultFlag is False:
            flag = False
            errMsg = common.getMsg(lang, "check.eth.port.ip.notpass")
        return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetValue, common.getMsg(lang, "query.result.abnormal"))
                        
        
    
    

    
