# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
                      阵列前4个保险箱盘漫游检查：
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    devType = str(contextUtil.getDevType(context))#获取当前设备型号
    targetVersion = str(contextUtil.getTargetVersion(context))#获取评估目标版本
    flag = True
    cliRet = ""
    errMsg = ""
    flagSwitch = False #每个保险盘检查结果标记
    tempList = []#前4个保险盘检查结果合集
    
    try:
        #先检查设备型号是否为S5500T，目标版本是否在如下列表中:
        if devType != 'S5500T':
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        if targetVersion not in ['V200R002C30SPC200']:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        cmd = "ld show disk"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        
        if cliRet.find("LD") == -1 or cliRet.find("SlotId") == -1:
            errMsg = common.getMsg(lang, 'get.result.abnormal') #"\n查询结果异常"
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        dictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(dictList) == 0:
            errMsg = common.getMsg(lang, "query.result.abnormal")
            logger.logNoPass("Cannot get information about roaming")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for i in range(0, 4):         
            if dictList[i].get('LD') in ['0', '1', '2', '3']:
                if dictList[i].get('LD') == dictList[i].get('SlotId'):
                    flagSwitch = True
                    tempList.append(flagSwitch)
            
                else:
                    flagSwitch = False
                    tempList.append(flagSwitch)
                    errMsg += common.getMsg(lang, 'has.disk.romaing',(dictList[i].get('LD'),dictList[i].get('SlotId')))#“\n保险盘存在漫游”
            
            if False in tempList:
                flag = False
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))