# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    @summary: LUN销毁检查
    '''

    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    flag = True
    cliRet = ""
    errMsg = ""
    try:
        ssh = contextUtil.getSSH(context)
        cmd = "show lun_destroy_data upgrade_status"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(ssh, cmd, True, lang)
        logger.logInfo("cliResult=%s" % unicode(checkRet))
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            logger.logInfo("commond not exist.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, checkRet[1], "")
        if not checkRet[0]:
            logger.logExecCmd(checkRet[0])
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        dictResult = cliUtil.getVerticalCliRet(checkRet[1])
        if len(dictResult) == 0:
            errMsg = common.getMsg(lang, "query.result.abnormal")
            return common.getUpgEvaluationRs(False, checkRet[1], errMsg)
        listResult = [line["Upgrade Status"] for line in dictResult]
        if "True" in listResult:
            flag = True
        elif "False" in listResult:
            flag = False
            errMsg = common.getMsg(lang, "check.lun.destroy.notpass")
        elif "timeout" == line["Upgrade Status"] or "time out" == line["Upgrade Status"]:
            flag = False
            errMsg = common.getMsg(lang, "check.lun.destroy.timeout")
        else:
            flag = False
            errMsg = common.getMsg(lang, "check.lun.destroy.error")
        return common.getUpgEvaluationRs(flag, checkRet[1], errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    