# -*- coding: UTF-8 -*-
from frame.common.regex import Regex
from cbb.frame.util.common import wrapAllExceptionLogged

STANDARD_FLAG = "###"
OLD_FLAG = "---"

def getHorizontalRet(inStr):
    '''
    @summary: 按逐行字典的方式获取水平表格形式字符串
    @param inStr: 表格字符串
    @return: 将表格形式字符串处理为以表头为key，以项值为键的字典集合，处理不正常时，返回空集合
    '''   
    retList = inStr.encode("utf8").splitlines()
            
    #获取list中最大长度的字符串
    headline = retList[1]
    field_words = retList[2:]
    
    tuple_idxs = Regex.getStartEndList("\s*\w+\s*", headline)
           
    keys = []
    for item in tuple_idxs:
        key = headline[item[0]:item[1]].strip()
        if keys.count(key):
            key += "_" + str(str(keys).count(key + "_") + 1)
        keys.append(key.decode("utf8"))
    
    requiredLineLen = tuple_idxs[-1][0]              
    dictList = []
    for line in field_words:
        if STANDARD_FLAG in line:
            break                    
        if len(line.strip()) == 0:
            continue
        if len(line) <= requiredLineLen:
            continue
        vals = []
        for item in tuple_idxs:
            vals.append(line[item[0]:item[1]].strip().decode("utf8"))
        dictList.append(dict(zip(keys, vals)))
            
    return dictList



def getVerticalRet(inStr):
    dictList = []
    return dictList


@wrapAllExceptionLogged(logger=None)
def readConfigFile(dataAttrDict, filePath, logger):
    '''
    @summary: 根据ids获取对应的打印内容
    @param ids: 所有数据表表名list
    @return strDict: 以字典的形式返回每个数据表的对应内容
    '''
    titleAttrDict = dataAttrDict["title"]
    typeAttrDict = dataAttrDict["type"]
    logger.logInfo("titleAttrDict=%s" % titleAttrDict)
    
    flag = False
    tableTitle = ""
    tableType = ""
    strDict = {}.fromkeys(titleAttrDict.values(), [])
    fileObj = open(filePath, "r")
    for line in fileObj:
        (find, key) = isTitleDictInLine(titleAttrDict, line)
        if find:
            flag = True
            tableTitle = titleAttrDict[key]
            tableType = typeAttrDict[key]
            logger.logInfo("start tableTitle=%s" % tableTitle)
            strDict[tableTitle] = []
            strDict[tableTitle].append(line)
            continue
        if flag and  tableType == "horizon" and line.find(STANDARD_FLAG) >= 0:
            logger.logInfo("end tableTitle=%s" % tableTitle)
            flag = False
            strDict[tableTitle].append(line)
            continue
        if flag and tableType == "vertical" and not line[0].isspace():
            logger.logInfo("end tableTitle=%s" % tableTitle)
            flag = False
            continue
        if flag:
            strDict[tableTitle].append(line)
    fileObj.close()
    
    return strDict

           
def isIdsInLine(ids, line):
    '''
    @summary: 当前的line是否是要找的表格的开头
    '''
    if line[0].isspace():
        return (False, "")
    if line.find(STANDARD_FLAG) < 0 and line.find(OLD_FLAG) < 0 :
        return (False, "")
    for i in range(0,len(ids)):
        if ids[i] in line:
            return (True, i)
    return (False, "")

def isTitleDictInLine(titleAttrDict, line):
    '''
    @summary: 当前的line是否是要找的表格的开头
    '''
    if line[0].isspace():
        return (False, "")
    if line.find(STANDARD_FLAG) < 0 and line.find(OLD_FLAG) < 0 :
        return (False, "")
    for key in titleAttrDict:
        if titleAttrDict[key] in line:
            return True, key
    return (False, "")

    

def getDatasetsFromConf(names, titles, fields, filePath):
    '''
    @summary: 读取配置文件，
    '''
    flag = False
    index = 0
    DataSetsDict = {}.fromkeys(names,"")
    
    fileObj = open(filePath, "r")
    for line in fileObj:
        (find, i) = isIdsInLine(titles, line)
        if find:
            flag = True
            index = i
        if flag and fields[index] in line:
            DataSetsDict[names[index]] = line.split(':')[1].strip()
            flag = False
    try:
        fileObj.close()
    except:
        return DataSetsDict
    
    return DataSetsDict



