# -*- coding: UTF-8 -*-

import re
class VerticalTable():
    def __init__(self, tableStr, logger):
        self.tableStr = tableStr
        self.aliveNodeDict = {}
        self.existTmpDict = None
        self.allNodes = []
        self.logger = logger

    def findNodes(self, level, name=None):
        filterNodes = []
        for node in self.allNodes:
            if node.level == level and (name == None or node.name == name):
                filterNodes.append(node)
        return filterNodes

    def parse(self):
        try:
            self.logger.logInfo("begin to parse.")
            lines = self.tableStr.encode("utf8").splitlines()
            for line in lines:
                self.logger.logInfo("line=%s" % line)
                lineType, lineLevel, result = self._recongnizeLine(line)
                self.logger.logInfo("lineLevel=%s, lineType=%s, result=%s" % (lineLevel, lineType, result))
                if lineType == "Unknown":
                    continue
                
                parentNode = self._getParentNode(lineLevel)
                if lineType == "Head":
                    #新建节点，赋值，加入到allNodes中。更新对应级别的alive对象，并关闭dict
                    node = Node(result["name"], lineLevel)
                    if parentNode:
                        node.parentId = parentNode.parentId
                    else:
                        node.parentId = "-1"
                    self.allNodes.append(node)
                    self.aliveNodeDict[node.level] = node
                    self.existTmpDict = False
                elif lineType == "KeyValue":
                    # 新建dict或取上次的dict，并加入到parent的children
                    if parentNode is None:
                        continue
                    if self.existTmpDict:
                        lastDict = parentNode.children[-1]
                        lastDict[result["key"]] = result["value"]
                    else:
                        tempDict = dict()
                        tempDict[result["key"]] = result["value"]
                        parentNode.children.append(tempDict)
                        self.existTmpDict = True

                elif lineType == "Blank":
                    # 关闭dict
                    self.existTmpDict = False
                else:
                    self.logger.logInfo("not support line=%s" % line)
                    return False
        except Exception, e:
            self.logger.logException(e)
            return False
        return True

    def _recongnizeLine(self, lineStr):
        result = dict()
        HeadRex = "^(\s*)(.*)-{32}$"
        KeyValueRex = "^(\s*)([^:]+):(.+)"
        BlankRex = "^(\s*)$"
        try:
            # 识别标题
            rec = re.match(HeadRex, lineStr)
            if rec:
                lineType = "Head"
                lineLevel = len(rec.group(1))/4
                result["name"] = rec.group(2).strip()
                return lineType, lineLevel, result

            # 识别key Value
            rec = re.match(KeyValueRex, lineStr)
            if rec:
                lineType = "KeyValue"
                lineLevel = len(rec.group(1)) / 4
                result["key"] = rec.group(2).strip()
                result["value"] = rec.group(3).strip()
                return lineType, lineLevel, result

            # 识别空行
            rec = re.match(BlankRex, lineStr)
            if rec:
                lineType = "Blank"
                lineLevel = len(rec.group(1)) / 4
                return lineType, lineLevel, result
        except:
            return "Unknown", 0, result
        return "Unknown", 0, result

    def _getParentNode(self, level):
        parentNode = None
        if level > 0:
            parentNode = self.aliveNodeDict.get(level - 1)
        return parentNode

class Node():
    no = 0
    def __init__(self, name, level):
        self.id = Node.no
        Node.no += 1
        self.name = name
        self.level = level
        self.children = []