# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    allCliRet = ''
    DiskLocationList = []#检测到不通过硬盘的位置信息
    try:
        errMsg = ''
        cmd = 'show system general'
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        allCliRet += checkRet[1]
        checkProductModels = ['2800 V3']
        productModel = contextUtil.getDevType(context)
        curVersion = contextUtil.getCurVersion(context)
        if productModel not in checkProductModels or curVersion >= "V300R006C10":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)
        
        cmd = "show disk general |filterRow column=Coffer\sDisk predict=equal_to value=Yes"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        allCliRet += cliRet
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], allCliRet, checkRet[2])
        
        cofferDisks = cliUtil.getHorizontalCliRet(cliRet)
        logger.logInfo("coffer disk info:[%s]" % unicode(cofferDisks))
        
        sataDisks = []
        for disk in cofferDisks:
            dId = disk.get('ID')
            dType = disk.get('Type', '').upper()
            if dType == 'SATA':
                sataDisks.append(dId)
        
        if len(sataDisks) > 0:
            sataDisks.sort()
            sataDisksMsg = ', '.join(sataDisks)
            return common.getUpgEvaluationRs(False, allCliRet, common.getMsg(lang, "coffer.disk.is.sata", sataDisksMsg))
        
        return common.getUpgEvaluationRs(True, allCliRet, "")
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, allCliRet, common.getMsg(lang, "query.result.abnormal"))  
    
