# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.common import config
from frame.context import contextUtil

def execute(context):
    '''
    BBU状态检查：
                所有BBU均在位，Health Status为Normal且Running Status为Online、Charging或Discharging表示正常，其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show bbu general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetAll = cliRet
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.bbu.info")
            LOGGER.logNoPass("Cannot get information about BBU")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        bbuEngineIdList = []
        for line in cliRetLinesList:
            bbuId = line["ID"]
            bbuEngineIdList.append(bbuId.split(".")[0][-1])
            bbuHealthStatus = line["Health Status"]
            bbuRunningStatus = line["Running Status"]
            
            if bbuHealthStatus != common.STATUS_NORMAL or bbuRunningStatus not in [common.STATUS_ONLINE, common.STATUS_CHARGING, common.STATUS_DISCHARGING]:
                flag = False
                errMsg += common.getMsg(LANG, "bbu.status.abnormal", (bbuId, bbuHealthStatus, bbuRunningStatus))
                LOGGER.logNoPass("The Status of enclosure [%s] is abnormal (Health Status:%s,Running Status:%s)" % 
                    (bbuId, bbuHealthStatus, bbuRunningStatus))

        rest = contextUtil.getRest(context)
        pdtVersion = contextUtil.getCurVersion(context)
        bbuConfigRet = common.getBBUConfig(cli, rest, LANG ,pdtVersion)
        if bbuConfigRet[0] != True:
            cliRetAll += bbuConfigRet[1]
            errMsg += bbuConfigRet[2]
            LOGGER.logNoPass("Cannot get information about BBU configuration")
            return common.getUpgEvaluationRs(bbuConfigRet[0], cliRetAll, errMsg)
        standardBbuNumOfEngine = bbuConfigRet[1]
        
        getControllerIdCheckRet = cliUtil.getControllerIdList(cli, LANG)
        if getControllerIdCheckRet[0] != True:
            cliRetAll += getControllerIdCheckRet[1]
            errMsg += getControllerIdCheckRet[2]
            LOGGER.logNoPass("Cannot get information about controllers")
            return common.getUpgEvaluationRs(getControllerIdCheckRet[0], cliRetAll, errMsg)
        controllerIdList = getControllerIdCheckRet[1]
        
        engineIdList = [controllerId[0] for controllerId in controllerIdList]
        engineIdSet = set(engineIdList)
        
        #获取存储设备类型
        storageTypeRet = cliUtil.getStorageType(cli, LANG)
        if storageTypeRet[0] != True:
            errMsg += storageTypeRet[2]
            return common.getUpgEvaluationRs(storageTypeRet[0], cliRet, errMsg)
        product_series = storageTypeRet[1]
        
        #ARM型号的单控不检查BBU个数：ARM为CBU集成在控制器上，单控只有1个BBU
        if not (common.isSigleModel(cli, LANG) and product_series == config.SERIES_ARM):
            for engineId in engineIdSet:
                currentBbuNumofEngine = bbuEngineIdList.count(engineId)
                if currentBbuNumofEngine < standardBbuNumOfEngine:
                    flag = False
                    errMsg += common.getMsg(LANG, "bbu.number.not.enough", (engineId, standardBbuNumOfEngine, currentBbuNumofEngine))
                    LOGGER.logNoPass("The number of BBU on engine [%s] is not enough (Required Number:%s, Current Number:%s)" 
                         % (engineId, standardBbuNumOfEngine, currentBbuNumofEngine))
                
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
