# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

BOARD_KEY = "[EMP_INTF_BOARD]"
BOARD_VALUE = "intf_id_5_supported_type=12,1:4:37:40:35:39:44:58:65:67:71:143"
#涉及问题的版本范围
INVOLVE_VERSION = ["V500R007C00",
                   "V500R007C00SPC100",
                   "V500R007C10",
                   "V500R007C10SPC100",
                   "V500R007C20",
                   "V500R007C20SPC100",
                   "V500R007C30",
                   "V500R007C30SPC100"]
#涉及问题的目标版本
TARGET_INVOLVE_VERSION = ["V500R007C30",
                          "V500R007C30SPC100"]

INVOLVE_MODEL = "18500F V5"


def execute(context):
    '''
        背景：18500F V5设备的SAS接口卡白名单配置错误，导致R5槽位SAS大卡无法接入。
       查 询：
       所有控制器的extend.ini文件内容，如 未检查到 以下关键字，则判定当前控制器配置错误 
       [EMP_INTF_BOARD]
       intf_id_5_supported_type=12,1:4:37:40:35:39:44:58:65:67:71:143  
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    passWord = contextUtil.getDevLoginUserPwd(context)
    
    flag = True
    errMsg = ""
    allCliRet = ""
    
    configErrControList = []
    switchErrControList = []
    
    try:
        #1.获取并查看设备的型号及版本是否在检查范围内
        flag, errMsg = checkProductModelAndVersion(lang, logger, context)
        if True != flag:
            return common.getUpgEvaluationRs(flag, allCliRet, errMsg)        
        
        #2.获取当前设备的所有控制器ID        
        flag, allCliRet, errMsg, presentNodeIdList = getPresentCtrlNodeIdList(cli, lang, logger, allCliRet)
        if True != flag:
            return common.getUpgEvaluationRs(flag, allCliRet, errMsg)
        
        #3.根据控制器ID列表进行心跳切控并检查extend.ini内容        
        for nodeId in presentNodeIdList:
            #心跳切控
            flag, allCliRet, errMsg = switchControllers(cli, lang, logger, allCliRet, nodeId, passWord)
            if True != flag:
                #若控制器切换失败，记录控制器ID，并执行下一控制器切换                
                switchErrControList.append(nodeId)
                continue
            #查询当前控制器extend.ini内容                        
            flag, allCliRet, errMsg = checkControExtend(cli, lang, logger, allCliRet)
            if True != flag:
                configErrControList.append(nodeId)
            #退出当前心跳连接            
            cliUtil.exitHeartbeatCli(cli, lang)
        
        #当前退出后返回原有连接仍在小系统视图中，返回至admin视图
        backToAdmin(cli)
        
        #1.若存在配置错误的控制器，则返回不通过 2. 只有切换失败控制，返回未检查 3. 都有            
        if len(configErrControList) > 0 and len(switchErrControList) == 0:
            return common.getUpgEvaluationRs(False, allCliRet, common.getMsg(lang, "controller.nodeid.sas.config.failed", ','.join(configErrControList)))
        if len(configErrControList) == 0 and len(switchErrControList) > 0:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, cliUtil.getMsg(lang, "heart.beat.to.node.failed", ','.join(switchErrControList)))        
        if len(configErrControList) > 0 and len(switchErrControList) > 0:
            configMsg = common.getMsg(lang, "controller.nodeid.sas.config.failed", ','.join(configErrControList))
            switchMsg = cliUtil.getMsg(lang, "heart.beat.to.node.failed", ','.join(switchErrControList))
            errMsg = joinLines(configMsg, switchMsg)
            return common.getUpgEvaluationRs(False, allCliRet, errMsg)        
          
        return common.getUpgEvaluationRs(True, allCliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "query.result.abnormal"))

def backToAdmin(cli):
        """
        @summary: 从小系统退回到admin视图
        """ 
        cmd = "show system general"
        cliRet = cli.execCmd(cmd)        
        if cliUtil.isInMinisystemMode(cliRet):
            cliRet = cli.execCmd("exit")
            if "(y/n)" in cliRet:
                cliRet = cli.execCmd("y")
        if cliUtil.isInDeveloperMode(cliRet):
            cliRet = cli.execCmd("exit")
            if "(y/n)" in cliRet:
                cliRet = cli.execCmd("y")            

def checkControExtend(cli, lang, logger, allCliRet):
        """
        @summary: 查询当前控制器extend.ini内容
        """    
        boardKeyFlag = False
        cmd = "cat /startup_disk/conf/conf_local/extend.ini"
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
        allCliRet = joinLines(allCliRet, cliRet)        
        if flag != True:
            return (cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)        
        
        cliRetLinesList = cliRet.splitlines()
        #此处写得冗余是因为首行匹配成功key值后，次行必须匹配成功value 才能算是含有正确内容，否则不算        
        for line in cliRetLinesList:
            if BOARD_KEY == line.strip():
                boardKeyFlag = True
                continue
            if boardKeyFlag :
                if BOARD_VALUE == line.strip():
                    return (True, allCliRet, "")
                else:
                    boardKeyFlag = False
        return (False, allCliRet, "")            

def switchControllers(cli, lang, logger, allCliRet, nodeId, passWord):
    """
    @summary: 心跳至其他控制器
    @return: True 成功跳转
    """      
    cmd = "sshtoremoteExt %s" % str(nodeId)
    flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    if flag != True:
        logger.logInfo('sshtoremoteExt to remote node failed %s' % str(nodeId))
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
    else:
        logger.logInfo('sshtoremoteExt to remote node success %s' % str(nodeId))
    
    return (True, allCliRet, "")

def getPresentCtrlNodeIdList(cli, lang, logger, allCliRet):
    """
    @summary: 获取所有引擎下的节点（控制器）ID
    @return: True 获取节点信息，继续之后步骤
    """
    cmd = "sys showcls"
    flag, cliRet, _ = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang)
    allCliRet = joinLines(allCliRet, cliRet)
    if not flag:
        logger.logInfo("Exe cmd sys showcls is faild.")
        return (cliUtil.RESULT_NOSUPPORT, allCliRet, cliUtil.getMsg(lang, "failed.to.get.present.nodeid"), [])
    
    presentNodeIdList = []
    for line in cliRet.splitlines():
        fields = line.split()
        if len(fields) < 4 or not fields[0].isdigit():
            continue
        
        #获取所有控制器节点ID        
        nodeId = fields[0].strip()
        presentNodeIdList.append(nodeId)
    
    if len(presentNodeIdList) < 1:
        logger.logInfo("The presentNodeIdList is null.")
        return (cliUtil.RESULT_NOSUPPORT, allCliRet, cliUtil.getMsg(lang, "failed.to.get.present.nodeid"), [])
    
    logger.logInfo("The presentNodeIdList is %s :" % presentNodeIdList)   
    return (True, allCliRet, '', presentNodeIdList)

def checkProductModelAndVersion(lang, logger, context):
    """
    @summary: 查看当前设备型号及版本是否在检查范围内
    @return: True  在检查范围内，继续之后检查步骤
    """
    product_version = contextUtil.getCurVersion(context)
    logger.logInfo("The product model is %s " % product_version)
    product_model = contextUtil.getDevType(context)
    logger.logInfo("The product version is %s " % product_model)
    pkg_version = contextUtil.getTargetVersion(context)
    logger.logInfo("The pkg_version is %s" % pkg_version)    
    
    if len(product_model) == 0 and len(product_version) == 0 and product_model == "--" and product_version == "--":
        logger.logInfo("The product model is %s and version is %s " % (product_model, product_version))
        return (False, cliUtil.getMsg(lang, "cannot.get.product.model.info"))
    
    #若不为18500F V5型号，则不进行检查    
    if INVOLVE_MODEL != product_model.strip():
        return (cliUtil.RESULT_NOSUPPORT, "")
    
    #若不在检查范围内同样不进行检查
    if product_version not in INVOLVE_VERSION:
        return (cliUtil.RESULT_NOSUPPORT, "")
    
    #若升级的目标版本不在范围内同样不进行检查
    if pkg_version not in TARGET_INVOLVE_VERSION:
        return (cliUtil.RESULT_NOSUPPORT, "")        

    return (True, "")


def joinLines(oldLines, newLines):
    if oldLines == None or oldLines == "" :
        return newLines
    return '\n'.join([oldLines, newLines]) if newLines else oldLines