# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
import os

def execute(context):
    '''
    @summary: cache分区Fault页面检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdTupList = contextUtil.getItem(context, "allCtrlsIp")
        if not ctrlIpAndIdTupList:
            #无法获取控制器ip
            logger.logInfo(common.getMsg(lang, 'cannot.ctrl.id.ip'))
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, 'cannot.ctrl.id.ip'))
        
        #将回显和控制器信息拼接起来
        cliRetList = []
        resultList = []
        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdTupList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            checkRet = checkCacheFaultPage(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            
            if checkRet[0] != cliUtil.RESULT_NOCHECK:
                cliRetList.append(common.CONTROLLER_INFO % (ctrlId))
                cliRetList.append(checkRet[1] + "\n")
            
            resultList.append(checkRet[0])
            #中间变量保存显示信息。
            midMsg = checkRet[2]
            if checkRet[0] is True:#通过
                midMsg = common.getMsg(lang, "controller.check.pass")
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
            
        flag = common.getCheckResult(resultList)
        logger.logInfo("resultList flag is:%s" % str(resultList))
        cliRet = '\n'.join(cliRetList)
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
               
    except Exception, exception: 
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet.strip(), common.getMsg(lang, 'query.result.abnormal'))
    
def checkCacheFaultPage(context, ctrlIpS, ctrlId):
    '''
    @summary: 单个控制器cache分区Fault页面检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    try:
        curCtrlIp = contextUtil.getCurCtrlIp(context)
        if curCtrlIp == ctrlIpS[0] or curCtrlIp == ctrlIpS[1]:#当前控制器直接获取
            cli = contextUtil.getSSH(context)
        else:#新建cli连接
            cli = contextUtil.createCliConnection(context, ctrlIpS[0])
            if cli is None:
                cli = contextUtil.createCliConnection(context, ctrlIpS[1])
        if cli == None:
            logger.logInfo("create controller [%s] cli connection failed" %ctrlId)
            errMsg = common.getMsg(lang, "cannot.create.controller.cli")
            return (cliUtil.RESULT_NOCHECK, "", errMsg)

        cmd = "quota show pttinfo all"
        logger.logExecCmd(cmd)
        flag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang, contextUtil.getDeveloperPwd(context))
        if flag != True: 
            logger.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(lang, "cli.result.is.invalid")
            logger.logNoPass("Cannot get cache page information of controller[%s]" %ctrlId)
            return (flag, cliRet, errMsg)

        for lineDict in cliRetLinesList:
            cachePage = lineDict["partition ID"]
            blockedCnt = lineDict["blockedCnt"]
            if not blockedCnt.isdigit():
                flag = False
                errMsg = common.getMsg(lang, "cli.result.is.invalid")
                logger.logNoPass("There is an error in Sequence[cachePartitionFaultPage]!")
                return (flag, cliRet, errMsg)
            else:
                if int(blockedCnt) != 0:
                    flag = False
                    errMsg += common.getMsg(lang, "check.cache.fault.notpass", cachePage)
        return (flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        if curCtrlIp != ctrlIpS[0] and curCtrlIp != ctrlIpS[1]:
            cliUtil.closeCliConnection(cli)
