# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.base import baseUtil

#克隆文件系统后台分裂任务的状态
CLONE_SPLIT_STATUS = ['Abnormal','Queuing','Splitting']
#改检查项适配的最早版本
EARLIEST_VERSION = 'V300R006C00SPC100'

def execute(context):
    '''
    @summary: 克隆文件系统后台分裂任务状态检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        curVersion = contextUtil.getCurVersion(context)
        devType = contextUtil.getDevType(context)
        if curVersion < EARLIEST_VERSION and not baseUtil.isDoradoNasDev(devType):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        checkResult = checkFilesystemSplitstatus(cli,logger,lang)
        flag = checkResult[0]
        cliRet += checkResult[1]
        errMsg += checkResult[2]
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))   
    

def checkFilesystemSplitstatus(cli,logger,lang):
    '''
    @summary: 检查双活仲裁服务器链路状态是否正常
    @param cli: cli对象
    @return: (flag, cliRet, errMsg)
        flag: 
            True: 状态健康
            False: 状态不健康
        cliRet: 
            Flag为True时，返回设备上的信息
            Flag为False时，返回cli回显结果
        errMsg: 错误消息
        suggestionInfo:修改建议（15365）
    '''
    errMsg = ""
    flag = True
     
    cmd = "show file_system general|filterColumn include columnList=ID,Clone\sSplit\sStatus"
    logger.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode4Privilege(cli, cmd, False, lang)
    if checkRet[0] != True: 
        logger.logSysAbnormal()
        return checkRet
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)
		
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        cloneStatus = line["Clone Split Status"]
        if cloneStatus in CLONE_SPLIT_STATUS:
            flag = False
            errMsg += common.getMsg(lang, "clone.filesystem.splitstatus")
            logger.logNoPass("The background split tasks of clone file systems exist.")
            logger.logNoPass("The cli ret is:%s" %str(line))
            break
     
    if not flag:
        return (flag, cliRet, errMsg)  
        
    return (flag, cliRet, errMsg)
