# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

PAGE_NUMBER_LOWER_LIMIT = 32768
CHUNK_NUMBER_LOWER_LIMIT = 8192

LimitedCurVersion = ['V300R001C00', 'V200R002C10', 'V100R001C10']

def execute(context):
    '''
    @summary: LUN保有量检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        CurVersion = contextUtil.getCurVersion(context)
        logger.logInfo("CurVersion:%s" % CurVersion)
        #不在源版本内不存在此问题,则检查通过
        if str(CurVersion) not in LimitedCurVersion:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        cmd = 'show lun general |filterColumn include columnList=ID'
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, False, lang, contextUtil.getDeveloperPwd(context))
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(lang, "query.result.abnormal")
        
        lunIdList = [item["ID"] for item in cliRetLinesList]
        for lunId in lunIdList:
            checkRet = checkLUNPossessionForId(cli, logger, lang, lunId)
            if not checkRet[0]:
                logger.logInfo('Check LUN possession no pass!!')
                errMsg = common.getMsg(lang, "LUNPossessionCheck.notpass")
                return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
                
def checkLUNPossessionForId(cli, logger, lang, lunId):
    cmd = 'show lun_possessed general lun_id=%s' % lunId
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        logger.logSysAbnormal()
        return checkRet
    #判断回显是否有Command executed successfully
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        errMsg = common.getMsg(lang, "LUNPossessionCheck.pass")
        return (False, cliRet, errMsg)
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (True, cliRet, errMsg)
    for checkRetDict in cliRetLinesList:
        pageNumber = checkRetDict.get('Page Number')
        chunkNumber = checkRetDict.get('Chunk Number')
        if int(pageNumber) < PAGE_NUMBER_LOWER_LIMIT or int(chunkNumber) < CHUNK_NUMBER_LOWER_LIMIT:
            logger.logInfo('Check LUN possession no pass, LUN id is [%s], page number is [%s], chunk number is [%s] '%(lunId, pageNumber, chunkNumber))
            errMsg = common.getMsg(lang, "LUNPossessionCheck.notpass")
            return (False, cliRet, errMsg)
    errMsg = common.getMsg(lang, "LUNPossessionCheck.pass")
    return (True, cliRet, errMsg)
