# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil


def execute(context):
    '''
    该检查项仅涉及如下设备型号：18500&18800F&18800&HVS85T&HVS88T
    1、sys showcls的node cfg是否为2，如果是则直接检查通过
    2、产品型号如果是以下版本V100R001C20&V100R001C20SPC100&V100R001C20SPC200，则检查结果为警告。
    3、ip连续标准为同一网段内的内部ip，分别以0A的ip为基础连续增加。(比如172.16.126.100~103为连续ip)
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    cliRetAll = ""
    errMsg = ""
    selfCheckVersionList = ["V100R001C20", "V100R001C20SPC100", "V100R001C20SPC200"]

    try:
        #进入debug模式执行sys showcls
        cmd = "sys showcls"
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, LANG)
        cliRetAll += checkRet[1]
        errMsg += checkRet[2]
        
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        #node cfg是否为2，是则直接通过
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        nodeCfg = cliRetLinesList[0].get("node cfg")
        if nodeCfg == '2':
            return common.getUpgEvaluationRs(True, cliRetAll, "")
 
         
        cmd = "show upgrade package"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        cliRetAll += "\n\n%s" % checkRet[1]
        errMsg += checkRet[2]
        
        if checkRet[0] != True: 
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)  
        cliRet =  checkRet[1]     

        #获取设备当前运行的系统版本版本
        endIndex = cliRet.find('HotPatch Version')
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet[:endIndex])
        originalDevVersion = cliRetDictList[0].get('Current Version')

        if originalDevVersion == "--":
            errMsg += common.getMsg(LANG, "cannot.get.product.version.info")
            LOGGER.logNoPass("Cannot get information about product version")
            return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        
        #需要手动检查的版本，返回警告
        standardDevVersion = common.formatVersion(originalDevVersion)
        if standardDevVersion in selfCheckVersionList:
            errMsg += common.getMsg(LANG, "inner.ip.manual.check", originalDevVersion)
            LOGGER.logNoPass("The current product version ( %s ) does not support check by tool. See the troubkeshooting case to manually execute check based on the recommended actions."
                              % originalDevVersion)
            return common.getUpgEvaluationRs(cliUtil.RESULT_WARNING, cliRetAll, errMsg)
        
        
        cmd = "sys showip"
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, LANG)
        cliRetAll += "\n\n%s" % checkRet[1]
        errMsg += checkRet[2]
        
        if checkRet[0] != True: 
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)  
        cliRet =  checkRet[1]
        
        #取出2组内部ip的值，命名为innerIpListA、innerIpListB
        (flag, innerIpListA, innerIpListB) = getInnerIpGroupList(cliRet)     
        if flag != True:
            errMsg += common.getMsg(LANG, "inner.ip.cotroller.fault")
            LOGGER.logNoPass("A controller fault exists. Rectify the fault and then check the item.")
            return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
        
        flag = isInnerIpContinuity(innerIpListA) and isInnerIpContinuity(innerIpListB)
        if flag != True:
            errMsg += common.getMsg(LANG, "inner.ip.not.continuity")
            LOGGER.logNoPass("Discontinuous internal IP addresses.")
                   
        return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
        
    except Exception, exception: 
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, 'query.result.abnormal'))


def getInnerIpGroupList(cliRet):
    '''
    @summary: 将回显字符串解析为2组ip列表
    '''
    innerIpListA = []
    innerIpListB = []  
    
    #控制器故障的情况
    if ("failed" in cliRet.lower()) or ("not online" in cliRet.lower()):
        return (False, innerIpListA, innerIpListB)
    
    #以node划分的字符串转换成字典，存在List中
    nodeStrList = cliRet.split("Node") 
    checkRetList = []
    for nodeStr in nodeStrList:
        nodeRet = cliUtil.getVerticalCliRet(nodeStr)
        if len(nodeRet) > 0:
            checkRetList.append(nodeRet[0])   
    
    #取出2组内部ip的值，命名为A、B（交叉连续）
    strA = "seg0 in ip" 
    strB = "seg1 in ip" 
    
    for nodeDict in checkRetList:       
        innerIpListA.append(nodeDict.get(strA))
        innerIpListB.append(nodeDict.get(strB))
        strA, strB = strB, strA        
            
    return (True, innerIpListA, innerIpListB)
    
    
def isInnerIpContinuity(innerIpList):  
    '''
    @summary: 判断ip前3个字段相同，最后一个字段递增即为连续
    '''       
    fronts = [".".join(item.split(".")[0:3]) for item in innerIpList]
    if len(list(set(fronts))) > 1:
        return False
    
    ends = [int(item.split(".")[-1]) for item in innerIpList]
    for num in range(1,len(ends)):
        if 1 != (ends[num] - ends[num-1]):
            return False
    
    return True
        
     
    
