# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.cli import cliUtil

'''
============升级评估=============
检查名称：
    系统告警检查
检查方法：
    步骤1 以admin用户登录设备CLI界面；
    步骤2 执行show alarm 命令，查看系统中的告警信息
检查标准：
    如果步骤2中存在如下告警（0x200F00D8011D），则检查不通过。
检查结果：
    不通过
    当前系统存在如下告警（0x200F00D8011D）
修复建议：
    影响：若该项检查不通过，则存在升级失败风险。
    请登陆DeviceManager查看告警详细信息，并参照告警修复建议进行处理。
============升级工具=============
    name:    系统告警检查
    nopass:  系统存在如下告警（%s），不允许升级。请登陆DeviceManager查看告警详细信息，并参照告警修复建议进行处理。
    pass:    系统不存在影响升级的告警，允许升级。
    error:   执行失败，请重试，如果重试失败请联系技术支持工程师。
'''
#
def execute(dataDict):
    (itemState, errorMsg, cliRet) = ExistSpecialAlarmCheck(dataDict).run()
    return common.getUpgEvaluationRs(itemState, cliRet, errorMsg)

# 检查是否存在特殊告警类
class ExistSpecialAlarmCheck():
    def __init__(self, dataDict):
        self.pylogger = common.getLogger(contextUtil.getLogger(dataDict), __file__)
        self.ssh = contextUtil.getSSH(dataDict)
        self.lang = contextUtil.getLang(dataDict)

        devType = contextUtil.getDevType(dataDict)
        self.alarmCheckInstances = [DoradoCommonAlarmCheck(devType)]

    def run(self):
        try:
            self.pylogger.logInfo("enter ExistSpecialAlarmCheck run.")
            # 开始检查
            (ok, notPassAlarmList, allCliRet) = self.getNotPassAlarmList(self.alarmCheckInstances)
            if not ok:
                self.pylogger.logInfo("getAlarmIdList error.")
                return (cliUtil.RESULT_NOSUPPORT, common.getMsg(self.lang, "query.result.abnormal"), allCliRet)
            if len(notPassAlarmList) > 0:
                itemState = False
                notPassAlarmStr = ", ".join(notPassAlarmList)
                errorMsg = common.getMsg(self.lang, "ExistSpecialAlarmCheck.result.nopass", notPassAlarmStr)
            else:
                itemState = True
                errorMsg = ""
            return (itemState, errorMsg, allCliRet)
        except Exception, e:
            self.pylogger.logException(e)
            return (cliUtil.RESULT_NOSUPPORT, common.getMsg(self.lang, "query.result.abnormal"), "")

    # 根据检查实例和当前系统告警，找出不允许通过检查的告警
    def getNotPassAlarmList(self, checkInstances):
        notPassAlarmList = []
        allCliRet = ""
        for instance in checkInstances:
            if getattr(instance, "condition", "") == "" or getattr(instance, "condition")():
                alarmIds = getattr(instance, "alarmIds", [])
                for alarmId in alarmIds:
                    (status, cliRet) = cliUtil.isExistAlarm(self.ssh, self.lang, alarmId)
                    allCliRet += cliRet
                    if status == "Error":
                        return (False, "", allCliRet)
                    if status == "Exist":
                        notPassAlarmList.append(alarmId)
        return (True, notPassAlarmList, allCliRet)

# 检查规则类--Dorado新增的告警
class DoradoCommonAlarmCheck():
    alarmIds = ["0xF00CF0068", "0xF00060007"]
    def __init__(self, devType):
        self.devType = devType

    # 缺省默认为True
    def condition(self):
        if self.devType in ["Dorado3000 V3", "Dorado5000 V3", "Dorado6000 V3", 'Dorado18000 V3']:
            return True
        return False