# -*- coding: UTF-8 -*-
from frame.analyze.toolAnalyzer import executeAnalyzer
from frame.common import common

def execute(context):
    '''
    @summary: NAS特性前端挂IO检查，检查项id“config_service_NASIO”
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    cmd = "show fsa operation_timeout"
    cmdResult = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
    logger.logInfo("[config_service_SANIO] check support result:%s"%str(cmdResult))
    if not cliUtil.hasCliExecPrivilege(cmdResult[1]):
        logger.logInfo("[config_service_SANIO] not support this check item.")
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")
    
    queryCheckItem = "config_service_NASIO"
    checkRet = executeAnalyzer(context, queryCheckItem)
    return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])


