# -*- coding: UTF-8 -*-
import re
import time
from frame.tlv import tlvUtil
from frameone.rest.restUtil import CommonRestService
from frame.rest.restUtil import Tlv2Rest
from frame.context import contextUtil
from frame.analyze import toolAnalyzer
from frame.analyze.verticalTableAnalyze import VerticalTable
from frame.analyze.xmlParser import parseHostCompatibilityXml
from frame.cli import cliUtil
from frame.common import common
from frame.common import config
from java.lang import Exception as JException
from innerVerion.sh import check_cli_software_checkFailover

NEW_VER_V3 = 'V300R006C20'
NEW_VER_V5 = 'V500R007C10'
NEW_VER_DORADO = 'V300R001C30SPC100'
ITEM_ID = "rest_software_hostCompatibility"

def execute(context):
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    devNode = contextUtil.getDevObj(context)
    devNode.setHostCompatible(True) #标记当前设备支持阵列侧主机检查
    if context["isUpgradeScene"]:
        logger.logInfo("upgrade scene pass")
    startTime = time.clock()
    response = HostCompatibilityCheck(context).execute()
    
    logger.logInfo("total time=%s" % (time.clock()-startTime))
    return response

def HandleException(fn):
    def inner(self):
        retrytimes = 3
        while retrytimes > 0:
            try:
                fn(self)
                return True
            except Exception, e:
                self.logger.logInfo("script exception:%s" % unicode(e))
                return False
            except JException, e:
                self.logger.logInfo("java excption:%s" % unicode(e))
                retrytimes = retrytimes - 1
        return False
    return inner

# 主机兼容性检查类
class HostCompatibilityCheck():
    def __init__(self, dataDict):
        self.errorMsg = ""
        self.dataDict = dataDict
        self.results = []
        self.allCliRet = ""
        self.hosts = []
        self.errHosts = []
        self.allHBAInfo = {}
        dataDict["allHBAInfo"] = self.allHBAInfo

    @HandleException
    def queryHosts(self):
        # /rest/[SN]/host
        # filter  "ISADD2HOSTGROUP"为true,"INITIATORNUM">0
        rest = contextUtil.getRest(self.dataDict)
        uri = "host"
        allHosts = CommonRestService.get4Page(rest, uri)
        self.allCliRet += ShareData.formatRestData(uri, allHosts)
        self.logger.logInfo("host num=%s" % len(allHosts))
        if allHosts:
            for host in allHosts:
                if host["ISADD2HOSTGROUP"] == "true" and int(host["INITIATORNUM"]) > 0:
                    self.hosts.append(host)

    # 检查执行入口
    def execute(self):
        self.logger = common.getLogger(contextUtil.getLogger(self.dataDict), __file__)
        self.lang = contextUtil.getLang(self.dataDict)
        try:
            # 检查当前版本 支持V3R6C10及之后的版本，通过配置文件控制是否有该检查项

            # 主机查询失败，未检查
            ok = self.queryHosts()
            if not ok:
                return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, self.allCliRet, common.getMsg(self.lang, "query.result.abnormal"))

            # 没有映射的主机，检查通过
            if len(self.hosts) == 0:
                self.logger.logInfo("no mapped host,the check is passed.")
                return ResultHandler(self.dataDict, ResultStatus.NO_MATCH_HOSTS, self.allCliRet, "").handleResult()

            spendTime = max(10, len(self.hosts))
            self.dataDict["checkState"] = common.PROCESS_STATE_CHECKING
            common.threadUp(self.dataDict, ITEM_ID, spendTime, spendTime + 10)
            # 依次对每个主机进行检查
            for host in self.hosts:
                # 如果时间过长，考虑多进程并发
                instance = SingleHostCompatibilityCheck(self.dataDict, host)
                result = instance.execute()
                oneHostCliRet = ""
                try:
                    oneHostCliRet = "\n".join(instance.allCliRet)
                except:
                    self.logger.logInfo("build cli ret exception.")

                ret = dict(hostId=host["ID"], hostName=host["NAME"],hostIp=host["IP"],
                           status=result.status, message=result.message,
                           cliRet=oneHostCliRet)
                if result.data and result.data.has_key("wwpn"):
                    ret["wwpn"] = result.data.get("wwpn")
                #保存HBA卡信息
                self.allHBAInfo[host["NAME"]] = instance.singleHostHBAInfo
                self.results.append(ret)

            status, message = self.mergeStatus()
            if status != ResultStatus.NEED_NEXT_CHECK:
                return ResultHandler(self.dataDict, status, self.allCliRet, message, self.errHosts).handleResult()

            # 主机类型(1:Windows 3:HP-UX, 4:AIX, 9:Windows server 2012)不支持端口漂移，不检查白名单和组网，直接关掉端口漂移开关
            supportFailover = True
            for host in self.hosts:
                if host.get("OPERATIONSYSTEM") in ["1", "3", "4", "9"]:
                    supportFailover = False
            if not supportFailover:
                return ResultHandler(self.dataDict, ResultStatus.NOT_SUPPORT_FAILOVER, self.allCliRet, "",
                                     self.errHosts).handleResult()

            devVer = contextUtil.getCurVersion(self.dataDict)
            if isOldDevVer(self.dataDict) == True:
                self.logger.logInfo("White List check before Current dev is old ver(%s)."%unicode(devVer))
                switchOn = FailOverUtil.isFailoverSwitchOn(self.dataDict)
                if switchOn[0] != True:
                    return ResultHandler(self.dataDict, ResultStatus.FAILOVER_OFF, self.allCliRet, message, self.errHosts).handleResult()
            #HBA白名单检查
            whiteCheckRet = HBAWhiteList(self.dataDict, self.allHBAInfo, self.hosts).check()
            self.logger.logInfo("whiteCheckRet result:%s"%unicode(whiteCheckRet))
            message = self.formatOutput(whiteCheckRet[2])
            if whiteCheckRet[0] != ResultStatus.NEED_NEXT_CHECK:
                return ResultHandler(self.dataDict, whiteCheckRet[0], self.allCliRet, message, self.errHosts).handleResult()

            #端口漂移组网检查
            checkResult = FailoverNetWorkCheck(self.dataDict).check()
            self.allCliRet = self.allCliRet + "\n" + checkResult[1]
            return ResultHandler(self.dataDict, checkResult[0], self.allCliRet, checkResult[2], self.errHosts).handleResult()
        except Exception, exception:
            self.logger.logException(exception)
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, self.allCliRet, common.getMsg(self.lang, "query.result.abnormal"))
        finally:
            try:
                common.finishProcess(self.dataDict, ITEM_ID)
            except:
                common.setProgress(self.dataDict, common.PROGRESS_NUM_MAX, ITEM_ID)

    def mergeStatus(self):
        allHostCliRet = map(lambda x: x["cliRet"], self.results)
        allHostCliRet = filter(lambda x: x != None, allHostCliRet)
        self.allCliRet += "\n".join(allHostCliRet)

        # 将结果按状态分类
        resultDict = {}
        for status in CheckStatus.getAllItems():
            resultDict[status] = []
        for result in self.results:
            resultDict[result["status"]].append(result)
        self.logger.logInfo("WhiteList check before result:%s"%resultDict)

        if len(resultDict.get(CheckStatus.HBAINFO_IN_BLACK)) > 0:
            status = ResultStatus.HBAINFO_IN_BLACK
        elif len(resultDict.get(CheckStatus.HBAINFO_UNKNOW)) > 0:
            status = ResultStatus.HBAINFO_UNKNOW
        elif len(resultDict.get(CheckStatus.QUERY_INFO_ERROR)) > 0:
            status = ResultStatus.QUERY_INFO_ERROR
        elif len(resultDict.get(CheckStatus.ULTRA_VERSION_ERROR)) > 0:
            status = ResultStatus.NEED_NEXT_CHECK
        else:
            status = ResultStatus.ULTRA_VERSION_PASS

            # 即使所有主机多路径版本检查通过，也不能灰化主机兼容性评估工具
            dev = contextUtil.getDevObj(self.dataDict)
            dev.setHostCompatible(False)
        self.logger.logInfo("WhiteList check before status:%s" % status)
        # 设置提示信息
        message = ""
        for key in CheckStatus.getAllItems():
            if len(resultDict[key]) > 0:
                message = self.formatOutput(resultDict[key])
                self.setHostInfo4Scene(resultDict[key])

        return (status, message)

    # 将主机按每5个换行显示
    def formatOutput(self, results):
        ret = ""
        for i in range(len(results)):
            if i%5 == 0:
                ret += "\n    "
            temp = results[i]
            ret += temp.get("hostName")
            if temp.has_key("wwpn"):
                ret += common.getMsg(self.lang, "hostcompatibility.result.wwpn", ','.join(temp.get("wwpn")))
            ret += ", "
        ret = ret[:-2] if ret.endswith(", ") else ret
        return ret
    
    def queryInitiatorInfoByHost(self, hostId, uri):
        initators = []
        try:
            rest = contextUtil.getRest(self.dataDict)
            ret = CommonRestService.get4Big(rest, uri)
            if ret is None or ret == "":
                return initators
            return ret
        except (Exception,JException), e:
            self.logger.logInfo("query initiator[uri:%s] exception:%s" %(uri,unicode(e)))
        return initators
        
    def queryInitiatorInfo(self, hostId):
        
        initatorList = []
        fcUri = "fc_initiator?PARENTID=%s" % hostId
        initators = self.queryInitiatorInfoByHost(hostId, fcUri)
        
        ibUri = "ib_initiator?PARENTID=%s" % hostId
        initators.extend(self.queryInitiatorInfoByHost(hostId, ibUri))
        
        iscsiUri = "iscsi_initiator?PARENTID=%s" % hostId
        initators.extend(self.queryInitiatorInfoByHost(hostId, iscsiUri))
        
        for initator in initators:
            if isinstance(initator,dict):
                initatorList.append(initator.get("NAME","--"))
            
        return initatorList
            
    def setHostInfo4Scene(self, results):
        '''
        @summary: 未检查时，设置场景化中用到的主机信息，列表顺序不能乱
        '''
        devNode = contextUtil.getDevObj(self.dataDict)
        for resultInfo in results:
            hostList = []
            hostId = resultInfo["hostId"]
            initatorList = self.queryInitiatorInfo(hostId)
            hostIp = resultInfo["hostIp"]
            if None == hostIp or "" == hostIp:
                hostIp = "--"
            
            hostList.append(resultInfo["hostName"])
            hostList.append(hostIp)
            hostList.append("; ".join(initatorList))
            hostList.append(devNode.getDeviceName())
            hostList.append(devNode.getDeviceSerialNumber())
            hostList.append(devNode.getIp())
            self.errHosts.append(",".join(hostList))
            
# 单个主机兼容性检查类
class SingleHostCompatibilityCheck():
    def __init__(self, dataDict, host):
        self.dataDict = dataDict
        self.hostId = host["ID"]
        self.host = host
        self.lang = contextUtil.getLang(dataDict)
        self.logger = common.getLogger(contextUtil.getLogger(self.dataDict), __file__)
        self.allCliRet = ["\n=========the host (%s) origin info start=========" % self.hostId]
        self.singleHostHBAInfo = []

    def execute(self):
        try:
            context = dict(host=self.host,
                           dataDict=self.dataDict,
                           allCliRet=self.allCliRet,
                           singleHostHBAInfo = self.singleHostHBAInfo)
            flow = NetworkCheck(self.hostId)
            while not isinstance(flow, FlowEnd):
                self.logger.logInfo("flow start, step=%s" % flow.__class__)
                flow.setContext(context)
                ok = flow.queryInfo()
                if not ok:
                    if isinstance(flow, UltraPathVersionCheck):
                        self.logger.logInfo("UltraPathVersionCheck queryinfo fail.")
                        flow = FlowEnd(CheckStatus.ULTRA_VERSION_ERROR)
                        break
                    self.logger.logInfo("quey info failed.")
                    flow = FlowEnd(CheckStatus.QUERY_INFO_ERROR)
                    break
                flow = flow.next()
                self.logger.logInfo("flow next, step=%s" % flow.__class__)
            return flow
        except Exception, e:
            self.logger.logException(e)
            self.logger.logInfo("single host compatibility:%s" % unicode(e))
            return FlowEnd(CheckStatus.QUERY_INFO_ERROR)
        finally:
            self.allCliRet.append("\n=========the host (%s) origin info end=========" % self.hostId)

class FlowEnd():
    def __init__(self, status, message="", data=None):
        self.status = status
        self.message = message
        self.data = data

class CheckStatus():
    PASS = "pass"
    NOPASS = "nopass"
    HBAINFO_UNKNOW = "hbainfoError"
    ULTRA_VERSION_ERROR = "ultraVersionError"
    QUERY_INFO_ERROR = "queryInfoError"
    HBAINFO_IN_BLACK = "hbaInfoInBlack"
    HBAINFO_IN_WHITE = "hbaInfoInWhite"
    HBAINFO_NOT_IN_WHITE = "hbaInfoNotInWhite"

    @staticmethod
    def getAllItems():
        return ["pass","nopass","hbainfoError","ultraVersionError","queryInfoError", "hbaInfoInBlack",
                "hbaInfoInWhite","hbaInfoNotInWhite"]

    @staticmethod
    def getCannotEvaluItems():
        return ["hbainfoError","ultraVersionError","queryInfoError"]

    @staticmethod
    def getCannotCheckWhiteItems():
        return ["nopass", "hbainfoError", "queryInfoError"]

class ResultStatus():
    NO_MATCH_HOSTS = "noMatchHosts"
    NO_PASS = "noPass"
    HBAINFO_UNKNOW = "hbainfoError"
    HBAINFO_IN_BLACK = "hbaInfoInBlack"
    ULTRA_VERSION_PASS = "ultraVersionPass"
    QUERY_INFO_ERROR = "queryInfoError"
    NOT_IN_WHITE = "notInWhite"
    FAILOVER_FAIL = "failoverFail"
    FAILOVER_PASS = "failoverPass"
    FAILOVER_OTHERS = "failoverOthers"
    NEED_NEXT_CHECK = "needNextCheck"
    QUERY_COMMON_ERROR = "queryCommonError"
    FAILOVER_OFF = "failoveroff"
    OPEN_SWITCH_ERROR = "openSwitchError"
    OFF_SWITCH_ERROR = "offSwitchError"
    NOT_SUPPORT_FAILOVER = "noSupportFailover"

    @staticmethod
    def getCloseSwitchStatus():
        return [ResultStatus.HBAINFO_UNKNOW, ResultStatus.ULTRA_VERSION_PASS]

    @staticmethod
    def getOpenSwitchStatus():
        return [ResultStatus.FAILOVER_PASS]

class ResultHandler():
    def __init__(self, dataDict, status=ResultStatus.QUERY_COMMON_ERROR, cliRet="", data=None, errHosts = []):
        self.dataDict = dataDict
        self.status = status
        self.cliRet = cliRet
        self.data = data
        self.lang = contextUtil.getLang(dataDict)
        self.errHosts = errHosts


    def handleResult(self):
        if self.status in [ResultStatus.NO_MATCH_HOSTS, ResultStatus.ULTRA_VERSION_PASS] or self.data == None:
            errMsg = ""
        elif self.status == ResultStatus.QUERY_COMMON_ERROR:
            errMsg = common.getMsg(self.lang, "hostcompatibility.result.%s" % self.status)
        else:
            errMsg = common.getMsg(self.lang, "hostcompatibility.result.%s" % self.status, self.data)

        turnoff = True
        if self.status == ResultStatus.NO_MATCH_HOSTS:
            #没有映射的主机，检查通过，并关闭端口漂移
            status = True
        elif self.status == ResultStatus.HBAINFO_IN_BLACK:
            #HBA在黑名单中，不支持在线升级，检查不通过
            status = False
        elif self.status == ResultStatus.NOT_IN_WHITE:
            #HBA信息不在白名单中，新版本需要关闭端口漂移开关，老版本直接报未检查。
            status = cliUtil.RESULT_NOCHECK
        elif self.status in ResultStatus.getCloseSwitchStatus():
            #HBA 信息获取失败、多路径版本检查成功，需要关闭端口漂移，不区分新、老版本
            status = cliUtil.RESULT_NOCHECK
            if self.status == ResultStatus.ULTRA_VERSION_PASS:
                status = True
        elif self.status == ResultStatus.FAILOVER_PASS:
            #端口漂移组网检查通过，老版本报通过，新版本需要开启端口漂移开关
            errMsg = ""
            status = True
            turnoff = False #端口漂移开关不关
            if isOldDevVer(self.dataDict) == False:
                switchResult = FailOverUtil.failoverSwitch(self.dataDict, "on")
                self.cliRet += '\n%s' % switchResult[1]
                if switchResult[0] != True:
                    errMsg = common.getMsg(self.lang, "hostcompatibility.result.%s" % ResultStatus.OPEN_SWITCH_ERROR)
                    status = cliUtil.RESULT_NOCHECK
        elif self.status == ResultStatus.FAILOVER_FAIL:
            turnoff = False  # 端口漂移开关不关
            #端口漂移组网检查失败，新版本要判断端口漂移开关是否开启，若开始报失败，若关闭报未检查；
            if isOldDevVer(self.dataDict) == False:
                switchResult = FailOverUtil.isFailoverSwitchOn(self.dataDict)
                self.cliRet += '\n%s' % switchResult[1]
                if switchResult[0] == True:
                    status = False
                else:
                    errMsg = common.getMsg(self.lang, "hostcompatibility.result.failoverFail.off")
                    status = cliUtil.RESULT_NOCHECK
            else:
                status = False
        elif self.status in [ResultStatus.QUERY_INFO_ERROR, ResultStatus.QUERY_COMMON_ERROR]:
            #查询信息失败、以及其它异常，不关闭端口，报未检查
            status = cliUtil.RESULT_NOCHECK
        else:
            status = cliUtil.RESULT_NOCHECK

        if turnoff:
            switchResult = FailOverUtil.failoverSwitch(self.dataDict, "off")
            self.cliRet += '\n%s' % switchResult[1]
            if switchResult[0] != True:
                status = cliUtil.RESULT_NOCHECK
                errMsg = common.getMsg(self.lang, "hostcompatibility.result.%s" % ResultStatus.OFF_SWITCH_ERROR)

        if status != True:
            devNode = contextUtil.getDevObj(self.dataDict)
            devNode.setHostInfoList(Tlv2Rest.pList2JList(self.errHosts))
        return common.getUpgEvaluationRs(status, self.cliRet, errMsg)

class ShareData():
    def __init__(self):
        self.context = {}
        self.dataDict = {}
    def setContext(self, context):
        self.context = context
        self.host = context["host"]
        self.dataDict = context["dataDict"]
        self.logger = common.getLogger(contextUtil.getLogger(self.dataDict), __file__)
        self.lang = contextUtil.getLang(self.dataDict)

    def appendCliRet(self, cliRet):
        self.context["allCliRet"].append(cliRet)

    def appendRestRet(self, uri, datas):
        dataStr = self.formatRestData(uri, datas)
        self.context["allCliRet"].append(dataStr)

    def appendSingleHostHBAInfo(self, hbaInfo):
        self.context["singleHostHBAInfo"].append(hbaInfo)

    @staticmethod
    def formatRestData(uri, datas):
        dataStr = ""
        if datas:
            for data in datas:
                dataStr += str(data)
                dataStr += "\n"
        return "\nRest Uri:%s\nResponse:[%s]" % (uri, dataStr)

class NetworkCheck(ShareData):
    def __init__(self, hostId):
        ShareData.__init__(self)
        self.hostId = hostId
        self.fcinitators = []

    @HandleException
    def queryInfo(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "fc_initiator?PARENTID=%s&filter=RUNNINGSTATUS::27" % self.hostId
        self.fcinitators = CommonRestService.get4Big(rest, uri)
        self.appendRestRet(uri, self.fcinitators)
        return True

    def next(self):
        if self.fcinitators is None or len(self.fcinitators) == 0:
            return UltraPathVersionCheck(self.hostId)
        else:
            return HBACheck(self.fcinitators)

# 黑名单检查（此处仅查询，检查逻辑已移至独立的检查项）
class HBACheck(ShareData):
    isFirst = True
    blackRecords = []
    hbaNodes = []
    def __init__(self, fcinitators):
        ShareData.__init__(self)
        self.fcinitators = fcinitators

    @HandleException
    def queryInfo(self):
        if HBACheck.isFirst:

            # 从运行数据中获取PANGEA_INFO表信息
            ok, tableStr = toolAnalyzer.getTableStrByName(self.dataDict, "pangea")
            self.appendCliRet(tableStr)
            if not ok:
                return False

            #将字符串按竖表进行解析
            self.logger.logInfo("the pangea tableStr=%s" % tableStr)
            verticalTable = VerticalTable(tableStr, self.logger)
            if not verticalTable.parse():
                self.logger.logInfo("parse pangea table failed")
                return False
            HBACheck.hbaNodes = verticalTable.findNodes(1, "HBA info")
            self.logger.logInfo("HBA nodes info is %s" % HBACheck.hbaNodes)

            HBACheck.isFirst = False

    def next(self):
        for fcinitator in self.fcinitators:
            wwpn = fcinitator["ID"]
            # 从运行数据中查找HBAInfo
            ok, hbaInfo = self._findHBAInfo(HBACheck.hbaNodes, wwpn)
            hbaInfodict = dict(wwpn=wwpn, hbaInfo=hbaInfo)
            self.appendSingleHostHBAInfo(hbaInfodict)
            if not ok:
                self.logger.logInfo("the wwpn=%s can not find hbainfo" % wwpn)

        return UltraPathVersionCheck(self.host.get("ID"))

    def _parseHBAInfo(self, hbaInfo):
        '''
        博科：
            Emulex 42D0494 FV1.11A5  DV2.74.214.004 VEEAMBACKUP
            QLE2672 FW:v7.03.00 DVR:v2.1.30.0
        思科：
            Emulex LPe11002 FV2.71X15 DV8.2.0.128.3p
            Emulex LPe1250-F8 FV2.01A13 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0
            QLE2462 FW:v5.03.01 DVR:v8.03.01.12.10.3-k
            QLE2672 FW:v6.02.00 DVR:v2.1.53.0
            QLE2560 FW:v8.02.00 DVR:v2.1.53.0
        阵列：
            Emulex LPe16002-M6 FV10.6.144.21 DV11.1.145.16 HN:WIN2008-74 OS:Windows 2008
            QLE2562 FW:v5.08.00 DVR:8.04.00.13.11.3-k
        :return: 
        '''
        EmulexRegex = "^(Emulex\s\S+)\s+FV(\S+)\s+DV(\S+)"
        QlogicRegex = "^(QLE\S+)\s+FW:v(\S+)\s+DVR:v?(\S+)"
        rec = re.match(EmulexRegex, hbaInfo, re.IGNORECASE)
        if not rec:
            rec = re.match(QlogicRegex, hbaInfo)
        if rec:
            hba = dict()
            hba["adapter"] = rec.group(1).strip()
            hba["firmware"] = rec.group(2).strip()
            hba["driver"] = rec.group(3).strip()
            return True, hba
        return False, ""

    def _isInCompatibilityBlackList(self, hba):
        for record in HBACheck.blackRecords:
            if record["Host_Bus_Adapter"].lower() in [hba["adapter"].lower(), ""] \
                    and record["HBA_firmware_version"].lower() in [hba["firmware"].lower(), ""]\
                    and record["HBA_driver_version"].lower() in [hba["driver"].lower(), ""]:
                return True
        return False

    def _findHBAInfo(self, nodes, wwpn):
        for node in nodes:
            for item in node.children:
                if item.get("WWPN", "") == wwpn:
                    return True, item.get("HBA", "")
        return False, ""

class UltraPathVersionCheck(ShareData):
    def __init__(self, hostId):
        ShareData.__init__(self)
        self.hostId = hostId
        self.hostLinks = []

    @HandleException
    def queryInfo(self):
        # /rest/[SN]/host_link?TYPE=255&PARENTID=[host_id]
        rest = contextUtil.getRest(self.dataDict)
        for initiatorType in ["223", "222", "16499"]:
            uri = "host_link?INITIATOR_TYPE={}&PARENTID={}"\
                .format(initiatorType, self.hostId)
            datas = CommonRestService.get4Big(rest, uri)
            self.appendRestRet(uri, datas)
            if datas:
                self.hostLinks.extend(datas)

    def next(self):
        # 要求每条主机链路的多路径版本都在8.00.000以上
        if self.hostLinks is None or len(self.hostLinks) == 0:
            return FlowEnd(CheckStatus.PASS)
        for hostLink in self.hostLinks:
            # 只判断在线的链路
            if hostLink.get("RUNNINGSTATUS") != "27":
                continue

            ultra_path_version = hostLink.get("ULTRAPATHVERSION")
            if ultra_path_version is None:
                ultra_path_version = hostLink.get("ultraPathVersion")
            if not self._checkUltraPathVersion(ultra_path_version):
                self.logger.logInfo("the ultrapath version is lower, version "
                                    "is {}".format(ultra_path_version))
                return FlowEnd(CheckStatus.ULTRA_VERSION_ERROR)
        return FlowEnd(CheckStatus.PASS)

    def _checkUltraPathVersion(self, version):
        ULTRAPATH_LEAST_VERSION = 8
        if not version or version == "":
            return False
        sections = version.split(".")
        if len(sections) == 3:
            return int(sections[0].strip()) >= ULTRAPATH_LEAST_VERSION
        return False

class FailOverUtil():
    @staticmethod
    def failoverSwitch(dataDict, switch):
        cli = contextUtil.getSSH(dataDict)
        LANG = contextUtil.getLang(dataDict)

        cmd = "change upgrade port_failover_switch switch=%s" % switch
        if isOldDevVer(dataDict):
            cmd = "change logical_port failover_switch service_type=SAN switch=%s" % switch

        retFlag = True
        errMsg = ""
        retryTime = 0
        while retryTime < 2:
            try:
                checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG, preExec=False)
                cliRet = checkRet[1]
                if not cliUtil.hasCliExecPrivilege(cliRet):
                    return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
                cliRet = checkRet[1]
                if "Command executed successfully" in cliRet:
                    return (True, cliRet, "")
                else:
                    retryTime += 1
                    errMsg = checkRet[2]
                    time.sleep(5)
                    continue
            except Exception,ex:
                errMsg = cliUtil.getMsg(LANG, "query.result.abnormal")
                retryTime += 1
                time.sleep(5)
                continue
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)

    @staticmethod
    def isFailoverSwitchOn(dataDict):
        cli = contextUtil.getSSH(dataDict)
        LANG = contextUtil.getLang(dataDict)

        cmd = "show upgrade port_failover_switch"
        if isOldDevVer(dataDict):
            cmd = "show logical_port failover_switch service_type=SAN"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG, preExec=False)
        cliRet = checkRet[1]
        # 命令不存在场景时，返回不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        elif "off" in cliRet.lower():
            return (False, cliRet, checkRet[2])
        elif "on" in cliRet.lower():
            return (True, cliRet, "")
        else:
            return (False, cliRet, checkRet[2])

class HBAWhiteList():
    def __init__(self, dataDict, allHBAInfo, hosts):
        self.dataDict = dataDict
        self.allHBAInfo = allHBAInfo
        self.hosts = hosts
        self.logger = common.getLogger(contextUtil.getLogger(self.dataDict), __file__)
        self.lang = contextUtil.getLang(self.dataDict)

    def _checkInHbaWhiteList(self, hbaInfoStr):
        if "HN:" in hbaInfoStr:
            hbaInfoStr = hbaInfoStr.split("HN:")[0].strip()
        hbaInfoStr = "HBA:" + hbaInfoStr

        for hbaStr in config.HBA_WHITE_LIST:
            if hbaStr.startswith(hbaInfoStr):
                return True
        return False

    def _hbaWhiteListCheck(self):
        notInWhiteList = []
        if self.allHBAInfo == None or len(self.allHBAInfo) == 0:
            self.logger.logInfo("_inHBAInWhiteList HBA info is null")
            return True, notInWhiteList

        for hostName in self.allHBAInfo.keys():
            notInWhiteDict = {}
            notInWhiteDict["hostName"] = hostName
            notInWhiteDict["wwpn"] = []
            hostHbainfo = self.allHBAInfo.get(hostName)
            for hbaInfo in hostHbainfo:
                self.logger.logInfo("HBAWhiteList hbainfo:%s,%s"%(hbaInfo.get("wwpn"), hbaInfo.get("hbaInfo")))
                if hbaInfo.get("hbaInfo", "") == "":
                    notInWhiteDict["wwpn"].append(hbaInfo.get("wwpn"))
                    continue
                flag = self._checkInHbaWhiteList(hbaInfo.get("hbaInfo"))
                self.logger.logInfo("HBAWhiteList flag:%s" % (flag))
                if not flag:
                    notInWhiteDict["wwpn"].append(hbaInfo.get("wwpn"))
            if len(notInWhiteDict.get("wwpn")) > 0:
                notInWhiteList.append(notInWhiteDict)

        self.logger.logInfo("HBAWhiteList notInWhiteList:%s" % (notInWhiteList))

        for wwpnDict in notInWhiteList:
            if len(wwpnDict.get("wwpn")) > 0:
                return False, notInWhiteList

        self.logger.logInfo("HBAWhiteList check result succuss")
        return True, notInWhiteList

    def check(self):
        try:
            inWhiteFlag,notInWhiteDict = self._hbaWhiteListCheck()
        except (Exception,JException),ex:
            self.logger.logException(ex)
            return (ResultStatus.QUERY_COMMON_ERROR, "", [])
        if inWhiteFlag == True:
            return (ResultStatus.NEED_NEXT_CHECK, "", notInWhiteDict)
        else:
            return (ResultStatus.NOT_IN_WHITE, "", notInWhiteDict)


class FailoverNetWorkCheck():
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = common.getLogger(contextUtil.getLogger(self.dataDict), __file__)

    def check(self):
        checkResult = check_cli_software_checkFailover.execute(self.dataDict)
        self.logger.logInfo("FailoverNetWorkCheck result:%s"%unicode(checkResult))
        if checkResult[0] == cliUtil.RESULT_DICT[True]:
            return (ResultStatus.FAILOVER_PASS, checkResult[1], checkResult[2])
        elif checkResult[0] == cliUtil.RESULT_DICT[False]:
            return (ResultStatus.FAILOVER_FAIL, checkResult[1], checkResult[2])
        else:
            return (ResultStatus.FAILOVER_OTHERS, checkResult[1], checkResult[2])


def isOldDevVer(dataDict):
    devVer = contextUtil.getCurVersion(dataDict)
    if contextUtil.isDoradoDev(dataDict):
        if devVer < NEW_VER_DORADO:
            return True
    else:
        if ("V3" in devVer and  devVer < NEW_VER_V3) or ("V5"in devVer and devVer < NEW_VER_V5):
            return True
    return False