# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
from frame.cli import cliUtil

def execute(context):
    '''
    @summary: 检查硬盘是否在线诊断
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""

        # 如果是离线升级，且版本小于V5R7C60SPC300不需要进行该检查
        dev = context.get('dev')
        devVersion = str(dev.getProductVersion())
        upgradeMode = str(dev.getUpgradeMode())
        if upgradeMode.lower() == "offline" \
                and devVersion < "V500R007C60SPC300":
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")

        checkItem = "CHECK_DISK_ISDISKDIAGNOSE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        cliRet = recs
        errMsgList = []#保存错误信息的列表
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            if result == "False":
                continue
            (ok, errorKeyLst) = failureCharacteristics(result)
            flag = False
            if not ok:
                errMsgList.append(common.getMsg(lang, "check.result.abnormal", nodeId))
            else:
                for oneError in errorKeyLst:
                    oneErrorRes = itemDict.get(oneError, None)
                    errMsgList.append(common.getMsg(lang, oneErrorRes["msg"], nodeId))
        errMsg = "".join(errMsgList)
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
            
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def failureCharacteristics(result):
    failureLst = ["True", "Erasing", "Timeout"]
    errorKeyLst = result.split(';')
    errorKeyLst = list(set(errorKeyLst).intersection(set(failureLst)))
    if not errorKeyLst:
        return False, errorKeyLst
    return True, errorKeyLst