# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil

def execute(context):
    '''
    @summary: ibc_os_hs账户密码是否为默认检查 
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        errMsg = ""
        
        curVer = contextUtil.getCurVersion(context)
        #只有Dorado6000 V300R001C00版本向后升级或者V3R6C00向后升级的时候才需要检查IBC密码
        if curVer not in  ["V300R001C00","V300R006C00"]:
            logger.logInfo("check ibc password not support this target version:%s"%unicode(curVer))
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        tlvCon = contextUtil.getTlvObj(context)
        
        res = tlvUtil.isIBCPasswordChanged(tlvCon)
        logger.logInfo("check ibc password result:%s"%unicode(res))
        if 0!=res:
            errMsg += common.getMsg(lang, "ibc.passwd.changed")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        return common.getUpgEvaluationRs(True, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))


