# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
import traceback
from frame.base import baseUtil

def execute(context):
    '''
    @summary: 系统异常复位后台任务抑制检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = "NA"
    errMsg = ""

    try:
        flag = True
        curDevType = contextUtil.getDevType(context)
        curSpcVersion = contextUtil.getCurVersion(context)
        if not curDevType or len(curSpcVersion) < 11:
            return common.getUpgEvaluationRs("NOCHECK", cliRet, common.getMsg(lang, "query.result.abnormal"))

        if baseUtil.isDoradoNasDev(curDevType):
            logger.logInfo("is dorado nas, need check restrict state.")
        #Dorado V3版本：V300R001C21及之前的版本不涉及（包含TR5版本）
        elif baseUtil.isDoradoDev(curDevType):
            if curSpcVersion <= "V300R001C21":
                return common.getUpgEvaluationRs("NOSUPPORT", cliRet, errMsg)
        #融合存储V3版本：V3R6C20及以后、V5R7C10及以后版本需要支持
        elif curSpcVersion < "V300R006C20":
            return common.getUpgEvaluationRs("NOSUPPORT", cliRet, errMsg)
        elif curSpcVersion.startswith("V500") and curSpcVersion < "V500R007C10":
            return common.getUpgEvaluationRs("NOSUPPORT", cliRet, errMsg)

        checkItem = "CHECK_SOFTWARE_RESTRICTSTATE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]

        #根据检查项获取配置字典值
        tlv = contextUtil.getTlvObj(context)
        recs = tlvUtil.getCtrlTaskRestrictState(tlv)
        logger.logInfo("records=%s" % unicode(recs))
        for record in recs:
            ctrlId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESTROCTST_CTRL_ID"])
            state = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESTROCTST_STATE"])
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(state, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", ctrlId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is False:
                flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], ctrlId)
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except:
        logger.logInfo(traceback.format_exc())
        return common.getUpgEvaluationRs("NOCHECK", cliRet, common.getMsg(lang, "query.result.abnormal"))
