# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: XNET压力检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRetValue = ""
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_XNETPRESSURE"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli命令在Debug模式下的回显，保存在cliRetList
        cli = contextUtil.getSSH(context)
        cmdList = list()
        cmdList.append("dpumm_shm show meminfo -m 228")
        cmdList.append("dpumm_mm show meminfo -m 228")
        cliRetList = cliUtil.GetCliRecsInDebugMode(cli, cmdList, logger, lang)
        cliRetValue = "\n".join(cliRetList)
        
        for record in recs:
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                itemVal = itemDict["False"]
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRetValue, common.getMsg(lang, "query.result.abnormal"))
    