# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.upgradeevalu.entity import UpgradeMode
from utils import Products

# 受限的目标版本列表（所有版本都不能升级到该版本）
LIMIT_DEST_VER = ['V300R006C00', 'V300R006C00SPC100']
PRODUCT_TYPE_LIST = ['2800 V3', '5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3',
                     '6800F V3', '5800F V3', '5600F V3', '5500F V3', '2600F V3',
                     '2100 V3', '2200 V3', '2600 V3', '2600 V3 for Video',
                     '18500 V3', '18800 V3', '18800F V3', '18500F V3']

# 二级存储X系列
OCEANPROTECT_X = ["OceanProtect X8000", "OceanProtect X9000", "OceanProtect E8000",
                  "OceanProtect X6000", "OceanProtect X8000K",
                  "OceanProtect X9000K", "OceanProtect X3000"]

# 二级存储X系列 除去OceanProtect X8000,OceanProtect X9000
OCEANPROTECT_X_120_121 = ["OceanProtect X6000", "OceanProtect X8000K",
                          "OceanProtect X9000K", "OceanProtect X3000"]

# 二级存储X系列 除去OceanProtect X8000,OceanProtect X9000
X8000_X9000 = ["OceanProtect X8000", "OceanProtect X9000"]

# 二级存储X系列允许升级到1.2.RC1的版本
ALLOWED_UPGRADE_VERSION_FOR_OCEANPROTECT_X = ["1.0.0", "1.1.0", "1.2.RC1"]

# X8000的原版本不支持升级到1.2.1的列表
NOT_SUPPORT_UPGRADE_TO_121_VERSIONS = ["1.0.0", "1.1.0", "1.2.0"]

# puerly包装的型号暂无升级路径
PURELY_SRC_VER = ['V500R007C10SPC100', 'V300R006C20SPC100']


def execute(context):
    '''
    @summary: 检查此升级路径是否为受限路径
    @param context: 上下文信息
    @return:
    '''
    dev = context.get('dev')
    destVersion = str(dev.getDestVersion())
    srcVersion = str(dev.getProductVersion())
    devType = str(dev.getDeviceType())
    upgrade_mode = str(dev.getUpgradeModeUI())

    curDir = os.path.dirname(__file__)
    fileName = "cancellimit.txt"
    filePath = os.path.join(curDir, fileName)
    if (os.path.exists(filePath)):
        return (False, '')

    logger = context.get("logger")
    logger.info("upgrade_mode is：%s", upgrade_mode)
    logger.info("start check V3")
    # 检查V3的升级限制
    if check_limit_patch_for_v3(dev, devType, srcVersion, destVersion):
        return True, ""
    logger.info("start check V5")
    # 检查V5的升级限制
    if check_limit_patch_for_v5(devType, srcVersion, destVersion):
        return True, ""
    logger.info("start check Dorado")
    # 检查Dorado的升级限制
    if check_limit_patch_for_dorado(devType, srcVersion, destVersion, upgrade_mode):
        return True, ""
    logger.info("start check X")
    # 检查二级存储X系列的升级限制
    if check_limit_patch_for_ocean_protect_x(devType, srcVersion, destVersion, upgrade_mode):
        return True, ""

    return False, ''


def check_limit_patch_for_v3(dev, dev_type, src_version, dest_version):
    """
    检查V5升级路径是否受限
    :param dev: 存储设备
    :param dev_type: 设备型号
    :param src_version: 原版本
    :param dest_version: 目标版本
    :return:
    """
    if dev_type in PRODUCT_TYPE_LIST and dest_version in LIMIT_DEST_VER:
        return True

    # 2200 V3, 2600 V3不支持从V3R5C01往V3R6C30及之后的版本升级，只能升级到V3R6C20及之前版本
    if dev_type in ["2200 V3", "2600 V3"] and src_version == "V300R005C01" \
            and dest_version >= "V300R006C30":
        return True
    if dev_type == "2800 V3" and src_version == "V300R001C00SPC200" and \
            dest_version in ["V300R006C50SPC100", "V300R006C50"] and \
            dev.getUpgradeMode().equals(UpgradeMode.ONLINE):
        return True
    if "dorado" in dev_type.lower():
        return False
    if src_version < "V300R006C10" and dest_version == "V300R006C60SPC100":
        return True
    if src_version == "V300R002C10" and dest_version >= "V300R003C10":
        return True
    if src_version == "V300R005C01" and dest_version == "V300R006C00":
        return True
    return False


def check_limit_patch_for_v5(dev_type, src_version, dest_version):
    """
    检查V5升级路径是否受限
    :param dev_type: 设备型号
    :param src_version: 原版本
    :param dest_version: 目标版本
    :return:
    """
    if "Enhanced" in dev_type and src_version in PURELY_SRC_VER:
        return True
    if src_version == "V500R007C60SPC200 Kunpeng" and \
            Products.compareVersion(dest_version, "V500R007C70 Kunpeng") >= 0:
        return True

    # 5610 V5 不支持从V5R7C70SPC200及之前版本升级到V5R7C71;
    if dev_type in ["5610 V5"] and Products.compareVersion(
            src_version, "V500R007C70SPC200 Kunpeng") <= 0 \
            and dest_version == "V500R007C71 Kunpeng":
        return True

    return False


def check_limit_patch_for_ocean_protect_x(dev_type, src_version, dest_version, upgrade_mode):
    """
    检查二级存储升级路径是否受限
    :param dev_type: 设备型号
    :param src_version: 原版本
    :param dest_version: 目标版本
    :param upgrade_mode: 升级模式
    :return:
    """
    # X8000 "1.0.0", "1.1.0", "1.2.RC1",1.2.RC2,不支持升级到1.2.1。
    if dev_type in X8000_X9000 \
            and Products.formatDigitalVersion(src_version) in NOT_SUPPORT_UPGRADE_TO_121_VERSIONS \
            and "1.2.1" in dest_version:
        return True

    if dev_type in OCEANPROTECT_X_120_121 and Products.formatDigitalVersion(src_version) in ["1.1.0", "1.2.0"] \
            and "1.2.1" in dest_version:
        return True
    # 二级存储不支持1.0.0快速升级至1.1.0及以后
    if all([dev_type in OCEANPROTECT_X, Products.formatDigitalVersion(src_version) == "1.0.0",
            Products.compareVersion(dest_version, "1.1.0") >= 0, upgrade_mode == "FAST"]):
        return True


def check_limit_patch_for_dorado(dev_type, src_version, dest_version, upgrade_mode):
    """
    检查dorado升级路径是否受限
    :param dev_type: 设备型号
    :param src_version: 原版本
    :param dest_version: 目标版本
    :param upgrade_mode: 升级模式
    :return:
    """
    # 6.1.99版本只能由6.1.6RC1、6.1.6和6.1.99RC1通过滚动和快速升级到
    if dest_version.startswith("6.1.99"):
        return not (src_version in ("6.1.6", "6.1.6RC1", "6.1.99RC1") and upgrade_mode in ("ROLL", "FAST"))
    # 6.1.99版本仅支持通过快速升级和滚动升级到6.1.7
    if src_version.startswith("6.1.99"):
        return not ("6.1.7" in dest_version and upgrade_mode in ("ROLL", "FAST"))
    if "dorado" not in dev_type.lower():
        return False
    # dorado6.0.RC1版本不支持升级到6.1.0
    if src_version == "6.0.RC1" and \
            Products.compareVersion(dest_version, "6.1.0") >= 0:
        return True
    # Dorado 3000/5300 V6不支持升级到6.1.RC2
    if dev_type in ["OceanStor Dorado 3000 V6", "OceanStor Dorado 5300 V6"] \
            and dest_version == "6.1.RC2":
        return True
    return False
