# -*- coding: UTF-8 -*-
from com.huawei.ism.tool.base.utils import AESEncrypt
from com.huawei.ism.tool.base.utils import TaskKeyUtil
from frame.common import common
from frame.context import contextUtil
from frame.cli import cliUtil
from xml.dom import minidom
import os
import shutil
import subprocess
import threading
import traceback
import time
import sys
from xml.dom.minidom import Document
from java.io import File
import datetime
CLI_RET_END_FLAG = ":/>"


def reloadSysEncoding():
    try:
        reload(sys)
        sys.setdefaultencoding('utf-8')
    except:
        pass


reloadSysEncoding()

DIR_RELATIVE_CMD = "..\.."
LOGGER = ''
# 工具运行目录
BASE_ROOT_PATH = ''

# 收集的临时目录和上传目录
COLLECT_PATH_TEMP = "\\tools\\upgradeEvaluation\\check_log_collect\\"

# 静默调用的taskFile文件模板
TASK_TEMPLET_FILE = "\\tools\\upgradeEvaluation\\packages\\upgradeEvaluation\\taskFileTemplet.xml"
TASK_FILE = "taskFile.xml"
PROGRESS_FILE = "Progress.xml"
# 静默调用执行的命令行
SILENCECALL_CMDS = ["cd ..\\..\n",
                    " jre\\bin\\java -jar plugins\\silenceCall\\SilenceCall.jar",
                    " -callTool=toolkit -sence=logCollect",
                    " -taskfile=\"tools\\upgradeEvaluation\\check_log_collect\\taskFile.xml\"",
                    " -exParams=\"{'noCompress':'true'}\""]

DEV_TYPE_18000V1 = ['HVS85T', 'HVS88T', '18500', '18800', '18800F']
DEV_PRODUCT_18000V1 = ['V100R001C20', 'V100R001C30']

# 静默调用执行的命令行
SILENCECALL_CMDS_FOR_18000V1 = ["cd ..\\..\n",
                                " jre\\bin\\java -jar plugins\\SilenceCall.jar",
                                " -callTool=toolkit -sence=logCollect",
                                " -taskfile=\"tools\\upgradeEvaluation\\check_log_collect\\taskFile.xml\"",
                                " -exParams=\"{'noCompress':'true'}\""]

# 临时的bat文件，用于执行静默调用
TEMP_BAT_FILE = "tmpCollectInfos.bat"

CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
PARALLEL_EXPORT_INFO_TIMEOUT = 23*60
# 判断导出命令的回显是否正常的标准
COLLECT_INFO_RECROD_STANDARD = "File Path :"
# progress xml 节点值
STATUS = ["finished", "checking"]
RESULT = ["success", "failed"]
MAX_PROCESS = "100"


def execute(context):
    """
    @summary: 日志检查
    """
    global LOGGER, BASE_ROOT_PATH
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    try:
        BASE_ROOT_PATH = os.path.abspath(DIR_RELATIVE_CMD)

        # 清空搜集目录
        rmTempDir()

        isNeedCollect = False
        devs = context.get("devs")
        if not devs:
            return

        for dev in devs:
            LOGGER.logInfo("is need collect %s %s" % (dev.isNeedLog(), dev))
            if dev.isNeedLog():
                isNeedCollect = True
                break

        # 如果选择的所以设备都不需要收集直接返回
        if not isNeedCollect:
            return

        collectLog(context)
    except:
        LOGGER.logError(traceback.format_exc())


def rmTempDir():
    """
    @summary: 删除临时目录
    """
    LOGGER.logInfo("start remove temp directory.")
    try:
        os.remove(BASE_ROOT_PATH + COLLECT_PATH_TEMP + PROGRESS_FILE)
    except Exception, e:
        LOGGER.logException(e)

    try:
        collectPath = BASE_ROOT_PATH + COLLECT_PATH_TEMP
        shutil.rmtree(collectPath)
    except Exception, e:
        LOGGER.logException(e)

    try:
        os.remove(TEMP_BAT_FILE)
    except Exception, e:
        LOGGER.logException(e)
    LOGGER.logInfo("remove temp directory successfully.")


def collectLog(context):
    """
    @summary: 收集日志
    """
    global TEMP_BAT_FILE
    LOGGER.logInfo("start collect log.")
    # 读取模板
    doc = minidom.parse(BASE_ROOT_PATH + TASK_TEMPLET_FILE)
    lang = contextUtil.getLang(context)

    devs = context.get("devs")
    if not devs:
        LOGGER.logInfo("get devices failed.")
        return False, common.getMsg(lang, "log.check.collect.fail")
    dev = context.get("devs")[0]

    if dev and dev.getDeviceModel() in DEV_TYPE_18000V1 \
            and dev.getProductVersion()[0:11] in DEV_PRODUCT_18000V1:

        path = makeLogDirectory(dev)
        isSucc = collectLog18000V1(context, path)

        if not isSucc:
            processXmlDict(STATUS[0], MAX_PROCESS, RESULT[1])
            return False, common.getMsg(lang, "log.check.collect.fail")

        return True, ""

    # 生成taskFile.xml
    LOGGER.logInfo("start write task file xml.")
    isSucc = writeTaskFileXML(context, doc)
    if not isSucc:
        LOGGER.logError("write task file xml failed.")
        return False, common.getMsg(lang, "log.check.collect.fail")
    LOGGER.logInfo("write task file xml successfully.")

    # 构造bat命令
    TEMP_BAT_FILE = createTmpBatFile(context)

    if not TEMP_BAT_FILE:
        return False, common.getMsg(lang, "log.check.collect.fail")

    # 调用jar包收集
    doCollect(context, TEMP_BAT_FILE)


def isNotSshForward(dev):
    """
    @summary: 是否是SSH跳转
    @return: True 不是SSH跳转， False 是SSH跳转。
    """
    try:
        return dev.isNotSshForward()
    except:
        LOGGER.logError(traceback.format_exc())
        return True


def isNotSocks5Proxy(dev):
    """
    @summary: 是否是Socks5代理
    @return: True 不是Socks5代理， False 是Socks5代理。
    """
    try:
        socks5Proxy = dev.getSocks5Proxy()
        if socks5Proxy and socks5Proxy.getServerIp():
            return False
        else:
            return True
    except:
        LOGGER.logError(traceback.format_exc())
        return True


def doCollect(context, cmd):
    """
    @summary: 调用bat文件执行信息收集，同时查看进度条
    """
    try:
        LOGGER.logInfo("check log --collect start:")
        silenceCallthread = threading.Thread(target=doSilenceCall, args=(context, cmd))
        silenceCallthread.setDaemon(True)
        silenceCallthread.start()
    except:
        LOGGER.logError(traceback.format_exc())
        return False, 'Command execute failed!'


def doSilenceCall(context, cmd):
    LOGGER.logInfo("doSilenceCall start :%s" % cmd)
    p = subprocess.Popen([cmd], stderr=subprocess.PIPE, stdout=subprocess.PIPE)
    try:
        p.communicate()
        LOGGER.logInfo("doSilenceCall exit code:%s, p.stdout:%s" % (p.returncode, p.stdout))
    except:
        LOGGER.logInfo("doSilenceCall end with exception.")
        LOGGER.logError(traceback.format_exc())

    LOGGER.logInfo("doSilenceCall end.")


def createTmpBatFile(context):
    # 创建临时文件collectInfos.bat
    file_object = None
    try:
        LOGGER.logInfo("start create tmp bat file.")
        file_object = open(TEMP_BAT_FILE, 'w')
        writeText = "".join(SILENCECALL_CMDS)

        devs = context.get("devs")
        dev = ''
        if devs and len(devs) > 0:
            dev = devs[0]

        if not dev:
            return False

        # 18000V1 jar包位置为上一层目录。
        if dev and dev.getDeviceModel() in DEV_TYPE_18000V1 and dev.getProductVersion()[0:11] in DEV_PRODUCT_18000V1:
            writeText = "".join(SILENCECALL_CMDS_FOR_18000V1)

        LOGGER.logInfo("deviceType:%s, productVersion :%s" % (dev.getDeviceModel(), dev.getProductVersion()[0:11]))

        LOGGER.logInfo("bat file writeText:%s." % writeText)

        file_object.write(writeText)
        LOGGER.logInfo("create tmp bat file successfull")
        return TEMP_BAT_FILE
    except:
        LOGGER.logError(traceback.format_exc())
    finally:
        if file_object:
            file_object.close()
    return ''


def readTaskFileXML():
    try:
        doc = minidom.parse(TASK_TEMPLET_FILE)
        return doc
    except:
        LOGGER.logError(traceback.format_exc())
        raise


def writeTaskFileXML(context, doc):
    """
    创建静默调用需要的taskFile.xml
    """
    f = ''
    pawd = ''
    publicKeyPath = ''
    publicKeyPwd = ''
    try:
        root = doc.documentElement
        workPathNode = root.getElementsByTagName("workPath")[0]
        nodeValue = BASE_ROOT_PATH + COLLECT_PATH_TEMP
        LOGGER.logInfo("workPathNode.nodeValue=" + nodeValue)
        isExists = os.path.exists(nodeValue)
        if not isExists:
            os.makedirs(nodeValue)
        workPathNodeText = doc.createTextNode(nodeValue)
        workPathNode.appendChild(workPathNodeText)

        # 对language做处理
        languageNode = root.getElementsByTagName("language")[0]
        languageText = doc.createTextNode(contextUtil.getLang(context))
        languageNode.appendChild(languageText)

        deviceListNode = root.getElementsByTagName("deviceList")[0]

        # 循环判断选中的设备 是否需要收日志，如果需要收加入task.xml.
        for dev in context.get("devs"):
            if not dev:
                LOGGER.logInfo("dev is None")
                continue

            if not dev.isNeedLog():
                continue

            user = dev.getLoginUser().getUserName()
            pawd = dev.getLoginUser().getPassword()
            if pawd is None or pawd.strip() == "":
                return False
            publicKeyPath = ''
            publicKeyPwd = ''
            ip = dev.getIp()
            devPort = str(dev.getPort())
            devVersion = dev.getProductVersion()
            deviceType = dev.getDeviceModel()
            sn = dev.getDeviceSerialNumber()

            deviceNode = doc.createElement("device")
            deviceNode.setAttribute("devIP", ip)
            deviceNode.setAttribute("devPort", devPort)
            deviceNode.setAttribute("devVersion", devVersion)
            deviceNode.setAttribute("deviceType", deviceType)
            deviceNode.setAttribute("username", AESEncrypt.encrypt128(user))
            deviceNode.setAttribute("password", AESEncrypt.encrypt128(pawd))
            deviceNode.setAttribute("serialNo", sn)
            publicKeyPath, publicKeyPwd = getPublicKeyPathAndPwd(dev)
            deviceNode.setAttribute("publicKeyPath", publicKeyPath)
            deviceNode.setAttribute("publicKeyPwd", AESEncrypt.encrypt128(publicKeyPwd))
            deviceNode.setAttribute("developerPwd", '')
            deviceNode.setAttribute("deviceName", '')
            LOGGER.logInfo("get context device info success:%s,%s,%s,%s,%s" % (ip, devPort, devVersion, deviceType, sn))
            # 如果是SSH跳转
            sshForwardStr = ''
            if not isNotSshForward(dev):
                try:
                    sshForwardStr = context.get("EntityUtils").toSshForwardJsonEncodeNew(
                        dev.getSshForwardList()).toString()
                except:
                    LOGGER.logError("tool is too old to support SshForward.")
                    LOGGER.logError(traceback.format_exc())

            deviceNode.setAttribute("ssh", sshForwardStr)

            # 是sockets5代理。
            socksStr = ''
            if not isNotSocks5Proxy(dev):
                try:
                    socksStr = context.get("EntityUtils").toOldSocks5ProxyJsonEncode(dev.getSocks5Proxy()).toString()
                except:
                    LOGGER.logError("tool is too old to support Socks5Proxy.")
                    LOGGER.logError(traceback.format_exc())

            deviceNode.setAttribute("socks5Proxy", socksStr)

            deviceListNode.appendChild(deviceNode)

        f = open(BASE_ROOT_PATH + COLLECT_PATH_TEMP + TASK_FILE, "w")
        doc.writexml(f, encoding='utf-8')
    except Exception, e:
        LOGGER.logError("write Task File XML Exception:")
        LOGGER.logException(e)
        raise
    finally:
        del pawd, publicKeyPath, publicKeyPwd
        if f:
            f.close()

    return True


def getPublicKeyPathAndPwd(dev):
    """
    @summary: 获取秘钥信息
    """
    try:
        priKey = dev.getPriKey()
        if not priKey:
            return '', ''

        return priKey.getKeyPath(), priKey.getKeyPwd()
    except:
        LOGGER.logError("getPriKey exception, PriKey is not exist.")
        LOGGER.logError(traceback.format_exc())

    return '', ''


def safeSleep(seconds):
    """
    @summary: 安全睡眠时间
    @param seconds: seconds为睡眠时间，单位：秒；数据类型：整数或小数
    """
    try:
        if type(seconds) not in [int, long, float] or seconds <= 0:
            return
        startTime = time.time()
        while True:
            if (time.time() - startTime) >= seconds:
                return
            try:
                time.sleep(0.1)
            except:
                pass
    except:
        return


def makeLogDirectory(dev):
    LOGGER.logInfo("start make log directory.")
    timeNow = datetime.datetime.now()
    timeName = "Data_" + dev.getDeviceModel() + "_" + timeNow.strftime('%Y%m%d%H%M%S')
    pathList = []
    path = os.path.join(BASE_ROOT_PATH + COLLECT_PATH_TEMP,
                        dev.getIp() + "_" + dev.getDeviceSerialNumber(),
                        timeName, "DataCollect", "system_log")
    path_7Z = os.path.join(BASE_ROOT_PATH + COLLECT_PATH_TEMP,
                           dev.getIp() + "_" + dev.getDeviceSerialNumber(), timeName)
    pathList.append(path)
    pathList.append(path_7Z)
    LOGGER.logInfo("DATA_PATH"+path)
    if not os.path.exists(path):
        os.makedirs(path)
    LOGGER.logInfo("make directory successfully.")
    return pathList

def readProgressXML():
    try:
        doc = minidom.parse(os.path.join(BASE_ROOT_PATH + COLLECT_PATH_TEMP, 'Progress.xml'))
        return doc
    except:
        LOGGER.logError(traceback.format_exc())
        raise


def writeProgressXML(doc, valueDict):
    LOGGER.logInfo("start write progress xml.")
    root = doc.documentElement
    employees = root.getElementsByTagName("device")

    for employee in employees:
        employee.setAttribute("status", valueDict.get("status"))
        employee.setAttribute("result", valueDict.get("result"))
        employee.setAttribute("progress", valueDict.get("progress"))

    f = open(os.path.join(BASE_ROOT_PATH + COLLECT_PATH_TEMP, 'Progress.xml'), 'w')
    try:
        f.write(doc.toxml(encoding="UTF-8").replace("?>", "?>\n"))
        f.close()
    except:
        LOGGER.logError(traceback.format_exc())
        f.write(doc.toxml(encoding="UTF-8"))
        f.close()
    LOGGER.logInfo("write progress xml successfully.")

def progressXml(dev):
    doc = Document()  # 创建DOM文档对象

    book = doc.createElement('progress')
    doc.appendChild(book)
    book.setAttribute('errMsg', "")
    book.setAttribute('progress', "")
    book.setAttribute('result', "")
    book.setAttribute('riskDiskNum', "")
    book.setAttribute('status', "")
    book.setAttribute('totalDiskNum', "")
    book.setAttribute('updateTime', "")

    title = doc.createElement('device')
    title.setAttribute('serialNo', dev.getDeviceSerialNumber())
    title.setAttribute('status', "")
    title.setAttribute('result', "")
    title.setAttribute('updateTime', "")
    title.setAttribute('totalTime', "")
    title.setAttribute('passRate', "")
    title.setAttribute('progress', "")
    book.appendChild(title)
    f = open(os.path.join(BASE_ROOT_PATH + COLLECT_PATH_TEMP, 'Progress.xml'), 'w')
    f.write(doc.toprettyxml(indent='\t', encoding="utf-8"))
    f.close()


def collectLog18000V1(context, path):

    try:
        lang = contextUtil.getLang(context)
        devList = context.get("devs")
        if not devList:
            return False
        dev = devList[0]
        # 生成process.xml
        progressXml(dev)
        cli = dev.getSsh()

        # 1, 下发CLI,通知OM开始收集;
        isSuccess, cliRet, errMsg = prepareCollect(cli, lang)
        if isSuccess is not True:
            return isSuccess

        isSuccess = collectAndDownload(context, dev, cli, lang, path)
        result = RESULT[0] if isSuccess else RESULT[1]
        LOGGER.logInfo("log collect" + result + str(isSuccess))
        processXmlDict(STATUS[0], MAX_PROCESS, result)

        return isSuccess
    except:
        LOGGER.logInfo("except trace back:" + str(traceback.format_exc()))
        processXmlDict(STATUS[0], MAX_PROCESS, RESULT[1])
        return False


def prepareCollect(cli, lang):
    '''
    #下发CLI,通知OM开始收集，OM通知各节点做收集的前期准备
    '''
    cmd = "show file export_path file_type=log"
    (isSuccess, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    LOGGER.logInfo("prepareCollect and the cliRet is " + str(cliRet))
    if not isSuccess:
        return False, cliRet, errMsg

    if CLI_EXECUTE_CMD_SUCCESS not in cliRet:
        return False, cliRet, errMsg

    return True, cliRet, ""

def collectAndDownload(context, dev, cli, lang, path):
    '''
    #1，轮询收集进度；2，下载收集到的文件到本地；3，删除阵列端的文件
    @return 1:True or False,收集项成功or失败
    @return 2:本项收集项的所有失败记录
    '''
    repeatTimes = PARALLEL_EXPORT_INFO_TIMEOUT * 2  # 轮训次数
    finishedNodes = []  # 已经完成的节点，包括成功和失败
    # 1，轮询收集进度
    timeLeft = PARALLEL_EXPORT_INFO_TIMEOUT * 2
    while repeatTimes != 0:
        # 更新progress.xml
        progress = str(100 - int(100*repeatTimes/timeLeft))
        processXmlDict(STATUS[1], progress)
        repeatTimes -= 30
        (isSuccess, collectStatus, cmd4statusRet) = queryCollectStatus(cli, lang)
        if isSuccess is not True:
            return isSuccess

        totalResult = collectStatus.get("totalResult")
        singleResultDict = collectStatus.get("singleResultDict")

        for nodeID in singleResultDict.keys():
            LOGGER.logInfo("nodeID" + nodeID)

            singleResult = singleResultDict.get(nodeID)

            if nodeID in finishedNodes or nodeID in ["", "--"]:
                continue

            if "successful".upper() in singleResult:
                finishedNodes.append(nodeID)

                # 通知OM取文件, 获取文件路径
                (isSuccess, cliRet, errMsg) = notificationDownload(cli, lang, nodeID)

                if not isSuccess or "File Path" not in cliRet:
                    return False
                # 下载日志
                loadSucc = downloadFile(context, cliRet, dev, path)

                deleteFile(cli, lang, nodeID)

                if not loadSucc:
                    return loadSucc

        if "Packaging" not in totalResult:
            break

        # 已30秒为间隔时间进行轮询
        safeSleep(30)

    tar_class = context.get("PYENGINE.PY_ZIP")
    compressFilePath = path[1] + ".7z"
    tar_class.compressFile(compressFilePath, path[1])
    try:
        subprocess.check_call('icacls "' + compressFilePath + '" /inheritance:d')
        subprocess.check_call('icacls "' + compressFilePath + '" /remove:g Users')
    except:
        pass
    cleanDir(path[1])
    return True


def queryCollectStatus(cli, lang):
    '''
    #轮询收集进度
    @return 1:True or False,命令执行成功
    @return 2:收集进度{"总的进度" : "" , "单个节点的进度" : {"节点" : "进度"}..}
    @return 3:cli回显
    '''
    (isSuccess, collectStatus, cliRet) = (False, {"totalResult": "", "singleResultDict": {}}, "")

    cmd = "show file package_result file_type=log"
    (isSuccess, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    LOGGER.logInfo("queryCollectStatus and the cliRet is " + str(cliRet))
    if not isSuccess:
        LOGGER.logInfo("cmd show file package_result file_type=log is failed")
        return (False, collectStatus, cliRet)

    if "Total Result" not in cliRet:
        return (False, collectStatus, cliRet)

    dictList = cliUtil.getHorizontalCliRet(cliRet)

    if len(dictList) == 0:
        return False, collectStatus, cliRet

    for oneDict in dictList:
        totalResult = oneDict["Total Result"]
        if totalResult != "" and totalResult != "--":
            collectStatus["totalResult"] = totalResult

        singleResultDict = collectStatus["singleResultDict"]
        NodeID = oneDict["Controller ID"]
        singleResult = oneDict["Single Result"]
        singleResultDict.update({NodeID: singleResult.upper()})
        collectStatus["singleResultDict"] = singleResultDict

    return (True, collectStatus, cliRet)


def processXmlDict(status, progress, result=""):
    valueDict = {"status": status, "result": result, "progress": progress}
    doc = readProgressXML()
    writeProgressXML(doc, valueDict)


def downloadFile(context, cliRet, dev, path):
    '''
    @summary: 下载收集到得文件信息到本地
    @param cliRet:  context=上下文对象
                    type=收集的类型
                    rec=命令执行成功的回显
    @return: True or False
    '''
    try:
        sftp = dev.getSftp()

        # 获取阵列端存放信息的路径和文件名称
        listRemotePaths = getRemotePathAndName(context, cliRet)
        # 下载到本地的目录信息
        for temp in listRemotePaths:
            LOGGER.logInfo("localDir" + path[0])
            localPath = os.path.join(path[0], temp["name"])
            file = File(localPath)
            sftp.getFile(temp["path"], file, None)

        return True
    except:
        LOGGER.logInfo("down load %s fail")
        LOGGER.logInfo("except trace back:" + str(traceback.format_exc()))
        return False


def getRemotePathAndName(context, rec):
    '''
    @summary: 获取阵列端的文件名称和路径
    @param cliRet:  context=上下文对象
    @return: name:阵列端产生的文件名称
             path:阵列端产生的文件的路径
    '''
    resultList = []
    cliRetList = rec.splitlines()
    for line in cliRetList:
        # 判断回显是否正常
        if COLLECT_INFO_RECROD_STANDARD in line:
            tempDict = {}
            tempList = line.split(" : ")
            path = tempList[1]
            tempList1 = path.split("/")
            name = tempList1[-1]
            tempDict["path"] = path
            tempDict["name"] = name
            resultList.append(tempDict)

    return resultList


def deleteFile(cli, lang, NodeID):
    '''
    #删除阵列端数据
    '''
    cmd = "delete file filetype=log controller_id=%s" % NodeID
    (isSuccess, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    LOGGER.logInfo("deleteFile and the cliRet is " + str(cliRet))
    if not isSuccess:
        LOGGER.logInfo("deleteFile failed because cli execute failed")


def cleanDir(Dir):
    try:
        if os.path.isdir(Dir):
            paths = os.listdir(Dir)
            for path in paths:
                filePath = os.path.join(Dir, path)
                if os.path.isfile(filePath):
                    try:
                        os.remove(filePath)
                    except os.error:
                        LOGGER.logInfo("remove " + filePath + " error.")
                        return (False, "")
                elif os.path.isdir(filePath):
                    if filePath[-4:].lower() == ".svn".lower():
                        continue
                    shutil.rmtree(filePath, True)
            os.rmdir(Dir)
        else:
            return (False, "")
        return (True, "")
    except:

        return (False, "")


def notificationDownload(cli, lang, NodeID):
    '''
    #通知OM取文件
    @return 1:True or False,命令执行成功
    @return 2:CLI回显
    '''
    cmd = "show file notification file_type=log controller_id=%s" % NodeID
    (isSuccess, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    LOGGER.logInfo("notificationDownload and the cliRet is " + str(cliRet))
    if not isSuccess:
        return (False, cliRet, errMsg)

    return (True, cliRet, errMsg)