RC=0
SCRIPT_TMP=${UP_TMP}/host
NAME=${OS}

RUNTIME=360

if [ ! -f ${CMD_EXE}/cmd_exe.main ]
then 
	echo "Unable to source file cmd_exe.main....exiting"
	RC=2
	exit ${RC}
else
	. ${CMD_EXE}/cmd_exe.main
fi

     
checking_dir

     
printf "\n\nCollecting Configuration / Log Files for ${NAME}\n" | tee -a ${RPT}

copying_file_content "/.sh_history"
copying_file_content "/.bash_history"
copying_file_content "/smit.log"
copying_file_content "/smit.script"
copying_file_content "/etc/inittab"
copying_file_content "/etc/filesystems"
copying_file_content "/etc/powermt.custom"

 if [ -f /etc/hostinfo.conf ]
then 
    copying_file_content "/etc/hostinfo.conf"
fi
	
printf "\n\nRunning ${NAME} Specific Commands\n" | tee -a ${RPT}

running_command_line "uname -a"
running_command_line "oslevel -sq"
running_command_line "instfix -i|grep ML"
running_command_line "prtconf"
running_command_line "bootinfo -K"
running_command_line "bootlist -m normal -o"
running_command_line "lppchk -v"
running_command_line "errpt -a"
running_command_line "lslpp -l"
running_command_line "lslpp -l devices.common.IBM.mpio.rte"
running_command_line "lsps -a"
running_command_line "lsfs"
running_command_line "lsdev -Cc disk"
running_command_line "lsdev -Cc adapter"
running_command_line "lsdev -Cc driver"
running_command_line "lscfg -vp"
running_command_line "lsvg"
running_command_line "lsvg -o"
running_command_line "netstat -in"
running_command_line "df -k"
running_command_line "hostname"
running_command_line "date"
running_command_line "whoami"
running_command_line "ps -ef"
running_command_line "mount"
running_command_line "env"

running_command_line "date -u"
running_command_line "id"
running_command_line "ulimit -a"
running_command_line "sar 2 5"   
running_command_line "sar -P ALL 2 5"
running_command_line "vmstat 2 5"
running_command_line "vmstat -s"
running_command_line "svmon -G"
running_command_line "ps aux |head -1 ;ps aux |sort -rn +2"
running_command_line "alog -t boot -o"
running_command_line "alog -t console -o"
running_command_line "last shutdown"
running_command_line "uptime"
running_command_line "genkex"
running_command_line "hostid"
running_command_line "crontab -l"
running_command_line "ls -l /opt"

HBA_FCHAN=`lsdev -Cc adapter | grep fchan | awk '{ print $1 }'` 
HBA_FCS=`lsdev -Cc adapter | grep fcs | awk '{ print $1 }'`
FC="${HBA_FCHAN} ${HBA_FCS}"
if [ `echo ${FC} | awk '{ print NF }'` -eq 0 ]
then
	echo "\nNo known fibre channel adapters found" | tee -a ${RPT}	
else
	for i in ${FC}
	do
		running_command_line "lscfg -vpl ${i}" 
		running_command_line "lsattr -El ${i}"
		FC_CHILD=`echo ${i} | sed -e 's/fcs/fscsi/g' -e 's/fchan/fcp/g'`
		running_command_line "lsattr -El ${FC_CHILD}"
		running_command_line "lscfg -vpl ${i}" "lscfg_vpl_fcs.txt"
		running_command_line "lsmcode -rd ${i}" "lscfg_vpl_fcs.txt"
		running_command_line "lsattr -El ${FC_CHILD}" "lscfg_vpl_fcs.txt"
		
	done
fi

if [ $COLLIPINFOFLAG -eq 1 ]
then
    NET_INFO=`lsdev -Cc if | grep en | awk '{print $1}'`
    if [ `echo ${NET_INFO} | awk '{print NF}'` -ne 0 ]
    then
	    for i in ${NET_INFO}
	    do
		    running_command_line "echo "Separator"" "ifconfig_detail"
		    running_command_line "ifconfig ${i}" "ifconfig_detail"
		    running_command_line "netstat -aI ${i}" "ifconfig_detail"
		    running_command_line "echo "Separator"" "ifconfig_detail"
	    done
    fi
fi
     
printf "\nRunning Command lsattr -El against drivers and adapters\n" | tee -a ${RPT}

for i in driver adapter
do	
	for j in `lsdev -Cc ${i} | awk '{ print $1 }'`
	do
		echo "---- lsattr -El $j ----\n" >> "${SCRIPT_TMP}/lsattr_lsdev_-Cc_${i}.txt"
		lsattr -El $j >> "${SCRIPT_TMP}/lsattr_lsdev_-Cc_${i}.txt"
		echo "\n" >> "${SCRIPT_TMP}/lsattr_lsdev_-Cc_${i}.txt"
	done
done

     
running_command_line "odmget PdAt"
running_command_line "odmget PdDv"
running_command_line "odmget PdPathAt"
running_command_line "odmget CuPathAt"

exit ${RC}
