RC=0
SCRIPT_TMP=${UP_TMP}/${SCRIPTNAME}
NAME="Logical Volume Manager"

RUNTIME=210

if [ ! -f ${CMD_EXE}/cmd_exe.main ]
then 
	echo "Unable to source file cmd_exe.main....exiting"
	RC=2
	exit ${RC}
else
	. ${CMD_EXE}/cmd_exe.main
fi

     
checking_dir

     
SCRIPT_TMP_KEEP=${SCRIPT_TMP}
echo "\nRunning ${NAME} commands for ${OS}" | tee -a ${RPT}

VG=`lsvg`
for i in ${VG}
do 
	mkdir ${SCRIPT_TMP}/${i}
	SCRIPT_TMP=${SCRIPT_TMP}/${i}

	     
	echo "Volume Group ${i}" >> ${ERR_RPT}

	printf "\nRunning Commands against Volume Group : ${i}" | tee -a ${RPT}

	lsvg ${i} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/lsvg_${i}.txt" &
	checking_overtime

	for j in -p -l
	do
		lsvg ${j} ${i} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/lsvg_${j}_${i}.txt" &
		checking_overtime
	done	

	LV=`lsvg -l ${i} 2>> ${ERR_RPT} | awk 'NR>2 { print $1 }'`

	for j in ${LV}
	do
		echo "lslv ${j} :\n" >> "${SCRIPT_TMP}/lslv.txt"
		lslv ${j} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/lslv.txt" &
		checking_overtime
		echo "--------------------------------------------------------" >> "${SCRIPT_TMP}/lslv.txt"
		
		echo "getlvcb -AT ${j} :\n" >> "${SCRIPT_TMP}/getlvcb_-AT.txt"
		getlvcb -AT ${j} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/getlvcb_-AT.txt" &
		checking_overtime
		echo "--------------------------------------------------------" >> "${SCRIPT_TMP}/getlvcb_-AT.txt"

	done

	PV=`lsvg -p $i 2>> ${ERR_RPT} | awk 'NR>2 { print $1 }'`

	for j in ${PV}
	do
		echo "lspv -l ${j} :\n" >> "${SCRIPT_TMP}/lspv_-l.txt"

		lspv -l ${j} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/lspv_-l.txt" &
		checking_overtime
		
		echo "--------------------------------------------------------" >> "${SCRIPT_TMP}/lspv_-l.txt"
	done
	SCRIPT_TMP=${SCRIPT_TMP_KEEP}
done

printf "\n\nRunning Command lsattr -El against each device " | tee -a ${RPT}
DEVICE=`lsdev -Cc disk | cut -d" " -f1`

for i in ${DEVICE}
do
	echo "lsattr -El ${i} :\n" >> "${SCRIPT_TMP}/lsattr_-El_hdisk(updisk)x.txt"
	lsattr -El ${i} 2>> ${ERR_RPT} >> "${SCRIPT_TMP}/lsattr_-El_hdisk(updisk)x.txt"
	echo "--------------------------------------------------------" >> "${SCRIPT_TMP}/lsattr_-El_hdisk(updisk)x.txt"
done

echo 
exit ${RC}
