RC=0
SCRIPT_TMP=${UP_TMP}/aix_UltraPath
NAME="UltraPath for AIX"

RUNTIME=120

if [ ! -f ${CMD_EXE}/cmd_exe.main ]
then 
	echo "Unable to source file cmd_exe.main....exiting"
	RC=2
	exit ${RC}
else
	. ${CMD_EXE}/cmd_exe.main
fi
     
checking_dir
     
printf "\n\nRunning ${NAME} Specific Commands\n" | tee -a ${RPT}

echo "---- lslpp -l U*P*.*.rte ----\n" >> "${SCRIPT_TMP}/lslpp_-l_UltraPath.txt"
lslpp -l U*P*.*.rte >> "${SCRIPT_TMP}/lslpp_-l_UltraPath.txt"
echo "\n" >> "${SCRIPT_TMP}/lslpp_-l_UltraPath.txt"
    
Check_String="huawei|huasy|symantec|ultrapath" 
FC_DISK=`lsdev -Cc disk|grep -E -i "$Check_String"|awk '{print $1}'`
for i in ${FC_DISK}
do
for info in `lspath -l $i -s available -F"connection:parent:path_id:path_status:status"`
	do
	connection=`echo $info|cut -f1 -d:`
	parent=`echo $info|cut -f2 -d:`
	path_id=`echo $info|cut -f3 -d:`
	priority=`lspath -l $i -F value -w $connection -a priority -p $parent`
	echo $i $connection $parent path_id=$path_id priority value is: $priority >> "${SCRIPT_TMP}/priority.txt"
	done
done

running_command_line "lspv"
running_command_line "lsdev|grep disk"
running_command_line "lspath"

`ls /opt/UltraPath/log >/dev/null 2>&1`
if [ $? -eq 0 ]; then
	gzip -h > /dev/null 2>&1		
	if [ $? -eq 0 ]; then		        
		CompressCmd="gzip"		        
		CompressStr="gz"		
	else		        
		CompressCmd="compress"		        
		CompressStr="Z"		
	fi	

	FileList=`ls /opt/UltraPath/log|grep log`

	for i in ${FileList}
	do
		if [ -f "/opt/UltraPath/log/${i}"  ]; then
			${CompressCmd} -c "/opt/UltraPath/log/${i}" > "${i}.${CompressStr}"	       			
			copying_file_content "${i}.${CompressStr}"	       			
			rm "./${i}.${CompressStr}"
		fi
	done
fi
	
U_exist=`lslpp -l U*.*.rte|grep "UltraPath"|wc -l`
if [ $U_exist -ne 0 ]; then
	UP_Version=`lslpp -c -l U*.*.rte|grep -E "UltraPath|UpForAIX|UPforAIX"|awk -F: '{print $3}'|cut -d'.' -f1`
	SUB_Version=`lslpp -c -l U*.*.rte|grep -E "UltraPath|UpForAIX|UPforAIX"|awk -F: '{print $3}'|cut -d'.' -f3`
	if [ ${UP_Version} -ge 6 ] && [ ${SUB_Version} -eq 803 ]; then
		running_command_line "upadm show version"     
		running_command_line "upadm show hba" 
		running_command_line "upadm show alarmenable" 
		running_command_line "upadm show path_reliability_enable" 
		running_command_line "upadm show path"
		running_command_line "upadm show array"
		running_command_line "upadm show phypath"		
		running_command_line "upadm show vlun type=all"
		running_command_line "upadm chkconfig"
		upadm show array | grep [0-9][0-9].* | awk '{print $1}' > .arrayid
		INDEX=1
		ID=`sed -n ${INDEX}p .arrayid`
		while [ "$ID" != "" ];
		do
			 if [ $ID -le 16383 ]; then
				 running_command_line "upadm show vlun array_id=$ID type=all"
				 INDEX=`expr $INDEX + 1`
				 ID=`sed -n ${INDEX}p .arrayid`
			 fi
		done
		rm .arrayid
		upadm show vlun type=all| grep [0-9][0-9].* | awk '{print $1}' > .vlunid
		INDEX=1
		ID=`sed -n ${INDEX}p .vlunid`
		ID_LAST_TIME=16383		
		while [ "$ID" != "" ];
		do
			 if [ $ID -le 16383 ]; then
			 	if [ $ID -ne $ID_LAST_TIME ];then
					running_command_line "upadm show vlun id=$ID type=all"
				fi
				 INDEX=`expr $INDEX + 1`
				 ID_LAST_TIME=$ID
				 ID=`sed -n ${INDEX}p .vlunid`
			 fi
		done
		rm .vlunid	
	elif [ ${UP_Version} -ge 6 ];then
		running_command_line "upadm show version"     
		running_command_line "upadm show vlun"
		running_command_line "upadm show path"
		running_command_line "upadm show array"
		running_command_line "upadm show phypath"
	fi
fi


exit ${RC}
