RC=0
SCRIPT_TMP=${UP_TMP}/${SCRIPTNAME}
NAME="Veritas Volume Manager"

PATH=${PATH}:/usr/lib/vxvm/diag.d:/etc/vx/diag.d:/opt/VRTS/bin
export PATH

RUNTIME=150

if [ ! -f ${CMD_EXE}/cmd_exe.main ]
then 
	echo "Unable to source file cmd_exe.main....exiting"
	RC=2
	exit ${RC}
else
	. ${CMD_EXE}/cmd_exe.main
fi

checking_dir

printf "\n\nCollecting Configuration / Log Files for ${NAME}\n" | tee -a ${RPT}

copying_file_content "/var/vx/isis/command.log" "originally_dir"
copying_file_content "/var/adm/vx/cmdlog" "originally_dir"

printf "\n\nRunning ${NAME} Specific Commands\n" | tee -a ${RPT}

running_command_line "vxdisk list"
running_command_line "vxdisk -e list"
running_command_line "vxdisk -s list"
running_command_line "vxdisk -o alldgs list"
running_command_line "vxdg list"
running_command_line "vxprint -ht"
running_command_line "vxprint -m rootdg"
running_command_line "vxdmpadm listctlr all"
running_command_line "vxdmpadm listenclosure all"
running_command_line "vxdmpdbprint"
running_command_line "vxddladm listjbod"
running_command_line "vxddladm listsupport"
running_command_line "vxdctl mode"
running_command_line "vxdctl -c mode"
running_command_line "vxlicense -p"
running_command_line "vxlicrep"
running_command_line "vxlicrep -e"
running_command_line "vxdmpadm listapm all" 
running_command_line "vxdmpadm stat restored" 

for DG in `vxdg -q list 2>> ${ERR_RPT} | awk '{ print $1 }'`
do
	running_command_line "vxdg list ${DG}"
	running_command_line "vxprint -g ${DG} -Qqm" 
done

exit ${RC}
