﻿# coding=utf-8
__author__ = '******'
# 云化评估，获取内存总大小
import re
CLI = None
LANGUAGE = None
            
cmd_info= ["cat /proc/meminfo"]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    cmd_display.put("result",cmd_execute(cmd_display, CLI, LANGUAGE))
    return cmd_display


def cmd_execute(cmd_display, CLI, LANGUAGE):
    result=''
    for index in range(len(cmd_info)):
        cmd_display_temp = CLI.execCmdNoLogTimout(cmd_info[index],60)
        result = result + extractInfo(cmd_display_temp)
    return result

def extractInfo(cmd_display):
    mem_size=0
    temp = ''
    lst = cmd_display.splitlines()
    
    for line in lst:
        if 'memtotal' in line.lower():
            temp = line 
            break
    temp = temp.lower()
    temp = temp.split(':')[1].replace('kb','')
    temp = temp.strip()
    mem_size = int(temp)
    mem_size = mem_size/1024.0/1024.0 
    mem_size = round(mem_size,2)
    return str(mem_size)
