# coding=utf-8
__author__ = '******'
# 扩展命令执行
import re
cmd_info_number = 0
cmd_info_id = "cmd_display_extend_command"
isUseJdbc = True
dbTypeList = ["Oracle", "MySQL", "SQLServer", "DB2"]

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    isUseJdbc = context.get("isUseJdbc")
    extendCmdList = context.get("extendedCommands")
    devType = context.get('deviceTypeLevel2')
    fun_err_msg = ''
    #依次执行每条命令
    for command in extendCmdList:
        cmd_display_temp = getCmdResult(context, command, devType)
        cmd_display.put(getCmdIndex(), cmd_display_temp)
        cmd_display_temp_str = ''
        
        if devType in dbTypeList:
            cmd_display_temp_str = cmd_display_temp.getSqlResult() 
                
            if None == cmd_display_temp_str or '' == cmd_display_temp_str or 'TOOLKIT_SEND_SQL_TIME_OUT' == cmd_display_temp_str:
                if "en" == LANGUAGE:
                    fun_err_msg += command + ":\texecute failed\r\n"
                else:
                    fun_err_msg += command + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += command + ":\texecute success\r\n"
                else:
                    fun_err_msg += command + u":\t执行成功\r\n"
        else:
            cmd_display_temp_str = cmd_display_temp
        
            if None == cmd_display_temp_str or '' == cmd_display_temp_str or cmd_display_temp_str.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp_str.find('TOOLKIT_EXE_CMD_FAILED') > 0 :
                if "en" == LANGUAGE:
                    fun_err_msg += command + ":\texecute failed\r\n"
                else:
                    fun_err_msg += command + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += command + ":\texecute success\r\n"
                else:
                    fun_err_msg += command + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    
    
def getCmdResult(context, command, devType):
    if devType in dbTypeList and isUseJdbc:
        CLI = context.get("DBConn")
        cmd_display_temp = CLI.execSql(command)
        return cmd_display_temp
    else:
        CLI = context.get("SSH")
        cmd_display_temp = CLI.execCmdWithTimout(command, 60)
        return cmd_display_temp

def getCmdIndex():
    '''
    @summary: get index of new command
    @param context: Python execution context.
    @return: None
    '''    
    global cmd_info_number
    cmd_info_number += 1
    return cmd_info_id + "_" + str(cmd_info_number)

