# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
from common.cliUtil import cmd_execute


class BaseDeployCollect:
    """
    获取开局信息收集主机信息基础类，所有主机收集需要继承这个类
    """
    def __init__(self, context):
        self.cli = context.get("cli")
        self.logger = context.get("logger")
        self.lang = context.get("lang")
        self.host_info = context.get("result")
        self.uiObserver = context.get("uiObserver")
        self.deployDev = context.get("deployDev")
        self.cli_ret_list = self.host_info.getCmdRetList()
        self.ULTRA_PATH = 'UltraPath'
        self.DM_MULTI_PATH = 'DM-Multipath'
        self.DMP_PATH = 'VxVM (DMP)'
        self.MPIO_PATH = 'MPIO'

    def get_info(self):
        """
        获取数据流程
        :return:
        """
        self.uiObserver.updateDeviceProgress(self.deployDev, 10)
        self.set_host_name()
        self.uiObserver.updateDeviceProgress(self.deployDev, 20)
        self.set_server_model()
        self.uiObserver.updateDeviceProgress(self.deployDev, 40)
        self.set_kernel()
        self.uiObserver.updateDeviceProgress(self.deployDev, 50)
        self.set_operating_system()
        self.uiObserver.updateDeviceProgress(self.deployDev, 60)
        self.set_multi_path_info()
        self.uiObserver.updateDeviceProgress(self.deployDev, 70)
        self.set_bus_adapter()
        self.uiObserver.updateDeviceProgress(self.deployDev, 90)

    def set_host_name(self):
        """
        设置主机名
        """
        cmd = "hostname|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        host_name = self.get_last_line(cli_ret)
        self.host_info.setHostName(host_name)
        self.cli_ret_list.add(0, "HostName:{}".format(
            host_name if host_name else "NA"))

    def set_server_model(self):
        raise NotImplementedError('Please implement in subclasses.')

    def set_os_name(self):
        raise NotImplementedError('Please implement in subclasses.')

    def set_kernel(self):
        """
        设置内核信息
        :return:
        """
        cmd = "uname -ra|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setKernel(self.get_last_line(cli_ret))

    def set_operating_system(self):
        raise NotImplementedError('Please implement in subclasses.')

    def set_multi_path_info(self):
        raise NotImplementedError('Please implement in subclasses.')

    def set_bus_adapter(self):
        raise NotImplementedError('Please implement in subclasses.')

    def get_last_line(self, cli_ret):
        """
        获取回文最后一行
        :param cli_ret:
        :return:
        """
        if not cli_ret:
            return ""
        return cli_ret.strip().splitlines()[-1].strip()

    def get_cli_ret(self, cli_ret, cmd):
        """
        获取全部回显，去除命令后
        :param cli_ret: 回显
        :param cmd: 命令
        :return:
        """
        from com.huawei.ism.tool.deploy.entity. \
            AbstractDeployInfoCollectCallableResult import CMD_EXCUTE_ERROR
        if not cli_ret:
            return ""
        if CMD_EXCUTE_ERROR == cli_ret:
            return cli_ret
        return cli_ret.strip().split(cmd)[-1].strip()

    def get_hba_card(self, hba_info_list, cmd):
        """
        获取hba卡的卡名称
        :param hba_info_list: 列表
        :param cmd: 命令
        :return:
        """
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if 'not found' in cli_ret or "command not found" in cli_ret:
            return
        hba_list = cli_ret.strip().splitlines()
        for hba in hba_list:
            hba = hba.strip()
            if cmd in hba or not hba or 'Name' in hba:
                continue
            hba_info_list.append(hba)
