#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/03/30
@file: cliUtil.py
@function:
"""
INFOGRAB_SUCESS_ERRMSGS = {"en": ":\texecute success\r\n",
                           "zh_CN": u":\t执行成功\r\n"}

INFOGRAB_FAILED_ERRMSGS = {"en": ":\texecute failed\r\n",
                           "zh_CN": u":\t执行失败\r\n"}


def exec_cmd_has_log(cli, cmd, lang):
    cli_ret = cli.execCmdHasLog(cmd)
    flag, infoGrab_err_msg = deal_cli_ret(cli_ret, cmd, lang)
    return flag, cli_ret, infoGrab_err_msg


def deal_cli_ret(cli_ret, cmd, lang):
    if cli_ret is None or '' == cli_ret or \
            cli_ret.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
            cli_ret.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        return False, cmd + INFOGRAB_FAILED_ERRMSGS.get(lang)
    else:
        return True, cmd + INFOGRAB_SUCESS_ERRMSGS.get(lang)


def exec_cmd_has_log_vmware(cli, cmd, lang):
    cli_ret = cli.execCmdHasLog(cmd)
    flag, infoGrab_err_msg = deal_cli_ret_vmware(cli_ret, cmd, lang)
    return flag, cli_ret, infoGrab_err_msg


def deal_cli_ret_vmware(cli_ret, cmd, lang):
    if cli_ret is None or '' == cli_ret or \
            ":" not in cli_ret or \
            cli_ret.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
            cli_ret.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        return False, cmd + INFOGRAB_FAILED_ERRMSGS.get(lang)
    else:
        return True, cmd + INFOGRAB_SUCESS_ERRMSGS.get(lang)


def cmd_execute(cmd_ret_list, cli, cmd, logger):
    """
    开局兼容性信息收集信息处理
    :param cmd_ret_list: 回文list集合
    :param cli: cli链接
    :param cmd: 命令
    :param logger: 日志
    :return: flag 是否成功，cli_ret 回文
    """
    from com.huawei.ism.tool.obase.exception import ToolException
    from com.huawei.ism.tool.deploy.entity.\
        AbstractDeployInfoCollectCallableResult import CMD_EXCUTE_ERROR

    cli_ret = ""
    flag = False
    try:
        cli_ret = cli.execCmdHasLogTimout(cmd, 60)
        cmd_ret_list.add(cli_ret)
        flag = True
    except (ToolException, Exception) as e:
        logger.error(e)
        cli_ret = CMD_EXCUTE_ERROR
    if (
            not cli_ret
            or cli_ret.find("TOOLKIT_SEND_CMD_TIME_OUT") > 0
            or cli_ret.find("TOOLKIT_EXE_CMD_FAILED") > 0 or not flag
    ):
        cli_ret = CMD_EXCUTE_ERROR
    return flag, cli_ret
