#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
import traceback

from common.cmd_execute import CMD, DES
from common.contentParse import get_cmd_ret


class BaseCmdExecuteOffline(object):
    def __init__(self, context):
        self.context = context
        self.display = context.get("ret_map")
        self.log = context.get("Logger")
        self.cmd_list = []

    def execute_pure_cmd_list(self):
        """
        命令执行
        """
        try:
            for cmd_dic in self.cmd_list:
                self.context["command"] = cmd_dic.get(CMD)
                self.display.put(cmd_dic.get(DES), get_cmd_ret(self.context))
        except Exception:
            self.log.error("the except info is:" + traceback.format_exc())

    def generate_relative_cmd_list(self, params, cmd_dicts):
        """
        关联命令的拼接
        :param params: 命令参数，元组的格式，即便单个参数也需要是元组的格式（"param1",）
        :param cmd_dicts: 关联命令的列表
        """
        if not params or not cmd_dicts:
            return
        for cmd_dic in cmd_dicts:
            for param in params:
                self.cmd_list.append({DES: cmd_dic.get(DES) + "_".join(param), CMD: cmd_dic.get(CMD) % param})
