# -*- coding: UTF-8 -*-
import re,os


fail_flag = "TOOLKIT_EXE_CMD_FAILED"
sendfail_flag = "TOOLKIT_SEND_CMD_TIME_OUT"


#检查命令对应的回文是否成功，成功则返回True,否则False
def is_success(templst):
    if 0 == len(templst):
        return False
    for line in templst:
        if ((fail_flag.lower() in line.lower())or (sendfail_flag.lower() in line.lower())):
            return False
    return True


#求aix多路径对象集合
def get_aixmulobj_lst(mulBlock_lst):
    block_lst = []
    mulobj_lst = []
    Multipath_Name  = "Multipath"
    UltraPath_Name  = "UltraPath"
    PowerPath_Name  = "PowerPath"
    #过滤掉失败的段
    for block in mulBlock_lst:
        if is_success(block):
            block_lst.append(block)
    for block in block_lst:
        mulObj = Multipath_Entity()
        for j,line in enumerate(block):
            #PowerPath
            if ('powermt' in line.lower())and ('version' in line.lower()) :
                if not(('not' in block[j+1].lower()) and ('found' in block[j+1].lower())):
                    mulObj.set_name(PowerPath_Name)
                    break
            #UltraPath
            elif ('upadmin' in line.lower()) and ('show' in line.lower()):
                if not(('not' in block[j+1].lower()) and ('found' in block[j+1].lower())):
                    mulObj.set_name(UltraPat)
                    for vline in block[j:]:
                        if ('version' in vline.lower()) and ('software' in vline.lower()):
                            tempArr = re.split('\\s+', vline)
                            mulObj.set_version(tempArr[3])
                            break
                    break
            #HDLM
            elif ('dlnkmgr' in line.lower()) and ('view' in line.lower()):
                if not(('not' in block[j+1].lower()) and ('found' in block[j+1].lower())):
                    mulObj.set_name('HDLM')
                    break
            #UltraPath
            elif ('upadm' in line.lower()) and ('show' in line.lower()):
                if not(('not' in block[j+1].lower()) and ('found' in block[j+1].lower())):
                    mulObj.set_name(UltraPath_Name)
                    break
            #Multipath
            elif ('multipath' in line.lower()) and ('ll' in line.lower()):
                if not(('not' in block[j+1].lower()) and ('found' in block[j+1].lower())):
                    mulObj.set_name(Multipath_Name)
                    status = '\n'.join(block[1:])
                    mulObj.set_status(status)
                    break
            else:
                pass
        mulobj_lst.append(mulObj)
    #name为NA则认为无该多路径软件
    objchecklst = []
    for mul in mulobj_lst:
        if mul.get_name() != 'NA':
            objchecklst.append(mul)
    #去掉重复的Ultrapath
    objcheckrepeat_lst = []
    has_ultra = False
    for multi in objchecklst:
        if not has_ultra:
            objcheckrepeat_lst.append(multi)
            if 'UltraPath'.lower()== multi.get_name().lower():
                has_ultra = True
        else:
            if 'UltraPath'.lower()!= multi.get_name().lower():
                objcheckrepeat_lst.append(multi)
    if 0 == len(objcheckrepeat_lst):
        mulObj = Multipath_Entity()
        objcheckrepeat_lst.append(mulObj)
        return objcheckrepeat_lst
    return objcheckrepeat_lst


class Multipath_Entity:
    __mul_name = 'NA'
    __mul_version = 'NA'
    __mul_status = 'NA'
    
    def get_name(self):
        return self.__mul_name
    def get_version(self):
        return self.__mul_version
    def get_status(self):
        return self.__mul_status
    
    def set_name(self,name):
        self.__mul_name = name
    def set_version(self,version):
        self.__mul_version = version
    def set_status(self,status):
        self.__mul_status = status


