# -*- coding: UTF-8 -*-
import re, os
import common.constants as CONSTANT 
import util
import traceback
divide = "*********^^^^^^^^^^************^^^^^^^^^^*********"
style = "python"
fail_flag = "TOOLKIT_EXE_CMD_FAILED"
sendfail_flag = "TOOLKIT_SEND_CMD_TIME_OUT"
netappfail_flag = "<RESULT_ERROR>"
#返回所有回文时用于回文行之间连接的标识
LINE_SPLIT_SIGN = '\\n'
#context
RET_MAP = 'ret_map'
LANGUAGE = 'lang'
CONNECTOR = 'connector'
#handel cmd
CMD_ERROR = '<RESULT_ERROR>'
 

# **************************************
# 函数名称: getCommandRetFromTxt
# 功能说明: 从文件中获取命令的回文
# 输入参数: filePath：文件的路径
#         command：命令
# 输出参数: 命令回文信息
# **************************************
def getCommandRetFromTxt(context):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    command = context.get("command")
    commandList = command.split(',')
    filePath = context.get("path")
    fileHandle = open(filePath, 'r')
    for i in range(len(commandList)):
        for line in fileHandle:
            if commandList[i].strip().lower() in line.strip().lower():
                flag = True
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    break
                else:
                    cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[1:len(cmdRetList)] 
    return retList


def getSingleOrMoreCommandRetFromTxt(context, comdLstOrStr, isfetchAll):
    '''
    @summary: 从回文中获取某个命令的回文或者几条相似命令的回文
    @param context :传人 的数据结构
    @param comdLstOrStr: 若为字符串则精确提取，若为列表 则模式匹配
    @param isLikeSearch : 是否模糊查询， True:模糊查询 ；False：非模糊查询 即精确查询
        
    '''
    #精确获取某个命令的回文
    retLst = []
    retLst = getSameCommandsHbaRetFromTxt(context, [comdLstOrStr])
    
    if 0 == len(retLst):
        return  retLst
        
    if not isfetchAll:
        return retLst[0]
    return retLst  



# **************************************
# 函数名称: getSameCommandsRetFromTxt
# 功能说明: 从回文文件中获取有规律的几条命令的回文,比如:
# cmd_display_hba_card_esxcli_megaraid_sas
# cmd_display_hba_card_esxcli_ata_piix
# 这种情况在模板中配置:cmd_display_hba_card_esxcli_
# 即可获取文件中所有命令中包含:cmd_display_hba_card_esxcli_的回文信息
# 输入参数: filePath：文件的路径
#         command：命令
# 输出参数: 命令回文信息
# **************************************
def getSameCommandsRetFromTxt(context):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    command = context.get("command")
    commandList = command.split(',')
    filePath = context.get("path")
    
    fileHandle = open(filePath, 'r')
    for i in range(len(commandList)):
        for line in fileHandle:
            if commandList[i].strip().lower() in line.strip().lower():
                flag = True
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append("---------***************-----------")
                else:
                    cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[0:len(cmdRetList) - 2]    
    return retList 


# **************************************
# 函数名称: getCommandRetFromTxt
# 功能说明: 从文件中获取命令的回文,并且命令带有参数
# 输入参数: filePath：文件的路径
#         command：命令(带有参数)
# 输出参数: 命令回文信息
# **************************************
def getCommandRetFromTxtWithPara(context, command):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    filePath = context.get("path")
    
    fileHandle = open(filePath, 'r')

    for line in fileHandle:
        if command.strip().lower() in line.strip().lower():
            flag = True
            continue
        if True == flag:
            if divide.strip().lower() in line.strip().lower():
                flag = False
                break
            else:
                cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[1:len(cmdRetList)]    
    return retList   

# **************************************
# 函数名称: getCommandRet
# 功能说明: 获取单条命令的回文，包括CLI命令和sql的命令
# 输入参数: CLI：cli命令
#         LANGUAGE：环境语言信息
# 输出参数: display:回文信息
# **************************************
def getSingleCommandRet(context, cmd_info_id, command):
    fun_err_msg = ''

    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    display = context.get("ret_map")
    
    cmd_display_temp = CLI.execCmdHasLogTimout(command, 60)
    if cmd_info_id.startswith ('cmd_info'):     
        display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
    else:
        display.put("sql_display" + cmd_info_id[8:], cmd_display_temp)
        
    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"
            
    display.put("err_msg", fun_err_msg)

    return display


# **************************************
# 函数名称: getSingleCommandPureRet
# 功能说明: 获取单条命令的回文
# 输入参数: CLI：cli命令
#         LANGUAGE：环境语言信息
# 输出参数: 回文原始信息
# **************************************
def getSingleCommandPureRet(context, cmd_info_id, command):
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    display = context.get("ret_map")
    fun_err_msg = display.get("err_msg")
    
    cmd_display_temp = CLI.execCmdHasLogTimout(command, 60)
    if cmd_info_id.startswith ('cmd_info'):     
        display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
    else:
        return ""
        
    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"
            
    display.put("err_msg", fun_err_msg)

    return cmd_display_temp
	
# **************************************
# 函数名称: getSingleCommandRetPureRetWithoutResCheck
# 功能说明: 获取单条命令的回文,无回显检查
# 输入参数: CLI：cli命令
#         LANGUAGE：环境语言信息
# 输出参数: 回文原始信息
# **************************************
def getSingleCommandRetPureRetWithoutResCheck(context, cmd_info_id, command):
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    display = context.get("ret_map")
    fun_err_msg = display.get("err_msg")
    if None == fun_err_msg:
        fun_err_msg = ""

    cmd_display_temp = CLI.execCmdWithNoCheckResult(command, 60)
    if cmd_info_id.startswith ('cmd_info'):
        display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)

    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"

    display.put("err_msg", fun_err_msg)

    return cmd_display_temp

# **************************************
# 函数名称: getSingleCommandPureRet
# 功能说明: 获取单条命令的回文
# 输入参数: CLI：cli命令
#         LANGUAGE：环境语言信息
# 输出参数: 回文原始信息
# **************************************
def getSingleCommandPureRetWithSpecifiedTerminator(context, cmd_info_id, command, parameterList):
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    display = context.get("ret_map")
    fun_err_msg = display.get("err_msg")
    cmd_display_temp = CLI.execCmdWithTimout(command, 5 * 60, parameterList)
    if cmd_info_id.startswith ('cmd_info'):     
        display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
    else:
        return ""
        
    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"
            
    if command == "qaucli":
        display.put("err_msg", fun_err_msg)

    return cmd_display_temp

# **************************************
# 函数名称: getCommandRet
# 功能说明: 获取CLI命令的回文
# 输入参数: context：上下文信息
#         cmd_info_id：命令描述信息
#         cmd_info_desc：具体CLI命令信息
# 输出参数: cmd_display:回文信息
# **************************************
def getCommandRet(context, cmd_info_id, cmd_info_desc):
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")

    fun_err_msg = cmd_display.get("err_msg")
    if None == fun_err_msg:
        fun_err_msg = ""

    totalPgr = context.get("totalPgr")
    startPgr = context.get("startPgr")
    prgStep = 0
    curstep = CONSTANT.PROG5 if startPgr == None else  startPgr
    if totalPgr != None:
        totalPgr = 1 if totalPgr == 0 else totalPgr
        time = 1
        if len(cmd_info_id) > totalPgr:
            time += len(cmd_info_id) / totalPgr
            prgStep = totalPgr / (len(cmd_info_id) / time)
        else:
            prgStep = totalPgr / len(cmd_info_id)
        util.updateItemProgress(context, curstep)
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = CLI.execCmdNoLogTimout(cmd_info_desc[rg], 60)
        if prgStep != 0 and (time == 1 or (rg != 0 and rg % time == 0)):
                curstep += prgStep
                util.updateItemProgress(context, curstep)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)

    return cmd_display
def setCmdRet4Report(context,cmdReturn,displayKey):
    '''
    @summary: 将采集结果设置到报告
    @param context: JAVA传入的上下文的ret_map
    @param cmdReturn: 命令行传入的回显
    @param displayKey:界面显示的Key
    '''
    retMap = context.get("ret_map")
    retMap.put(displayKey,cmdReturn)
    return None

def addMultiPathResultToFile(retMap, evalResult):	
    '''
    @summary: 将采集结果放置到用于评估的txt导入到txt文件同时放到界面显示
    @param retMap: 返回的Map
    @param evalResult: 評估結果
    '''
    retMap.put("_needEvalCmdRtn:multiPathEvalResult", evalResult)
    return None

def setCmdRet4EvalAndReport(retMap, cmdReturn, displayKey):
    '''
    @summary: 将采集结果放置到用于评估的txt导入到txt文件同时放到界面显示
    @param context: JAVA传入的上下文的ret_map
    @param cmdReturn: 命令行传入的回显
    @param displayKey:界面显示的Key
    '''
    cmdforEvalKey = "_needEvalCmdRtn:" + displayKey
    retMap.put(displayKey,cmdReturn)
    retMap.put(cmdforEvalKey,displayKey)
    return None
    
def setCmdRet4Eval(retMap,cmdReturn,displayKey):
    '''
    @summary: 将采集结果放置到用于评估的txt导入到txt文件同时放到界面显示
    @param retMap: JAVA传入的上下文内的ret_map
    @param cmdReturn: 命令行传入的回显
    @param displayKey:界面显示的Key
    '''
    cmdforEvalKey = "_needEvalCmdRtn:" + displayKey
    retMap.put(cmdforEvalKey,cmdReturn)
    return None
# **************************************
# 函数名称: getStringRet
# 功能说明: 获取CLI命令的回文
# 输入参数: context：上下文信息
#         cmd_info_id：命令描述信息
#         cmd_info_desc：具体CLI命令信息
# 输出参数: cmd_display:回文信息
# **************************************
def getStringRet(context, cmd_info_ret):
    display = context.get("ret_map")
    if len(cmd_info_ret) > 5:
        display.put("HBA_timeout_result_information", "HBA_timeout_information \r\n" + cmd_info_ret)
    return display
	
# **************************************
# 函数名称: getSqlRet
# 功能说明: 获取SQL命令的回文
# 输入参数: context：上下文信息
#         
# 输出参数: sql_display:回文信息
# **************************************
def getSqlRet(context, sql_info):
    fun_err_msg = ''
    
    CLI = context.get("DBConn")
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    totalPgr = context.get("totalPgr")
    startPgr = context.get("startPgr")
    prgStep = 0
    curstep = CONSTANT.PROG5 if startPgr == None else  startPgr
    if totalPgr != None:
        prgStep = totalPgr / len(sql_info)
        util.updateItemProgress(context, curstep)
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        if prgStep != 0:
            curstep += prgStep
            util.updateItemProgress(context, curstep)
        sql_display.put("sql_display" + (item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult():
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)

    return sql_display

# **************************************
# 函数名称: parseRetWithSep
# 功能说明: 解析
# 输入参数: retList：回文信息
#        keyWord：关键字信息
#        defaultSep：分隔符
# 输出参数: 无
# 返回值   : 关键字对应的值
# 例如：  解析 “ketword = value”结构，并且返回value。例如
#      Driver Version = @(#) fcd B.11.31.1209.01 Sep  4 2012
#      返回@(#) fcd B.11.31.1209.01 Sep  4 2012
# **************************************
def parseRetWithSep(retList, keyWord, defaultSep="="):
    value = ""
    try:
        for i in range(0, len(retList)):
            if keyWord in retList[i] or keyWord.lower() in retList[i].lower():
                value = re.split(defaultSep, retList[i])[1].strip()
                break
    except:
        return ""
        
    return value

def getValueStrFromRetWithSep(retList, keyWord, defaultSep="="):
    value = ""
    valueList = []
    try:
        for i in range(0, len(retList)):
            if keyWord in retList[i] or keyWord in retList[i].lower():
                value = re.split(defaultSep, retList[i])[1].strip()
                valueList.append(value)
    except:
        return ""
    valueList = sorted(set(valueList), key=valueList.index)  

    return ";".join(valueList)

# **************************************
# 函数名称: isBelongToList
# 功能说明: 判断字符串是否为列表中每个元素的一部分
# 输入参数: hbaTypeList：列表字符串
#         type ：字符串
# 输出参数: 无
# 返回值 ： True/False
# **************************************
def isBelongToList(hbaTypeList, type):
    for i in range(0, len(hbaTypeList)):
        if type in hbaTypeList[i]:
            return True
    
    return False

# **************************************
# 函数名称: getLinesFromRetWithKeyword
# 功能说明: 获取含有关键字的哪一行
# 输入参数: tempList：列表字符串
#         keyWordList ：查询的关键字字符串list
# 输出参数: 无
# 返回值 ： retList
# **************************************
def getLinesFromRetWithKeyword(tempList, keyWordList):
    retList = []
    for i in range(0, len(tempList)):
        for j in range (0, len(keyWordList)):
            if keyWordList[j] in tempList[i]:
                retList.append(tempList[i])
    
    return retList


def addValueToMap(dmap, style, key, value):
    if 'python' == style:
        dmap[key] = value
    if 'jython' == style:
        dmap.setdefault(key, value)
        
def getValueFMap(dmap, style, key):
    if 'python' == style:
        return dmap[key]
    if 'jython' == style:
        return dmap.get(key)


#数据迁移    
#拼json数组result
def get_jsonstr(json_arr_key, attribute_arr, value_lst):
    result = ""
    result = "{" + "\"" + json_arr_key + "\"" + ':[{'
    count = len(value_lst) / len(attribute_arr)
    match = False
    len_attr = len(attribute_arr)
    len_value = len(value_lst)
    if (0 == len_value % len_attr) and 0 != len_value:
        match = True
        for i in range(count):
            for j in range(len_attr):
                result = result + "\"" + attribute_arr[j] + "\"" + ':' + "\"" + value_lst[len_attr * i + j] + "\"" + ','
            result = result[0:-1] + '},{'
        result = result[0:-2]
        result = result + ']}'
    else:
        pass
    
    if match:
        return result
    #check result
    if not match:
        result = ""
        result = "{" + "'" + json_arr_key + "'" + ':[{'
        for j in range(len(attribute_arr)):
            result = result + "'" + attribute_arr[j] + "'" + ':' + "'" + "NA" + "'" + ','
        result = result[0:-1] + '},{'
        result = result[0:-2]
        result = result + ']}'
        return result
    else:
        pass
        
#command is "key:server_info; Server_moder:cmd_display_xxx,cmd_display_yyy;CPU_model:cmd_display_mmm"
#attrcom_dic is {} #属性名:[命令1,命令2...]
#context：出入的参数
#return:attrcom_dic
def get_attrcom_dic(context):
    command = getValueFMap(context, style, 'command')
    #去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic = {}
    try:
        for comd in command.split(';'):
            lst = comd.split(':')
            key = lst[0].strip()
        
            if (1 < len(lst))and (',' in lst[1]):
                addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
            else:
                addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
    except:
        return attrcom_dic
    return attrcom_dic


#获取属性列表字典中所有命令组成的列表
def get_purecommands_lst(attrcom_dic):
    all_comds_lst = []
    keyvalue = getValueFMap(attrcom_dic, style, 'key')[0].strip()
    for key in attrcom_dic.keys():
        value = getValueFMap(attrcom_dic, style, key)
        for i in range(len(value)):
            all_comds_lst.append(value[i])
    all_comds_lst.remove(keyvalue)
    return all_comds_lst

#根据命令出现在txt报告中的先后顺序对命令列表进行排序减少读文件的次数
#attrcom_dic is {'Server_moder': ['cmd_xxx', 'cmd_yyy'], 'CPU_model': ['cmd_mmm', 'cmd_nnn'], 'key': 'Server_Info'}
#comds:传入的所有命令
#path:txt报告路径
def get_comdslst_byfile(comds, path):
    all_comds_byfile = []
    file_handler = open(path, 'r')
    comds = ';'.join(comds)
    for line in file_handler:
        if line.strip().lower() in comds.lower():
            if "" != line.strip() and ("display" in line.lower()):
                all_comds_byfile.append(line.strip())
        else:
            continue
    file_handler.close()
    return all_comds_byfile

def get_similarcomds_byfile(comds, path):
    all_comds_byfile = []
    file_handler = open(path, 'r')
    for line in file_handler:
        if comds[0].lower() in line.strip():
            all_comds_byfile.append(line.strip())
        else:
            continue
    file_handler.close()
    return all_comds_byfile



#{属性名：[对应回文组成的列表]}
#all_filecomds:根据报告排好序的命令列表
def get_attrlst_dic(attr_comds_dic, all_filecomds, path):
    flag = False
    # {属性名:对应列表}
    attrlst_dic = {}
    key_comds_lst = []
    templst = []
    cmdRetList = []
    for i in range(len(all_filecomds)):
        comd_index = all_filecomds[i].strip().lower()
        fileHandle = open(path, 'r')
        for line in fileHandle:
            if "" == line.strip():
                continue
            if (comd_index in line.strip().lower()) and ('display' in line.lower()):
                if line.strip().lower().endswith(comd_index) or line.strip().lower().endswith(comd_index, 0, -1):
                    flag = True
                    cmdRetList.append(line)
                    continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append(divide)
                    break
                else:
                    cmdRetList.append(line.strip())
                    continue
        fileHandle.close()  
    templst = cmdRetList[0:len(cmdRetList)]
    for key in attr_comds_dic.keys():
        cmd_templst = []
        flag = False
        comds_lst = getValueFMap(attr_comds_dic, style, key)
        for comd in comds_lst:
            for line in templst:
                if comd.strip().lower() in line.lower():
                    flag = True
                    cmd_templst.append(line)
                    continue
                if True == flag:
                    if divide.strip().lower() in line.strip().lower():
                        flag = False
                        cmd_templst.append(line)
                        break
                    else:
                        cmd_templst.append(line.strip())
        addValueToMap(attrlst_dic, style, key, cmd_templst)
    return attrlst_dic


#{属性名：[对应回文组成的列表]} 相似的命令的回文，常见递归调用的时候，比如hp-ux之hba卡
#all_filecomds:根据报告排好序的命令列表
def get_attrsimilar_lst_dic(attr_comds_dic, all_filecomds, path):
    flag = False
    # {属性名:对应列表}
    attrlst_dic = {}
    key_comds_lst = []
    templst = []
    cmdRetList = []
    for i in range(len(all_filecomds)):
        fileHandle = open(path, 'r')
        for line in fileHandle:
            if "" == line.strip():
                continue
            if (all_filecomds[i].strip().lower() in line.strip().lower()) and ('cmd_display' in line.lower()):
                flag = True
                cmdRetList.append(line)
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append(divide)
                    break
                else:
                    cmdRetList.append(line.strip())
                    continue
        fileHandle.close()  
    templst = cmdRetList[0:len(cmdRetList)]
    for key in attr_comds_dic.keys():
        cmd_templst = []
        comds_lst = getValueFMap(attr_comds_dic, style, key)
        all_comds_lst = []
        
        for comd in comds_lst:
            for line in templst:
                if comd.strip().lower() in line.lower():
                    all_comds_lst.append(line) 
        
        for comd in all_comds_lst:
            for line in templst:
                if comd in line:
                    flag = True
                    cmd_templst.append(line)
                    continue
                if True == flag:
                    if divide.strip().lower() in line.strip().lower():
                        flag = False
                        cmd_templst.append(line)
                        break
                    else:
                        cmd_templst.append(line.strip())
        addValueToMap(attrlst_dic, style, key, cmd_templst)
    return attrlst_dic


#获取json数组名字
def get_jsonarr_name(attrcom_dic):
    return getValueFMap(attrcom_dic, style, "key")[0].strip()

#过滤掉值是空的项
def checktempList(tempList):
    lst = []
    for line in tempList:
        if '' != line.strip():
            lst.append(line)
    return lst

#检查回文中是否有命令失败标志或者命令长度是否为0
#是则返回True，表示当前回文对应命令执行失败
def checkList_status(tempList):
    flag = False
    if 0 == len(tempList):
        flag = True
        return flag
    
    for line in tempList:
        if fail_flag in line:
            flag = True
            return flag
    return flag

#检查命令对应的回文是否成功，成功则返回True,否则False
def is_success(templst):
    if 0 == len(templst):
        return False
    for line in templst:
        if ((fail_flag.lower() in line.lower()) or (sendfail_flag.lower() in line.lower()) or (netappfail_flag) in line.lower()):
            return False
    return True

#判断字符串 是否包含于列表中的某项
def is_belong_lst(value, templst):
    result = False
    for line in templst:
        if value.lower().strip() in line.lower():
            result = True 
            break
    return result 


def has_cluster(cluster_block_lst):
    result = False 
    if 0 == len(cluster_block_lst):
        return result

    for lst in cluster_block_lst:
        temp = is_success(lst)
        #有一个回文成功，则有该集群
        if temp == True:
            result = True
            break
    return result


def get_valuelst_bydesc(block_lst, desc):
    lst = []
    for block in block_lst:
        temp = ';'.join(block)
        if desc.lower() in temp.lower():
            lst = block
            break
    return lst

def isBelongLst(pamstr, pamlst):
    result = False
    for line in pamlst:
        if pamstr.lower() in line.lower():
            result = True
            break
    return result

#去掉列表中值为空的行
def check_lst(lst):
    new_lst = []
    for line in lst:
        if not ("" == line.strip()):
            new_lst.append(line)
    return new_lst

#查询vmware版本
#采集信息时使用
def get_vmversion(context):
    version_line = "" 
    version = ""
    result = ""
    try:
        CLI = context.get("SSH")
        version_line = CLI.execCmdHasLogTimout('vmware -l', 60)
        version = re.split('\n', version_line)[1].strip()
        
        result = re.split('\s', version)[2].strip()
        if '5.5.0' == result:
            return '5.5'
        elif '5.5' == result:
            return '5.5'
        elif '5.0.0' == result:
            return '5.0'
        elif '6' in version:
            return '6.0'
        else:
            return result
    except Exception as e:
        util.log.error(context, "find exception:%s" % str(e))


# **************************************      
#由于提取信息的时候没有传入连接对象，此处从报告中获取版本信息
#此方法主要用来获取版本号，以根据不同的版本获取不同的采集命令
#由于Vmware 5.5 / 6.0 / 6.5的命令都是一样的所以6、6.5版本返回6.0效果一样
# **************************************
def get_vmware_version_fromtxt(context):
    context['command'] = 'cmd_display_os_basic_vmware_l'
    
    versionlst = getCommandRetFromTxt(context) 
    index = 0
    version_line = ''
    version = ''
    
    if(not is_success(versionlst)):
        return 'NA'
    for i, line in enumerate(versionlst):
        if 'vmware -l' in line:
            index = i + 1
            break
    version_line = versionlst[index]
    
    version = re.split('\s+', version_line)[2].strip()
    if '5.5.0' == version:
        return '5.5'
    elif '5.5' == version:
        return '5.5'
    elif '5.0.0' == version:
        return '5.0'
    elif '6' in version:
        return '6.0'
    else:
        return version
    
    return version
        
        

def is_vmware_version_ge_55(versionParm): 
    '''
    @param versionParm: 版本参数
    @return True:大于5.5 ，False：不大于5.5 
    vmware版本是否大于5.5
    '''
    v55 = '5.5'
    version = versionParm
    if '' == version.strip() or None == version:
        return False
    
    return version >= v55 
        

# **************************************
# 函数名称: getSameCommandsRetFromTxt
# 功能说明: 从回文文件中获取有规律的几条命令的回文,比如:
# cmd_display_hba_card_esxcli_megaraid_sas
# cmd_display_hba_card_esxcli_ata_piix
# 这种情况在模板中配置:cmd_display_hba_card_esxcli_
# 即可获取文件中所有命令中包含:cmd_display_hba_card_esxcli_的回文信息
# 输入参数: filePath：文件的路径
#         command：命令
# 输出参数: 命令回文信息
# **************************************
def getSameCommandsHbaRetFromTxt(context, commandList):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    retlst_lst = []
    flag = False
    
    filePath = context.get("path")
    
    
    for i, comd in enumerate(commandList):
        fileHandle = open(filePath, 'r')
        for line in fileHandle:
            if comd.replace('\n', '').strip().lower() in line.strip().lower():
                flag = True
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append("*********^^^^^^^^^^************^^^^^^^^^^*********")
                    retlst_lst.append(cmdRetList)
                    cmdRetList = []
                else:
                    cmdRetList.append(line.strip())
        fileHandle.close()  
    return retlst_lst 

# **************************************
#command 中至少有一项包含于line中，如以下结果则为true
#command 'cmd_display_hba_card_ql_model_,cmd_display_hba_card_lp_model_'
#line cmd_display_hba_card_ql_model_xxx
# **************************************
def command_hasline(command, line):
    lst = []
    if ',' in command:
        lst = re.split(',', command)
    else:
        lst.append(command)
    for comd in lst:
        if comd.lower() in line:
            return True
    return False

# **************************************
# 根据命令描述出现在回文中的先后顺序获取有顺序的命令描述
#比如command：cmd_display_brocade_hba_card_wwpn_
#返回报告中所有含有command的命令描述，如：
#cmd_display_brocade_hba_card_wwpn_128,cmd_display_brocade_hba_card_wwpn_3...
# **************************************
def getSortedComds(context, command):
    sort_comds = []
    
    filePath = context.get("path")
    fileHandle = open(filePath, 'r')
    
    for line in fileHandle:
        if ("cmd_display_" in line):
            if command_hasline(command, line):
                sort_comds.append(line)
        else:
            continue
    fileHandle.close()
    return sort_comds
    

def singleCmdExecute(context, command, commandDesc='', isRecord=False):
    '''
    @summary:获取单一命令执行结果
    @param context: execute context 
    @param command : shell 命令
    @param commandDesc: 命令描述
    @return: (command execute whether or not success, command result) 
    '''  
    LOG = context.get("Logger")
    excuteSuccess = False
    errMsg = ''
    cli = context.get("SSH")
    language = context.get("lang")
    cmdDisplay = context.get("ret_map")
    result = cli.execCmdWithTimout(command, CONSTANT.HOST_CMD_TIMEOUT)
    if isRecord:
        cmdDisplay.put("cmd_display_" + commandDesc, result)
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if None == result or '' == result or filter(lambda x : x in result.lower(), regx):
        if "en" == language:
            errMsg = command + ":\texecute failed\r\n"
        else:
            errMsg = command + u":\t执行失败\r\n"
    else:
        if "en" == language:
            errMsg = command + ":\texecute success\r\n"
        else:
            errMsg = command + u":\t执行成功\r\n" 
        excuteSuccess = True
    if cmdDisplay.get("err_msg"):
        errMsg = cmdDisplay.get("err_msg") + errMsg
    cmdDisplay.put("err_msg", errMsg)
    LOG.info("***[" + errMsg + "]***")
    return excuteSuccess, result


def single_cmd_execute(context, command, command_desc='', is_record=False, time_out=CONSTANT.HOST_CMD_TIMEOUT):
    '''
    @summary:获取单一命令执行结果
    @param context: execute context
    @param command : shell 命令
    @param command_desc: 命令描述
    @return: (command execute whether or not success, command result)
    '''
    log = context.get("Logger")
    excute_success = False
    err_msg = ''
    cli = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")
    result = cli.execCmdWithTimout(command, time_out)
    if is_record:
        cmd_display.put("cmd_display_" + command_desc, result)
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed", "command not found", "no such file or directory",
            "not found"]
    if not result or filter(lambda x: x in result.lower(), regx):
        err_msg = get_fail_msg(command, language)
    else:
        err_msg = get_success_msg(command, language)
        excute_success = True
    if cmd_display.get("err_msg"):
        err_msg = cmd_display.get("err_msg") + err_msg
    cmd_display.put("err_msg", err_msg)
    log.info("***[" + err_msg + "]***")
    return excute_success, result


def get_fail_msg(command, language):
    if "en" == language:
        return command + ":\texecute failed\r\n"
    else:
        return command + u":\t执行失败\r\n"


def get_success_msg(command, language):
    if "en" == language:
        return command + ":\texecute success\r\n"
    else:
        return command + u":\t执行成功\r\n"


def saveAluaStatusAndCliRet2ForeEval(aluaStatus, cliRets, context):
    '''
    @summary: save alua status to foreEval.txt
    '''
    launcher = context.get("launcher")
    retMap = context.get("ret_map")
    LOG = context.get("Logger")
    jsonString = ''
    if launcher:
        otherDataMap = launcher.getOtherDataMap()
        otherDataMap.put("aluaStatus", aluaStatus)
        wwnCliRetsTmp = otherDataMap.get("wwnCliRets")
        wwnCliRets = wwnCliRetsTmp if wwnCliRetsTmp else ""
        cliRets = ''
        try:
            cliRets = unicode(wwnCliRets) + unicode(cliRets)
        except:
            cliRets = str(wwnCliRets) + str(cliRets)
            LOG.error("encode error" + cliRets)
        otherDataMap.put("cliRets", cliRets)
        jsonString = launcher.getJsonString()
    setCmdRet4Eval(retMap, jsonString, "aluaLauncher")


def save_access_status_and_cliret_2_foreval(access_status, cli_ret, err_meg,
                                            context, flag):
    """
    保存solaris版本及多路径配套检查数据进foreavl
    :param access_status:
    :param cli_ret:
    :param err_meg:
    :param context:
    :return:
    """
    if flag is True:
        return
    ret_map = context.get("ret_map")
    LOG = context.get("Logger")
    json_object = {}
    json_object["access_status"] = access_status
    cli_rets = ''
    try:
        cli_rets = unicode(cli_ret)
    except Exception as e:
        cli_rets = str(cli_ret)
        LOG.error("encode error" + cli_rets)
        LOG.error("encode error exception:" + str(e))
    json_object["cliRets"] = cli_rets.encode('utf-8')
    json_object["err_meg"] = err_meg
    setCmdRet4Eval(ret_map, str(json_object), "SolarisMpathadm")


def cmd_execute(cmd_display, cli, lan, context, cmd_info_dict):
    if len(cmd_info_dict) > 0:
        fun_err_msg = ''
        prg_step = float(CONSTANT.PROG85) / len(cmd_info_dict)
        cur_step = CONSTANT.PROG5
        util.updateItemProgress(context, cur_step)
        for cmd_info_id, cmd_info_desc in cmd_info_dict.items():
            cmd_display_temp = cli.execCmd(cmd_info_desc)
            cur_step += prg_step
            util.updateItemProgress(context, int(cur_step))
            cmd_display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
            if cmd_display_temp is None or '' == cmd_display_temp \
                    or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == lan:
                    fun_err_msg += cmd_info_desc + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc + u":\t执行失败\r\n"
            elif "en" == lan:
                fun_err_msg += cmd_info_desc + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc + u":\t执行成功\r\n"
        cmd_display.put("err_msg", fun_err_msg)
        return cmd_display
    else:
        return None


def get_attrvalue_dic(context, attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context, style, 'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst, path)
    return get_attrlst_dic(attrcom_dic, all_comds_byfile, path)

def get_attrcom_dicv2(context):
    command = getValueFMap(context, style, 'command')
    #去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic = {}
    try:
        for comd in command.split(';'):
            if comd.count(':') == 1:
                lst = comd.split(':')
                key = lst[0].strip()
                if (1 < len(lst))and (',' in lst[1]):
                    addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
                else:
                    addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
            else:
                value_lst = comd.split(':')
                key = value_lst[0].strip()
                rep = key+':'
                value = comd.replace(rep, '')
                value = value.strip()
                addValueToMap(attrcom_dic, style, key, [value])
    except:
        raise Exception("Not Leagal ,this commands..")
    return attrcom_dic


def handel_cmd_display(context, cmd_and_param):
    '''
    函数名称: handel_cmd_display
    功能说明: 接收jython传入数据，执行命令，处理数据（默认）
    输入参数: context：jython传入的数据
              cmd_list：要执行的命令
    输出参数: cmd_display:结果字典包含{命令名:命令回显,err_msg:执行结果}
    '''

    connector = context.get(CONNECTOR)
    language = context.get(LANGUAGE)
    fun_err_msg = ''
    cmd = cmd_and_param[0]
    if len(cmd_and_param) == 1:
        xml_cmd = '<%s></%s>' % (cmd, cmd)
    else:
        xml_cmd = format_cmd(cmd_and_param)
    res = connector.executeCmdHTTP(xml_cmd)
    netapp_output = check_result_msg(res, cmd)
    if 'en' == language:
        fun_err_msg += cmd + ':\texecute success\r\n'
    else:
        fun_err_msg += cmd + u':\t执行成功\r\n'
    return (netapp_output, fun_err_msg)


def check_result_msg(msg, cmd):
    '''
    函数名称: check_result_msg
    功能说明: 接收数据，判断执行结果
    输入参数: msg：传入的数据
    输出参数: is_result_pass:结果是否通过
    '''
    return_msg = '%s\r\n' % (cmd)
    is_result_pass = False
    for line in msg.splitlines():
        if '<results ' in line and 'status=' in line:
            chars = line[line.find('status='):].split()[0]
            if 'pass' in chars:
                is_result_pass = True
    if not is_result_pass:
        msg += CMD_ERROR
    return return_msg + msg

def get_xml_lst(xml, tag):
    '''
    函数名称: get_xml_lst
    功能说明: 获取xml字符串中对应tag的列表
    输入参数: xml：xml字符串
              tag：对应获取的tag
    输出参数: xml_lst:tag列表
    '''
    param = '<%s>[\s\S]*?</%s>' % (tag, tag)
    xml_lst = re.findall(param, xml)
    return xml_lst

def get_xml_item(xml, tag):
    '''
    函数名称: get_xml_item
    功能说明: 获取xml字符串中对应tag的值
    输入参数: xml：xml字符串
              tag：对应获取的tag
    输出参数: xml_lst:tag值
    '''
    xml_lst = get_xml_lst(xml, tag)
    try:
        tag_info = xml_lst[0].split('>')[1].split('<')[0]
    except Exception, e:
        return ''
    if '\\' in tag_info:
        return tag_info.replace('\\', '/')
    return tag_info

def format_cmd(cmd_and_param):
    '''
    函数名称: format_cmd
    功能说明: 将传入的列表整理成xml格式
    输入参数: cmd_and_param:命令及参数列表
    例子：[cmd,key1,value1,key2,value2]
    输出参数: xml_cmd:例子：<cmd><key1>value1</key1><key2>value2</key2></cmd>
    '''
    xml_cmd = ''
    cmd = cmd_and_param[0]
    if not len(cmd_and_param) & 1:
        raise Exception('parameters must not be odd!')
    else:
        xml_cmd += '<%s>' % cmd
        poi = 1
        while poi < len(cmd_and_param):
            key = cmd_and_param[poi]
            poi = poi + 1
            value = cmd_and_param[poi]
            poi = poi + 1
            xml_cmd += '<%s>%s</%s>' % (key, value, key)
        xml_cmd += '</%s>' % cmd
    return xml_cmd

def handel_xml_info(context, key_lst):
     #获取回文
     #获取表格字段对应命令cmd_display
    command = getValueFMap(context, style, 'command').strip()
    addValueToMap(context, style, 'command', command)
     #获取命令字典
    attrcom_dic = get_attrcom_dicv2(context)
    #对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
     #命令对应文档中回显
    attr_valuelst_dic = get_attrvalue_dic(context, attrcom_dic)
    attribute_arr = []
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() == attr.lower():
                attribute_arr.append(attr)

    return attr_valuelst_dic, json_attr_name, attribute_arr

def handle_translation_char(char):
    '''
    函数名称: handle_translation_characters
    功能说明: 处理字符串中转译的xml格式特殊字符 &<>'"
    输入参数: char:字符串
    输出参数: 转译后字符串
    '''
    trans_dict = {'&lt;': '<', '&gt;': '>', '&amp;': '&',
                  '&apos;': "'", '&quot;': '"'}
    for key in trans_dict:
        if key in char:
            if key == '&quot;':
                char = char.replace(key, "\\" + trans_dict.get(key))
            else:
                char = char.replace(key, trans_dict.get(key))
    return char


def create_result_info(context, result, cli_rets, fail_cmd, host_result_info):
    """
    :param context:
    :param result:
    :param cli_rets:
    :param fail_cmd:
    :param host_result_info:
    :return:
    """
    ret_map = context.get("ret_map")
    host_result_info.set_result(result)
    host_result_info.set_cli_ret(cli_rets)
    host_result_info.set_fail_command(fail_cmd)
    setCmdRet4Eval(ret_map, host_result_info.get_json_str(),
                   "HostLunWWNInfo")


def get_return_from_txt(context, with_blank=False):
    """
    从txt文件获取命令回显
    :param context:  上下文
    :param with_blank:  是否保留前后空格
    :return: 命令回显
    """
    cmd_ret_list = []
    flag = False
    command = context.get("command")
    file_path = context.get("path")
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if check_start_line(command, line, logger):
                flag = True
                continue
            if flag:
                if divide == line.strip().lower():
                    break
                else:
                    if with_blank:
                        cmd_ret_list.append(get_utf8_line(line, logger))
                    else:
                        cmd_ret_list.append(get_utf8_line(line.strip(), logger))
    return cmd_ret_list


def check_start_line(command, line, logger):
    """
    是否起始行
    :param command:  命令
    :param line:  回文行
    :param logger:  日志
    :return: 是否起始行
    """
    try:
        if command.startswith("cmd_display") \
                and line.strip().lower().endswith(command.strip().lower()):
            return True
        elif not command.startswith("cmd_display") \
                and not line.strip().lower().startswith("cmd_display") \
                and line.strip().lower().endswith(command.strip().lower()):
            return True
    except Exception:
        logger.error("get error, line:%s ,reason:%s" % (line, str(traceback.format_exc())))
        return False
    return False


def get_cmd_ret(context, ignore_path=False):
    """
       从data文件获取命令回显（单条）
       :param ignore_path: 是否忽略绝对路径
       :param context:  上下文
       :return: 命令回显
       """
    cmd_ret_list = get_result_from_data(context, ignore_path)
    cli_ret = "[offline] " + context.get("command") + "\n" + "".join(cmd_ret_list) + "\n"
    return cli_ret


def check_line(symbol, command, line, ignore_path, logger):
    """
    检查是否是标志行
    :param symbol: 标志（开始-结束）
    :param command:命令
    :param line: 行
    :param ignore_path:是否忽略绝对路径
    :param logger: 打印日志
    :return: 是否是起始行
    """
    try:
        if ignore_path:
            return line.startswith(symbol) and line.strip().endswith(command)
        return line.strip().endswith(symbol + command)
    except Exception:
        logger.error("get error, line:%s ,reason:%s" % (line, str(traceback.format_exc())))
        return False


def get_cmd_ret_list(context, ignore_path=False):
    """
       从data文件获取命令回显的多个回文列表（不同用户执行的同一条命令）
       :param ignore_path: 是否忽略命令前面的路径
       :param context:  上下文
       :return: 命令回显
       """
    cmd_ret_list = []
    start_flag = False
    end_flag = False
    command = context.get("command")
    file_path = context.get("reportPath")
    ret_list = []
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if check_line("StartCmd:", command, line, ignore_path, logger) \
                    and not line.startswith("echo"):
                start_flag = True
                continue
            if check_line("EndCmd:", command, line, ignore_path, logger) \
                    and not line.startswith("echo"):
                end_flag = True
            if start_flag and not end_flag:
                cmd_ret_list.append(get_utf8_line(line, logger))
            if end_flag:
                cli_ret = "[offline] "+command + "\n" + "".join(cmd_ret_list) + "\n"
                ret_list.append(cli_ret)
                cmd_ret_list = []
                start_flag = False
                end_flag = False
    if not ret_list:
        cli_ret = \
            "[offline] " + command + "\n" + "".join(cmd_ret_list) + "\n"
        ret_list.append(cli_ret)
    return ret_list


def get_sql_cmd_ret(context, ignore_path=False):
    """
       从data文件获取sql命令回显
       :param ignore_path: 是否忽略命令前面的路径
       :param context:  上下文
       :return: 命令回显
       """
    cmd_ret_list = []
    flag = False
    command = context.get("command")
    file_path = context.get("reportPath")
    # sql模式需要校验是否匹配到结束符，防止没有进入数据库的场景
    end_flag = False
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if check_line("StartCmd:", command, line, ignore_path, logger)  \
                    and "echo" not in line and "prompt" not in line:
                flag = True
                continue
            if check_line("EndCmd:", command, line, ignore_path, logger) \
                    and "echo" not in line and "prompt" not in line:
                end_flag = True
                break
            if flag:
                cmd_ret_list.append(get_utf8_line(line, logger))
    if not end_flag:
        cmd_ret_list = []
    cli_ret = "SQL> " + command + "\n" + "".join(cmd_ret_list) + "\n"
    return cli_ret


def get_sql_ret_list(context):
    """
    从data文件获取命令回显的多个回文列表（不同用户执行的同一条命令）
    :param context:  上下文
    :return: 命令回显
    """
    sql_ret_list = []
    start_flag = False
    end_flag = False
    command = context.get("command")
    file_path = context.get("reportPath")
    ret_list = []
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if check_line("StartCmd:", command, line, False, logger) \
                    and "echo" not in line and "prompt" not in line:
                start_flag = True
                sql_ret_list = []
                end_flag = False
                continue
            if check_line("EndCmd:", command, line, False, logger) \
                    and "echo" not in line and "prompt" not in line:
                end_flag = True
            if start_flag and not end_flag:
                sql_ret_list.append(get_utf8_line(line, logger))
            if end_flag:
                cli_ret \
                    = "SQL>  " + command + "\n" + "".join(sql_ret_list) + "\n"
                ret_list.append(cli_ret)
                sql_ret_list = []
                start_flag = False
                end_flag = False
    if not ret_list:
        cli_ret = "SQL> " + command + "\n" + "".join(sql_ret_list) + "\n"
        ret_list.append(cli_ret)
    return ret_list


def get_utf8_line(line, logger):
    """
    转为utf8，异常数据转码错误返回空
    :param line:  回文行
    :param logger:  日志打印
    :return: 命令回显
    """
    try:
        return unicode(line, "utf-8")
    except Exception:
        logger.error("get error, line:%s ,reason:%s" % (line, str(traceback.format_exc())))
        return ""


def get_result_from_data(context, ignore_path=False):
    """
       从data文件获取命令回显（单条）
       :param ignore_path: 是否忽略绝对路径
       :param context:  上下文
       :return: 命令回显
       """
    cmd_ret_list = []
    start_flag = False
    command = context.get("command")
    file_path = context.get("reportPath")
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if check_line("StartCmd:", command, line, ignore_path, logger):
                start_flag = True
                continue
            if check_line("EndCmd:", command, line, ignore_path, logger):
                break
            if start_flag:
                cmd_ret_list.append(get_utf8_line(line, logger))
    return cmd_ret_list
