﻿# -*- coding: UTF-8 -*-
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult
import sys
import decimal
import traceback
import constants
import re
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import LINUX
import json
class MultiPathExecuteInfo(dict):
    '''
    @summary: package multipath infomation
    '''

    def __init__(self):
        self['control'] = 'False'
        self['failCommand'] = ""
        self['cliRet'] = ""
        self['failDescribe'] = ""
        self['noRedundantPath'] = ""
    def setCliRet(self, cliRet):
        self['cliRet'] = cliRet.replace("'", "")

    def getCliRet(self):
        return self['cliRet']

    def setFailCommand(self, failCommand):
        self['failCommand'] = failCommand

    def getFailCommand(self):
        return self['failCommand']

    def setfailDescribe(self, failDescribe):
        self['failDescribe'] = failDescribe

    def getFailDescribe(self):
        return self['failDescribe']

    def setControl(self, control):
        self['control'] = str(control)

    def getControl(self):
        return self['control']

    def setNoRedundantPath(self, noRedundantPath):
        self['noRedundantPath'] = noRedundantPath

    def getNoRedundantPath(self):
        return self['noRedundantPath']

class MultipathCoexistenceInfo(dict):
    '''
    @summary: package multipath coexistence Infomation
    '''

    def __init__(self):
        self['coexistence'] = 'False'
        self['huaweiMultipath'] = MultiPathExecuteInfo()
        self['selfMultiPath'] = MultiPathExecuteInfo()
        self['SelfMultipathInfo'] = []

    def setCoexistence(self, coexistence):
        self['coexistence'] = str(coexistence)

    def setHostIP(self, hostIP):
        self['hostIP'] = str(hostIP)

    def setHuaweiMultipath(self, huaweiMultipath):
        self['huaweiMultipath'] = huaweiMultipath

    def getHuaweiMultipath(self):
        return self['huaweiMultipath']

    def setSelfMultiPath(self, selfMultiPath):
        self['selfMultiPath'] = selfMultiPath

    def getSelfMultiPath(self):
        return self['selfMultiPath']

    def setSelfMultipathInfo(self, SelfMultipathInfo):
        self['SelfMultipathInfo'].append(SelfMultipathInfo)

    def getSelfMultipathInfo(self):
        return self['SelfMultipathInfo']

    def getJsonStr(self):
        '''
        @summary: get the dictionary string
        '''
        return str(self).replace("u'", "'")

class SelfMultipathInfo(dict):
    '''
    @summary: iscsi network self multipath Infomation
    '''

    def __init__(self):
        self['diskName'] = ''
        self['networkType'] = ''
        self['path'] = []

    def setDiskName(self, diskName):
        self['diskName'] = str(diskName)

    def setNetworkType(self, networkType):
        self['networkType'] = str(networkType)

    def setPath(self, path):
        self['path'].append(path)

    def getPath(self):
        return self['path']

    def getJsonStr(self):
        '''
        @summary: get the dictionary string
        '''
        return str(self).replace("u'", "'")

class HostResultInfo(dict):
    def __init__(self):
        self['result'] = ''
        self['errMsg'] = {}
        self['cliRets'] = ''
        self['failCommand'] = ''
        self['host'] = []

    def set_result(self, result):
        self['result'] = str(result)

    def get_result(self):
        return self['result']

    def set_cli_ret(self, cli_ret):
        self['cliRets'] = cli_ret.encode('utf-8')

    def get_cli_ret(self):
        return self['cliRets']

    def set_err_msg(self, key, value):
        self['errMsg'] = dict(key=key, value=value)

    def get_err_msgt(self):
        return self['errMsg']

    def set_fail_command(self, failure_command):
        self['failCommand'] = str(failure_command)

    def get_fail_command(self):
        return self['failCommand']

    def set_hosts(self, host):
        """
        为保持和存储接口一致，只会有一个主机信息。
        :param host:
        :return:
        """
        self['host'] = []
        self['host'].append(host)

    def get_hosts(self):
        return self['host']

    def get_json_str(self):
        return (json.dumps(self, encoding="UTF-8", ensure_ascii=False))


class HostLunInfo(dict):
    def __init__(self):
        self['hostID'] = ''
        self['initiator'] = []
        self['lunWWN'] = []

    def set_host_id(self, host_id):
        self['hostID'] = str(host_id)

    def get_host_id(self):
        return self['hostID']

    def set_initiator(self, initiator):
        self['initiator'] = initiator

    def get_initiator(self):
        return self['initiator']

    def set_lun_wwn(self, lun_wwn_dict):
        self['lunWWN'].append(lun_wwn_dict)

    def get_lun_wwn(self):
        return self['lunWWN']


class LunWwnInfo(dict):
    def __init__(self):
        self['ID'] = ""
        self['WWN'] = ""
        self['HOST_LUN_ID'] = []

    def set_id(self, lun_id):
        self['ID'] = str(lun_id)

    def get_id(self):
        return self['ID']

    def set_wwn(self, wwn):
        self['WWN'] = str(wwn)

    def get_wwn(self):
        return self['WWN']

    def set_host_lun_id(self, host_lun_id):
        self['HOST_LUN_ID'] = host_lun_id

    def get_host_lun_id(self):
        return self['HOST_LUN_ID']


def create_lun_info(host_lun_info, wwn_dict):
    """
    :param host_lun_info:
    :param wwn_dict:
    :return:
    """
    for key, value in wwn_dict.items():
        lun_wwn_info = LunWwnInfo()
        # 为了兼容未获取host lun id的场景
        if isinstance(value, dict) and value.get(constants.HOST_LUN_ID):
            lun_wwn_info.set_id(value.get(constants.DISK_NAME, ""))
            lun_wwn_info.set_host_lun_id(
                list(set(value.get(constants.HOST_LUN_ID, []))))
        else:
            lun_wwn_info.set_id(value)
        lun_wwn_info.set_wwn(key[4:] if key.startswith("WWN_") else key)
        host_lun_info.set_lun_wwn(lun_wwn_info)


def check_ultrapath_is_pass(context, ultrapath_version, host_cur_version):
    """
    :param context:
    :param ultrapath_version:
    :param host_cur_version:
    :return:
    """
    if not ultrapath_version:
        return False

    tup_ver = getUltrapathIntVer(context, ultrapath_version)
    consistency_tup_ver = \
        getUltrapathIntVer(context, host_cur_version)

    if tup_ver < consistency_tup_ver:
        return False
    else:
        log.info(context, 'the ultrapath version greater or equal to '
                          '%s, set the result pass.' % host_cur_version)
        return True


def covert_jlist_to_plist(jlist):
    """
    :param jlist:
    :return:
    """
    ret = []
    if jlist is None:
        return ret
    for i in range(jlist.size()):
        ret.append(str(jlist.get(i)))
    return ret


def get_host_wwn_info(context):
    """
    :param context:
    :return:
    """
    launcher = context.get("launcher")
    if launcher:
        iscsi_wwns = covert_jlist_to_plist(launcher.getiSCSIWwns())
        fc_wwns = covert_jlist_to_plist(launcher.getFcWwns())
        ib_wwns = covert_jlist_to_plist(launcher.getIBWwns())
        initiator_wwn = iscsi_wwns + fc_wwns + ib_wwns
        log.info(context, "initiator_wwn:%s" % initiator_wwn)
        other_data_map = launcher.getOtherDataMap()
        cli_rets = other_data_map.get("wwnCliRets") if other_data_map.get(
            "wwnCliRets") else ""
        return True, cli_rets, initiator_wwn
    else:
        log.error(context, "Cannot find host initiator info.")
        return False, '', ''


class log():

    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL = 5, skipLastLevel = True):
        #从堆栈中获取调用函数和行号

        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1

        #生成函数调用关系
        callerInfo = ""
        for _ in range(0, MAX_CALLER_LEVEL):

            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" + str(lineNumber) + "]" + callerInfo
            else:
                break

            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break

        #返回函数调用关系
        return callerInfo

    @staticmethod
    def debug(context, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：context=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def error(context, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：context=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def info(context, info):
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def warn(context, info):
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            return False

def parseWwpn(context, wwpn):
    """
    从wwpn中解析引擎和平面
    :param context: 上下文
    :param wwpn: wwpn
    :return: 解析结果
    """
    try:
        ret = parse_wwpn(wwpn)
        log.info(context, "wwpn=%s, parse ret=%s" % (wwpn, str(ret)))
    except Exception as e:
        log.error(context, "parse error:" + str(e))
        return False, -1, -1
    return ret


def parse_wwpn(wwpn):
    """
    从wwpn中解析引擎和平面
    :param wwpn: 端口wwpn
    :return: 成功标志，引擎mac地址，平面编号
    """
    wwpn = wwpn.replace(':', '')
    wwpn = wwpn.replace("0x", "")
    wwpn = wwpn.replace("0X", "").strip()
    if not re.match(r"^[0-9A-Fa-f]{16}$", str(wwpn)):
        return False, -1, -1
    wwpn = int(wwpn, 16)
    prefix = wwpn >> 52 & 0xff
    if prefix >= 0x80:
        # 共享卡
        node_id = parse_wwpn_by_slot(wwpn)
    else:
        # 非共享卡
        node_id = wwpn >> 52 & 0x7
    eng_mac = wwpn & 0xffffffffffff
    return True, eng_mac, node_id


def parse_wwpn_by_slot(wwpn):
    """
    共享卡通过槽位号判断平面
    :param wwpn: wwpn
    :return: node id
    """
    prefix = wwpn >> 52 & 0xff
    slot_id = prefix - 0x80
    if slot_id <= 0xd:
        node_id = 0
    elif slot_id <= 0x1b:
        node_id = 1
    else:
        node_id = -1
    return node_id


def query_show_path_info(context, cmd):
    """
    查询自研多路径路径信息，保存至上下文
    :param context: 上下文
    :param cmd: 查询命令
    """
    context["ultra_path_info"] = {}
    cli = context.get("SSH")
    show_path_ret = cli.execCmdWithNoCheckResult(cmd,
                                                 constants.HOST_CMD_TIMEOUT)
    ultra_path_info = parse_show_path_ret(show_path_ret)
    context["ultra_path_info"] = ultra_path_info
    log.info(context, "ultra_path_info=%s" % ultra_path_info)
    return "\r\n" + show_path_ret


def parse_show_path_ret(show_path_ret):
    """
    解析字眼多路径信息
    :param show_path_ret: 命令回显
    :return: 所有路径数据字典
    """
    ret = dict()
    for line in show_path_ret.splitlines():
        line = line.strip().lower()
        items = line.split()
        if len(items) < 5:
            continue
        path_id = items[0]
        port_wwn = items[4]
        ret[path_id] = dict(
            path_id=path_id,
            port_wwn=port_wwn
        )
    return ret


def check_lun_redundant_by_path_id(context, path_ids):
    """
    检查单个lun的path是否冗余
    :param context: 上下文
    :param path_ids: lun所在的path id
    :return: True：冗余
    """
    all_ultra_paths = context.get("ultra_path_info", {})
    node_ids = []
    for path_id in path_ids:
        path_info = all_ultra_paths.get(path_id)
        wwn = path_info.get("port_wwn")
        _, _, node_id = parseWwpn(context, wwn)
        node_ids.append(node_id)
    return hasRedundantPathForCtrlIdPath(context, node_ids, True)


def add_ultra_path_id(line, path_ids):
    """
    解析路径回显，加入到路径列表中
    :param line: 命令回显
    :param path_ids: 路径列表
    """
    matched = re.match(r"path (\d+).*normal", line.strip().lower())
    if matched:
        path_ids.append(matched.group(1))


def is_exist_shared_card(line):
    return line.strip().lower().startswith("shared interface modules")

def qryUltrapathVersion(context, isVMware=False):
    '''
    @summary: Query the HUAWEI ultrapath version.
    @param context: Python execution context.
    @return (isQrySucc, ultrapathVersion, cliRet)
    '''
    cliRet = ''
    cli = context.get("SSH")
    if not cli:
        return False, '', ''

    try:
        cmd = constants.ULTRA_PATH_VERSION_COMMAND if isVMware else \
            get_sudo_cmd(constants.QRY_ULTRAPATH_CMD, LINUX, context)
        cliRet = cli.execCmdWithNoCheckResult(cmd, constants.HOST_CMD_TIMEOUT)
        verPattern = 'Software Version|UltraPath for Linux|Driver   Version'
        if re.search(verPattern, cliRet, re.I):
            for line in cliRet.splitlines():
                if re.search(verPattern, line, re.I):
                    return True, line.split(':')[1].strip(), cliRet

        return True, '', cliRet
    except:
        log.error(context, 'Query ultrapath version exception:' + traceback.format_exc())
        return False, '', cliRet

def qryAndSaveUltrapathVersion(context):
    '''
    @summary: 查询多路径版本并保存到HTML
    @param param: context 上下文
    '''
    isSuccess, version, cliReturn = qryUltrapathVersion(context)
    cmdDisplay = context.get("ret_map")
    cmdDisplay.put("cmd_display_multipath_version_huawei", cliReturn)
    return isSuccess, version, cliReturn
def getUltrapathIntVer(context, ver):
    '''
    @summary: Convert String version to a tuple with 3 version.
    @param context: Python execution context.
    @param ver: String version.
    @return: version tuple such as (5, 1, 17)
    '''
    try:
        return tuple(map(int, ver.split('.')))
    except:
        log.error(context, 'Convert ultrapath version exception:' + traceback.format_exc())
        return (0, 0, 0)

def qryMultipathdStatus(context):
    '''
    @summary: Query the multipathd status (Linux multipath service status).
    @param context: Python execution context.
    @return (isQrySucc, isMultipathdRunning, cliRet)
    '''
    cli = context.get("SSH")
    if not cli:
        return False, False, ''

    cliRet = ''
    endStr = ['#', '$', '>', '(press RETURN)']
    try:
        cliRet = cli.execCmdWithNoCheckResult(
            get_sudo_cmd(constants.QRY_MULTIPATHD_STATUS, LINUX, context),
            constants.HOST_CMD_SHORT_TIMEOUT)
        if 'multipathd: unrecognized service' in cliRet or 'command not found' in cliRet :
            reCheckCmd = 'ps -e | grep multipathd |cat'
            cliRet = cli.execCmdWithNoCheckResult(reCheckCmd,
                                       constants.HOST_CMD_SHORT_TIMEOUT)
            injectRet2Context(context, cliRet, 'cmd_display_multipathd_status', reCheckCmd)

            irRunning = cliRet.replace(reCheckCmd, '').find('multipathd') > -1
            cmdResult = reCheckCmd + '\r\nmultipathd:'
            return True, irRunning, cmdResult + 'running' if irRunning else cmdResult + ':stopped'
        if "(press RETURN)" in cliRet:
            cliRet = cliRet + cli.execCmdWithNoCheckResult("\r",
                                       constants.HOST_CMD_SHORT_TIMEOUT)
        if "running" in cliRet.lower() or u"正在运行" in cliRet or re.search("multipathd\s+\(pid\s+\d+\)", cliRet):
            return True, True, cliRet
        injectRet2Context(context, cliRet, 'cmd_display_multipathd_status', constants.QRY_MULTIPATHD_STATUS)

        return True, False, cliRet
    except:
        log.error(context, 'Query multipathd service status exception:' + traceback.format_exc())
        return False, False, cliRet

def getArrayIdsManagedByUltrapath(context):
    '''
    @summary: Query the array id of all storage array managed by ultrapath.
    @param context: Python execution context.
    @return (isQrySucc, ArrayIDList, cliRet)
    '''
    cli = context.get("SSH")
    if not cli:
        return False, [], ''
    try:
        cliRet = cli.execCmdWithNoCheckResult(
            get_sudo_cmd(constants.QRY_ARRAY_ID_CMD, LINUX, context),
            constants.HOST_CMD_TIMEOUT)

        injectRet2Context(context, cliRet, 'cmd_display_multipath_showArray', constants.QRY_ARRAY_ID_CMD)
        arrayIdList = []
        isDataStart = False
        for line in cliRet.splitlines():
            if not isDataStart and re.search('Array ID', line, re.I):
                isDataStart = True
                continue

            fields = line.split()
            if isDataStart and len(fields) >= 3:
                if fields[0].isdigit():
                    arrayIdList.append(fields[0])

        return True, arrayIdList, cliRet
    except:
        log.error(context, 'Query array IDs exception:' + traceback.format_exc())
        return False, [], ''

def getVlunIdsManagedByUltrapath(context, isMiddleVer = True):
    '''
    @summary: Query the vlun id of all storage array managed by ultrapath.
    @param context: Python execution context.
    @return (isQrySucc, vlunIDList, cliRet)
    '''
    cli = context.get("SSH")
    if not cli:
        return False, [], ''
    try:
        vluIdCmd = constants.QRY_VLUN_ID_CMD if isMiddleVer else constants.High_VER_QRY_VLUN_ID_CMD
        vluIdCmd = get_sudo_cmd(vluIdCmd, LINUX, context)
        cliRet = cli.execCmdWithNoCheckResult(vluIdCmd, constants.HOST_CMD_TIMEOUT)

        vlunIdList = []
        isDataStart = False
        for line in cliRet.splitlines():
            if not isDataStart and re.search('Vlun ID', line, re.I):
                isDataStart = True
                continue

            fields = line.split()
            if isDataStart and len(fields) >= 3:
                if fields[0].isdigit():
                    vlunIdList.append(fields[0].strip())

        #De-duplicate same LUN ID for hyper metro LUN.
        return True, list(set(vlunIdList)), cliRet
    except:
        log.error(context, 'Query VLUN IDs exception:' + traceback.format_exc())
        return False, [], ''


def genEvalItemObj(itemKey, evalResult, cliRet, errMsgKey, paraList = None, selfMultipathInfoList = None):
    '''
    @summary: Create an evaluate result object of Java ItemEvalResult type.
    @param evalResut: Evaluate result.
    @param errMsgKey: error message key
    @param cliRet: CLI return message.
    @param paraList:Error message parameter list of string type.
    @return: item evaluate result.
    '''
    itemEvalResult = ItemEvalResult(itemKey, evalResult)
    itemEvalResult.setCliRet(cliRet)
    itemEvalResult.setErrMsgKey(errMsgKey)
    itemEvalResult.setErrParas(paraList)
    if selfMultipathInfoList:
        itemEvalResult.setSelfMultiPathInfo(str(selfMultipathInfoList).replace("u'", "'"))
    return itemEvalResult

def genEvalItemObjNoCliRet(itemKey, evalResult, errMsgKey, paraList = None):
    '''
    @summary: Create an evaluate result object of Java ItemEvalResult type.
    @param evalResut: Evaluate result.
    @param errMsgKey: error message key
    @param paraList:Error message parameter list of string type.
    @return: item evaluate result.
    '''
    itemEvalResult = ItemEvalResult(itemKey, evalResult)
    itemEvalResult.setErrMsgKey(errMsgKey)
    itemEvalResult.setErrParas(paraList)
    return itemEvalResult
def hasRedundantPathForCtrlIdPath(context, lunPath, isNodeId = False):
    '''
    @summary: Check whether the LUN has redundant path.
    @param context: Python execution context.
    @param lunPath: LUN PATH list, such as ['0A', '0B', '1A', '1B'] or [0, 1, 2, 3]
    @return: True if redundant else False.
    '''
    if not lunPath:
        return False
    try:
        if not isNodeId:
            lunPath = list(map(str.upper, map(str, lunPath)))
            lunPath = list(set(lunPath))
            evenPth = list(filter(lambda ctrlId: ctrlId[-1] in ['A', 'C', '0', '2'], lunPath))
            oddPth = list(filter(lambda ctrlId: ctrlId[-1] in ['B', 'D', '1', '3'], lunPath))
        else:
            evenPth = list(filter(lambda ctrlId: ctrlId in [0, 2], lunPath))
            oddPth = list(filter(lambda ctrlId: ctrlId in [1, 3], lunPath))

        return len(evenPth) > 0 and len(oddPth) > 0
    except:
        log.error(context, 'check redundant path exception:' + traceback.format_exc())
        return False

def chkSingleLunPathRedundant(context, vlunPthRet):
    '''
    @summary: Check single LUN path, for migration LUN, ignore and check pass.
    @param context: Python execution context.
    @param vlunPthRet: The command result of upadmin show vlun id = < LUNID >
    @return:(isHyperMetroLUN, chkPass, lunWWN / lunSN)
    '''

    isHyperMetorLun = False
    if re.search('Aggregation.*Type.*Hyper.*Metro.*', vlunPthRet, re.I):
        isHyperMetorLun = True
        log.info(context, 'This is hyper metro LUN.')
        firstSubLunStartIdx = vlunPthRet.find('Aggregation Member#0')
        secondSubLunStartIdx = vlunPthRet.find('Aggregation Member#1')

    if re.search('Aggregation.*Type.*Migration.*', vlunPthRet, re.I):
        log.info(context, 'This is a migration LUN, ignore and check pass.')
        return False, True, ""

    if not isHyperMetorLun:
        _, isRedundant, lunWwn = checkLunPathRedundant(context, vlunPthRet)
        return False, isRedundant, ("WWN_" + lunWwn) if lunWwn else ""
    elif -1 == firstSubLunStartIdx and -1 == secondSubLunStartIdx:#Fast fail.
        log.error(context, 'two sub LUN not found, check failed.')
        return True, False, ""
    elif -1 == firstSubLunStartIdx:#Fast fail.
        log.error(context, 'first sub LUN not found, check failed.')
        sndSubLunArrSN, _, _ = checkLunPathRedundant(context, vlunPthRet[secondSubLunStartIdx:])
        return True, False, ("SN_" + sndSubLunArrSN) if sndSubLunArrSN else ""
    elif -1 == secondSubLunStartIdx:#Fast fail.
        log.error(context, 'second sub LUN not found, check failed.')
        fstSubLunArrSN, _, _ = checkLunPathRedundant(context, vlunPthRet[:secondSubLunStartIdx])
        return True, False, ("SN_" + fstSubLunArrSN) if fstSubLunArrSN else ""
    else:
        fstSubLunArrSN, fstLunRedundant, _ = checkLunPathRedundant(context, vlunPthRet[:secondSubLunStartIdx])
        sndSubLunArrSN, sndLunRedundant, _ = checkLunPathRedundant(context, vlunPthRet[secondSubLunStartIdx:])
        if not fstSubLunArrSN or not sndSubLunArrSN or fstSubLunArrSN == sndSubLunArrSN:
            log.error(context, 'A pair of hyper metro LUNs are from the same array, check failed.')
            temp = fstSubLunArrSN if fstSubLunArrSN else (sndSubLunArrSN if sndSubLunArrSN else "")
            return True, False, ("SN_" + temp) if temp else ""
        else:
            return True, fstLunRedundant and sndLunRedundant, "SN_" + fstSubLunArrSN + "\SN_" + sndSubLunArrSN

def checkLunPathRedundant(context, vlunPthRet):
    '''
    @summary: 检查单个非双活LUN的路径是否冗余或者双活LUN的一个子LUN的链路是否冗余.
    @param context: Python上下文.
    @param vlunPthRet: 单个非双活LUN的路径回显或者双活LUN回显的一部分（单个子LUN回显信息).
    @return:(isChkSucc, isRedundant)
    '''
    lun_path_ids = []
    vlunPthList = []
    arraySN, vlunPth = '', ''

    #新增加LUNWWN信息
    lunWwn = ''
    exist_shared_card = False
    for line in vlunPthRet.splitlines():
        line = line.strip().lower()
        add_ultra_path_id(line, lun_path_ids)

        if 'array sn' in line:
            arraySN = line.split(':')[1].strip()

        if 'lun wwn' in line:
            lunWwn = line.split(':')[-1].strip()

        if line.startswith('controller'):
            vlunPth = line.split()[-1].strip()

        if is_exist_shared_card(line):
            exist_shared_card = True

        if vlunPth and line.startswith('path'):
            vlunPthSta = line.split(':')[-1].strip()
            if vlunPthSta == 'normal':
                vlunPthList.append(vlunPth)
    if exist_shared_card and vlunPthList:
        log.info(context, "exist two type card")
        return arraySN, False, lunWwn
    is_redundant = hasRedundantPathForCtrlIdPath(context, vlunPthList)
    if not is_redundant:
        # 老版本多路径+共享卡场景，controller不冗余，但path可能是冗余的
        is_redundant = check_lun_redundant_by_path_id(context, lun_path_ids)
    return arraySN, is_redundant, lunWwn


def getTargetPortNum(context):
    '''
    @summary: 获取目标器端口编号(存储上报给目标器的）.
    @param context: Python执行上下文环境.
    @return: isQrySucc, portNumbers, cliRet:
                            portNumbers:端口编号列表，如：['0:0:0', '0:0:1']。
    '''
    cli = context.get("SSH")
    if not cli:
        return False, [], ''
    try:
        cliRet = ''
        cliRet = cli.execCmdWithNoCheckResult(constants.QRY_DEV_NAME_CMD,
                                    constants.HOST_CMD_TIMEOUT)
        injectRet2Context(context, cliRet, 'cmd_display_multipath_targetPort', constants.QRY_DEV_NAME_CMD)
        portNums = []
        tgtPortNumPattern = re.compile(constants.TARGET_PORT_NUM_PATTERN)
        for line in cliRet.splitlines():
            line = line.strip()
            portNumMathObj = tgtPortNumPattern.search(line)
            if portNumMathObj:
                portNums.append(portNumMathObj.group())
        return True, list(set(portNums)), cliRet
    except:
        log.error(context, 'Query target port numbers exception:' + traceback.format_exc())
        return False, [], cliRet


def getTargetPortNumByMultipath(context, isCoexistence = False):
    '''
    @summary: 解析multipaht - ll命令回文，获取目标器端口编号(存储上报给目标器的）.
    @param context: Python执行上下文环境.
    @return: isQrySucc, portNumbers, cliRet:
                            portNumbers:端口编号列表，如：['0:0:0', '0:0:1']。

    '''
    cli = context.get("SSH")
    tgtPortNumPattern = re.compile(constants.TARGET_PORT_NUM_PATTERN, re.I)
    newDiskPattern = re.compile(constants.NEW_HW_DISK_PATTERN, re.I)
    newDiskUpPattern = re.compile(constants.NEW_HW_DISK_PATTERN_UP, re.I)
    aboveStaPattern = re.compile('.+prio.+(active|enabled)', re.I)
    host_lun_id_rex = re.compile(r"\d+:\d+:\d+:\d+", re.I)
    #获取自带多路径的磁盘和LUNWWN信息
    lunInfoPattern = re.compile('(3+.*) dm\-', re.I)
    lun_info_pattern_change = re.compile(r'\((3+.*) dm\-', re.I)
    #自带多路径的磁盘和LUN WWN信息字典
    diskNameWwnDict = {}
    host_lun_id_dict = {}
    cliRet = ''
    portNums = []
    if not cli:
        return False, [], '', {}, host_lun_id_dict
    try:
        cliRet = cli.execCmdWithNoCheckResult(constants.QRY_DISK_PTH_MANAGED_BY_MULTIPATHD_CMD,
                                              constants.HOST_CMD_TIMEOUT)

        lines = cliRet.splitlines()
        maxIdx = len(lines)
        i = 0
        while i < maxIdx:
            #如果自研和自带共存且自带硬盘类型中有up字段，直接返回共存，联系研发工程师。回文如下格式：
            '''linux:~ # multipath -ll |cat
            36fce33c1009980350110b6570000003c dm-60 up,updisk
            size=10G features='0' hwhandler='0' wp=rw
            `-+- policy='round-robin 0' prio=1 status=active
              `- 10:0:1:61 sddc 70:160 active ready running
            36fce33c100998035011027ee00000012 dm-18 up,updisk
            size=10G features='0' hwhandler='0' wp=rw
            `-+- policy='round-robin 0' prio=1 status=active
              `- 10:0:1:19 sdt  65:48  active ready running
            '''
            diskNameUpMatchObj = newDiskUpPattern.search(lines[i])

            if diskNameUpMatchObj and isCoexistence:
                return False, ["UPTYPE"], cliRet, {}, host_lun_id_dict

            diskNameMatchObj = newDiskPattern.search(lines[i])

            if '(' not in lines[i]:
                lunInfoMatchObj = lunInfoPattern.search(lines[i])
            else:
                lunInfoMatchObj = lun_info_pattern_change.search(lines[i])

            if diskNameMatchObj:
                #获取磁盘与WWN字典
                lunInfo = lunInfoMatchObj.group(1).strip()
                lunInfo = lunInfo[:-1] if ')' in lunInfo else lunInfo
                diskName = diskNameMatchObj.group().split()[0].strip()
                diskNameWwnDict[diskName] = ("WWN_" + lunInfo[1:]) if lunInfo else ""
                if lunInfo[1:]:
                    host_lun_id_dict[lunInfo[1:]] = dict(disk_name=diskName,
                                                         host_lun_id=[])
                j = i + 2
                while j < maxIdx and not newDiskPattern.search(lines[j]) and j + 1 < maxIdx:
                    aboveStaMatchObj = aboveStaPattern.search(lines[j])
                    if aboveStaMatchObj:  # 找到第一个状态值后，遍历查找其下的所有正常路径。
                        pthIdx = j + 1
                        tgtPortNumMatchObj = tgtPortNumPattern.search(
                            lines[pthIdx])
                        while tgtPortNumMatchObj:  # 匹配到TGT端口号.
                            res = host_lun_id_rex.search(lines[pthIdx])
                            if 'active' in lines[pthIdx] and res:
                                # 取x:x:x:j 中的j未host lun id
                                host_lun_id = host_lun_id_dict[
                                    lunInfo[1:]].get(constants.HOST_LUN_ID)
                                host_lun_id.append(
                                    res.group().strip().split(":")[-1])
                            tgtPortNum = tgtPortNumMatchObj.group()
                            portNums.append(tgtPortNum)
                            # Find next path in next line.
                            pthIdx += 1
                            if pthIdx >= maxIdx:
                                j = pthIdx
                                break
                            tgtPortNumMatchObj = tgtPortNumPattern.search(lines[pthIdx])
                        else:  # 非路径行，下一行可能是状态行或者新的磁盘信息。
                            j = pthIdx
                    else:
                        j += 1
                else:  # Inner while loop end, to find a new disk.
                    i = j
            else:
                i += 1
        log.info(context, 'Query target port numbers are:' + str(list(set(portNums))))
        log.info(context, 'get host lun id dict:' + str(host_lun_id_dict))
        return True, list(
            set(portNums)), cliRet, diskNameWwnDict, host_lun_id_dict
    except:
        log.error(context, 'Query target port numbers exception:' + traceback.format_exc())
        return False, [], cliRet, {}, {}

def buildMultiPathVersion(hwMultiPathVer, buildInMultiPathInfo):
    '''
    @summary: 生成多路径状态信息
    @param param: hwMultiPathVer 自研多路径信息
    @param param: buildInMultiPathInfo 自带多路径信息
    '''
    result = {'HuaweiMultipathVersion': 'NA', 'SelfMultiPath': 'disabled'}
    findResult = re.findall(r'.+:\s+\d+.\d{2}.\d{3}', hwMultiPathVer, re.I)
    if len(findResult) > 0:
        result['HuaweiMultipathVersion'] = findResult[0].split(':')[-1].strip()
    for line in buildInMultiPathInfo:
        if ('正在运行' in line or 'running' in line.lower()):
            result['SelfMultiPath'] = 'enabled'
            break
    return str(result).replace("u\'", "\'")
def getPortNumPathDict(context, tgtPortNums):
    '''
    @summary: 获取目标器端口编号(存储上报给目标器的）.
    @param context: Python执行上下文环境.
    @param tgtPortNums: TGT端口编号的列表，如：['0:0:0', '0:0:1']。
    @return: 端口号到路径的映射字典:
                            如：{'0:0:0':'0A', '0:0:1':'0b'} or {'0:0:0':0, '0:0:1':1}。
    '''
    if not tgtPortNums:
        return {}, ''

    cli = context.get("SSH")
    if not cli:
        return {}, ''

    tgtPortPthMap = {}
    allCliRet = ''
    for tgtPortNum in tgtPortNums:
        try:
            qryTgtPortPthCmd = constants.QRY_TGT_PORT_PATH_CMD % tgtPortNum
            cliRet = cli.execCmdWithNoCheckResult(qryTgtPortPthCmd,
                                                  constants.HOST_CMD_TIMEOUT)
            injectRet2Context(context, cliRet, 'cmd_display_multipath_portNum' + tgtPortNum, qryTgtPortPthCmd)

            if "no such file" in cliRet.lower():
                tgtPortPthMap[tgtPortNum] = tgtPortNum  #ISCSI 路径标志
                continue

            allCliRet += ('\n' + cliRet)
            for line in cliRet.splitlines():
                line = line.strip()
                if line.startswith('0x'):
                    isParseSucc, _, nodeId = parseWwpn(context, line)
                    if not isParseSucc:
                        log.error(context, 'Parse WWPN failed:' + unicode(line))
                        break
                    else:
                        tgtPortPthMap[tgtPortNum] = nodeId
        except:
            log.error(context, 'Query target port number:' + unicode(tgtPortNum)
                       + ' exception:' + traceback.format_exc())
            continue

    return tgtPortPthMap, allCliRet

def errorMsgHandler(errorMessage, cmdReturn, cmdDesc, LANGUAGE):
    '''
    @summary: 将错误消息进行组装
    @param param: errorMessage 命令返回
    @param param: cmdReturn CMD命令回显
    @param param: cmdDesc CMD描述
    '''
    if cmdReturn.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdReturn.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            errorMessage += cmdDesc + ":\texecute failed\r\n"
        else:
            errorMessage += cmdDesc + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            errorMessage += cmdDesc + ":\texecute success\r\n"
        else:
            errorMessage += cmdDesc + u":\t执行成功\r\n"
    return errorMessage

def isCmdExecError(cmdReturn):
    '''
    @summary: 判断命令是否执行失败
    @param param: cmdReturn CMD命令回显
    '''
    if cmdReturn.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdReturn.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        return True
    return False

def stripOriginalStr(originalStr):
    '''
    @summary: 回文切分处理
    @param originalStr: original result of command
    @return: list
    '''
    return list(map(lambda line : line.strip(), originalStr.splitlines()))

def getOldErrMsg(context):
    '''
    @summary: 从上下文中获取已经存在的errMsg
    @param context: 全局上下文
    '''
    cmdErrMsg = ''
    try:
        cmdErrMsg = context.get('ret_map').get('err_msg')
        if not cmdErrMsg:
            cmdErrMsg = ''
    except:
        log.error(context, 'get old error message failed.')
    return cmdErrMsg

def injectRet2Context(context, cmdret, cmdId, cmdValue):
    '''
    @summary: 有些命令没有放到html报告，使用此方法将回显和执行结果放到全局上下文即可
    @param context: 全局上下文
    @param cmdret: 命令的回显
    @param cmdId: 命令Id
    @param cmdValue: 命令
        
    '''
    cmdErrMsg = getOldErrMsg(context)
    #如果 cmdId没有在全局上下文里面才放入，避免重复
    if cmdId not in cmdErrMsg:
        cmdErrMsg += errorMsgHandler('', cmdret, cmdValue, context.get("lang"))
        context.get("ret_map").put(cmdId, cmdret)
        context.get('ret_map').put('err_msg', cmdErrMsg)

def buildOldAndNewErrMsg(context, cmdValue, cmdRet):
    '''
    @summary: 根据回显、命令构造新的errMsg
    @param context: 全局上下文
    @param cmdValue: 命令
    @param cmdRet: 命令回显
    '''
    cmdErrMsg = getOldErrMsg(context)
    cmdErrMsg += errorMsgHandler('', cmdRet, cmdValue, context.get("lang"))
    return cmdErrMsg

def updateItemProgress(context, progress):
    '''
    @summary: 刷新采集项的进度
    @param param: context 上下文
    @param progress: progress 进度
    '''
    uiObsver = context.get("uiObsver")
    uiObsver.updateProgress(progress)

def itemProgressIncr(context, curCmdIdx, perStepProg, stepsUnit):
    '''
        @summary: 根据对象的多少刷新进度
        @param param: context 上下文
        @param param: curCmdIdx 命令的索引
        @param param: perStepProg 每个命令刷新进度的数据：float
        @param progress: stepsUnit 几条命令刷新一次
        '''
    if stepsUnit == 1:
        addItemProgress(context, perStepProg)
        return
    if curCmdIdx % stepsUnit == 0 and curCmdIdx != 0:
        addItemProgress(context, perStepProg)

def addItemProgress(context, inCreaseProgress):
    '''
    @summary: 刷新采集项的进度
    @param param: context 上下文
    @param progress: progress 进度
    '''
    uiObsver = context.get("uiObsver")
    uiObsver.addItemProgress(inCreaseProgress)

def calcPerStepDetail(totalPrg, cmdNum):
    '''
    @summary: 计算几个命令刷新百分之1 和一个命令刷新的进度
    @param param: context 上下文
    @param progress: progress 进度
    '''
    cmdNum = 1 if cmdNum == 0 else cmdNum
    perStep = totalPrg / cmdNum
    if perStep != 0:
        return perStep, 1
    perStepDet = round(float(totalPrg) / float(cmdNum), 1)
    for idx in range(10):
        perStep = (idx + 1) * perStepDet
        if '.0' in str(perStep):
            return int(perStep), (idx + 1)
    return 0, 1


def compare_version(version1, version2):
    """
    比较版本号大小，如果前一个版本号小于第二个版本号，则返回负数，大于返回正数，等于返回0
    版本号格式 x.x.x.x，调用前务必进行格式校验，否则会抛出异常
    :param version1:
    :param version2:
    :return:
    """
    version1_list = version1.split(r'.')
    version2_list = version2.split(r'.')
    if len(version1_list) > len(version2_list):
        minleng = len(version2_list)
    else:
        minleng = len(version1_list)
    diff = 0
    for i in range(minleng):
        diff = int(version1_list[i]) - int(version2_list[i])
        if diff != 0:
            break
    if diff == 0:
        diff = len(version1_list) - len(version2_list)
    return diff


def chang_unit2_gb(str_value):
    """
    根据传入的值转换单位为GB
    :param str_value: 传入值
    :return: GB
    """
    try:
        float_value = 0.0
        if not str_value:
            return float_value
        str_value = str_value.upper()
        if re.search("BYTE", str_value):
            float_value = \
                float(str_value.split('B')[0].strip()) / 1024 / 1024 / 1024
        elif re.search("T", str_value):
            float_value = float(str_value.split('T')[0].strip()) * 1024
        elif re.search("G", str_value):
            float_value = float(str_value.split('G')[0].strip())
        elif re.search("M", str_value):
            float_value = float(str_value.split('M')[0].strip()) / 1024
        elif re.search("K", str_value):
            float_value = float(str_value.split('K')[0].strip()) / 1024 / 1024
        else:
            return float_value
        return float_value
    except Exception:
        return -1.0


def is_digit(str_value):
    """
    检查是否是数字，包括小数
    :param str_value:
    :return: 是否
    """
    regex = re.compile(r"^(\d+)(\.\d*)?$")
    if re.match(regex, str_value):
        return True
    else:
        return False


def get_collect_cli_result(result, lang):
    """
    infograb执行结果
    :param result:
    :param lang:
    :return:
    """
    if result is True:
        if "en" == lang:
            collect_result = ":\texecute success\r\n"
        else:
            collect_result = u":\t执行成功\r\n"

    else:
        if "en" == lang:
            collect_result = ":\texecute failed\r\n"
        else:
            collect_result = u":\t执行失败\r\n"
    return collect_result


def error_msg_handler(cmd_return, cmd_desc, LANGUAGE):
    '''
    @summary: 将错误消息进行组装
    @param param: errorMessage 命令返回
    @param param: cmdReturn CMD命令回显
    @param param: cmdDesc CMD描述
    '''
    flag = True
    error_message = ''
    if cmd_return.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_return.find(
            'TOOLKIT_EXE_CMD_FAILED') > 0:
        flag = False
        if "en" == LANGUAGE:
            error_message = cmd_desc + ":\texecute failed\r\n"
        else:
            error_message = cmd_desc + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            error_message = cmd_desc + ":\texecute success\r\n"
        else:
            error_message = cmd_desc + u":\t执行成功\r\n"
    return flag, error_message


def batch_execute(context, cmd_list, flush_progress=True):
    """
    批量执行命令，返回执行结果
    :param context: 上下文
    :param cmd_list: 执行的命令列表（命令+描述）
    :param flush_progress: 是否刷新进度（默认刷新）
    :return: 数据
    """
    cmd_display = context.get("ret_map")
    cli = context.get("SSH")
    language = context.get("lang")
    logger = context.get("Logger")
    fun_err_msg = ''
    if flush_progress:
        prg_step = constants.PROG85 / len(cmd_list)
        cur_step = constants.PROG5
        updateItemProgress(context, cur_step)
    try:
        for cmd_dic in cmd_list:
            cmd = cmd_dic.get("cmd")
            cmd_display_temp = cli.execCmd(cmd)
            if flush_progress:
                cur_step += prg_step
                updateItemProgress(context, cur_step)
            cmd_display.put(cmd_dic.get("description"), cmd_display_temp)
            fun_err_msg += check_result(cmd_display_temp, cmd, language)
        cmd_display.put("err_msg", fun_err_msg)
    except Exception:
        logger.error("the except info is:" + traceback.format_exc())
    return cmd_display


def check_result(cmd_display_temp, cmd, language):
    """
    获取命令执行情况
    :param cmd_display_temp: 回文
    :param cmd: 命令
    :param language: 语言
    """
    if not cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
            or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == language:
            return "%s:\texecute failed\r\n" % cmd
        else:
            return u"%s:\t执行失败\r\n" % cmd
    else:
        if "en" == language:
            return "%s:\texecute success\r\n" % cmd
        else:
            return u"%s:\t执行成功\r\n" % cmd
