# --*-- coding:utf-8 --*--
import sys 
import os
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import *
S_STYLE = 'jython'

#hba卡超时时间检查
def execute(context):
    
    hba_timeout = context.get('hbaTimeOut')
    isFC = False
    isIscsi = False
    result = False
    reason = ""
    styleLst = []
    fc_lst = []
    iscsi_lst = []
    
    styleLst = getNetWorkStyle(hba_timeout)
    isFC = isBelongLst('fc',styleLst)
    isIscsi = isBelongLst('iscsi',styleLst)
    
    fc_lst = getFcIscsiLst(hba_timeout, 'fc')
    iscsi_lst = getFcIscsiLst(hba_timeout, 'iscsi')
    if isFC:
        r_map = checkFC(fc_lst)
        result = r_map.get('result')
        reason = r_map.get('reason')
    if isIscsi:
        r_map = checkFC(iscsi_lst)
        result = r_map.get('result')
        reason = r_map.get('reason')
    if reason == "" :
        reason = "cloudservice.compatibility.compat.hbacard.timeout"
    context['result']=result
    context['reason']=reason
    return context


#获取组网方式
def getNetWorkStyle(tmostr):
    style_lst=[]
    if 'fc_remote_ports' in tmostr:
        style_lst.append('fc')
    if 'iscsiadm' in tmostr:
        style_lst.append('iscsi')
    return style_lst


# 获取FC组网/iscsi组网回文的列表
def getFcIscsiLst(hba_timeout,param):
    result={}
    fc_lst = []
    iscsi_lst = []
    fc_index=0
    iscsi_index=0
    length = 0
    allLst = hba_timeout.splitlines()
    
    length = len(allLst)

    for i in range(length):
        if "fc_remote_ports" in allLst[i].lower():
            fc_index=i
            continue
        elif "iscsiadm" in allLst[i].lower():
            iscsi_index=i
            continue
    
    #判断fc组网/sicsi组网在回文中出现的先后顺序
    if fc_index<iscsi_index:
        #先出现fc组网的回文
        for i in range(length):
            if "iscsiadm" in allLst[i].lower():
                iscsi_index = i
                break
        fc_lst = allLst[0:iscsi_index]
        iscsi_lst = allLst[iscsi_index:]
    else:
        for i in range(length):
            if "fc_remote" in allLst[i].lower():
                fc_index = i
                break
        iscsi_lst = allLst[0:fc_index]
        fc_lst = allLst[fc_index:]
    
    result = {'fc_lst':fc_lst,'iscsi_lst':iscsi_lst}
    
    if 'fc' == param:
        return getValueFMap(result, S_STYLE, 'fc_lst')
    elif 'iscsi' == param:
        return getValueFMap(result, S_STYLE, 'iscsi_lst')
    else:
        return []


# 判断checkIscsi组网是否通过，通过返回：result_map{result:True,reason:''},
# 不通过返回result_map{result:False,reason:'xxxx'}
def checkIscsi(iscsi_lst):
    temp_map = {}
    result = True
    reason = ''
    
    for i,line in enumerate(iscsi_lst) :
        if ('iscsiadm' in line) and (i+1<len(fc_lst)):
            addValueToMap(temp_map, S_STYLE, line, iscsi_lst[i+1])
        else:
            pass
    for eachKey in temp_map.keys():
        temp = getValueFMap(temp_map, S_STYLE, eachKey)
        temp = temp.split('=')
        temp = temp[1].strip()
        
        if not ('5' == temp):
            result=False
            reason = reason+eachKey+' : '+temp_map[eachKey]+','
            reason = reason+eachKey+' : '+getValueFMap(temp_map, S_STYLE, eachKey)+','
    reason = reason[0:len(reason)-1]
    
    if result:
        return {'result':result,'reason':''}
    else:
        return {'result':result,'reason':'cloudservice.compatibility.compat.hbacard.timeoutbyiscsi'}
    

# 功能说明: 判断fc组网是否通过，通过返回：result_map{result:True,reason:''},
# 不通过返回result_map{result:False,reason:'xxxx'}
def checkFC(fc_lst):
    temp_map = {}
    result = True
    reason = ''
    
    for i,line in enumerate(fc_lst):
        if (not line.strip().isdigit()) and (i+1<len(fc_lst)):
             addValueToMap(temp_map, S_STYLE, line, fc_lst[i+1])   
    for eachKey in temp_map.keys():
        if not ('5' == temp_map.get(eachKey)):
            result=False
            reason = reason+eachKey+' : '+getValueFMap(temp_map, S_STYLE, eachKey)+','
    reason = reason[0:len(reason)-1]

    if result:
        return {'result':result,'reason':''}
    else:
        return {'result':result,'reason':'cloudservice.compatibility.compat.hbacard.timeoutbyfc'}
